/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.location.model.DimensionUnit;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TruckDimensions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TruckDimensions> {
    private static final SdkField<Double> HEIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Height").getter(TruckDimensions.getter(TruckDimensions::height)).setter(TruckDimensions.setter(Builder::height)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Height").build()}).build();
    private static final SdkField<Double> LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Length").getter(TruckDimensions.getter(TruckDimensions::length)).setter(TruckDimensions.setter(Builder::length)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Length").build()}).build();
    private static final SdkField<String> UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Unit").getter(TruckDimensions.getter(TruckDimensions::unitAsString)).setter(TruckDimensions.setter(Builder::unit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()}).build();
    private static final SdkField<Double> WIDTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Width").getter(TruckDimensions.getter(TruckDimensions::width)).setter(TruckDimensions.setter(Builder::width)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Width").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEIGHT_FIELD, LENGTH_FIELD, UNIT_FIELD, WIDTH_FIELD));
    private static final long serialVersionUID = 1L;
    private final Double height;
    private final Double length;
    private final String unit;
    private final Double width;

    private TruckDimensions(BuilderImpl builder) {
        this.height = builder.height;
        this.length = builder.length;
        this.unit = builder.unit;
        this.width = builder.width;
    }

    public final Double height() {
        return this.height;
    }

    public final Double length() {
        return this.length;
    }

    public final DimensionUnit unit() {
        return DimensionUnit.fromValue(this.unit);
    }

    public final String unitAsString() {
        return this.unit;
    }

    public final Double width() {
        return this.width;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.height());
        hashCode = 31 * hashCode + Objects.hashCode(this.length());
        hashCode = 31 * hashCode + Objects.hashCode(this.unitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.width());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TruckDimensions)) {
            return false;
        }
        TruckDimensions other = (TruckDimensions)obj;
        return Objects.equals(this.height(), other.height()) && Objects.equals(this.length(), other.length()) && Objects.equals(this.unitAsString(), other.unitAsString()) && Objects.equals(this.width(), other.width());
    }

    public final String toString() {
        return ToString.builder((String)"TruckDimensions").add("Height", (Object)this.height()).add("Length", (Object)this.length()).add("Unit", (Object)this.unitAsString()).add("Width", (Object)this.width()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Height": {
                return Optional.ofNullable(clazz.cast(this.height()));
            }
            case "Length": {
                return Optional.ofNullable(clazz.cast(this.length()));
            }
            case "Unit": {
                return Optional.ofNullable(clazz.cast(this.unitAsString()));
            }
            case "Width": {
                return Optional.ofNullable(clazz.cast(this.width()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TruckDimensions, T> g) {
        return obj -> g.apply((TruckDimensions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double height;
        private Double length;
        private String unit;
        private Double width;

        private BuilderImpl() {
        }

        private BuilderImpl(TruckDimensions model) {
            this.height(model.height);
            this.length(model.length);
            this.unit(model.unit);
            this.width(model.width);
        }

        public final Double getHeight() {
            return this.height;
        }

        public final void setHeight(Double height) {
            this.height = height;
        }

        @Override
        @Transient
        public final Builder height(Double height) {
            this.height = height;
            return this;
        }

        public final Double getLength() {
            return this.length;
        }

        public final void setLength(Double length) {
            this.length = length;
        }

        @Override
        @Transient
        public final Builder length(Double length) {
            this.length = length;
            return this;
        }

        public final String getUnit() {
            return this.unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        @Transient
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        @Transient
        public final Builder unit(DimensionUnit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        public final Double getWidth() {
            return this.width;
        }

        public final void setWidth(Double width) {
            this.width = width;
        }

        @Override
        @Transient
        public final Builder width(Double width) {
            this.width = width;
            return this;
        }

        public TruckDimensions build() {
            return new TruckDimensions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TruckDimensions> {
        public Builder height(Double var1);

        public Builder length(Double var1);

        public Builder unit(String var1);

        public Builder unit(DimensionUnit var1);

        public Builder width(Double var1);
    }
}

