/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.location.model.LocationResponse;
import software.amazon.awssdk.services.location.model.MapConfiguration;
import software.amazon.awssdk.services.location.model.PricingPlan;
import software.amazon.awssdk.services.location.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeMapResponse
extends LocationResponse
implements ToCopyableBuilder<Builder, DescribeMapResponse> {
    private static final SdkField<MapConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Configuration").getter(DescribeMapResponse.getter(DescribeMapResponse::configuration)).setter(DescribeMapResponse.setter(Builder::configuration)).constructor(MapConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTime").getter(DescribeMapResponse.getter(DescribeMapResponse::createTime)).setter(DescribeMapResponse.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSource").getter(DescribeMapResponse.getter(DescribeMapResponse::dataSource)).setter(DescribeMapResponse.setter(Builder::dataSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DescribeMapResponse.getter(DescribeMapResponse::description)).setter(DescribeMapResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> MAP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MapArn").getter(DescribeMapResponse.getter(DescribeMapResponse::mapArn)).setter(DescribeMapResponse.setter(Builder::mapArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MapArn").build()}).build();
    private static final SdkField<String> MAP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MapName").getter(DescribeMapResponse.getter(DescribeMapResponse::mapName)).setter(DescribeMapResponse.setter(Builder::mapName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MapName").build()}).build();
    private static final SdkField<String> PRICING_PLAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PricingPlan").getter(DescribeMapResponse.getter(DescribeMapResponse::pricingPlanAsString)).setter(DescribeMapResponse.setter(Builder::pricingPlan)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlan").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(DescribeMapResponse.getter(DescribeMapResponse::tags)).setter(DescribeMapResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdateTime").getter(DescribeMapResponse.getter(DescribeMapResponse::updateTime)).setter(DescribeMapResponse.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_FIELD, CREATE_TIME_FIELD, DATA_SOURCE_FIELD, DESCRIPTION_FIELD, MAP_ARN_FIELD, MAP_NAME_FIELD, PRICING_PLAN_FIELD, TAGS_FIELD, UPDATE_TIME_FIELD));
    private final MapConfiguration configuration;
    private final Instant createTime;
    private final String dataSource;
    private final String description;
    private final String mapArn;
    private final String mapName;
    private final String pricingPlan;
    private final Map<String, String> tags;
    private final Instant updateTime;

    private DescribeMapResponse(BuilderImpl builder) {
        super(builder);
        this.configuration = builder.configuration;
        this.createTime = builder.createTime;
        this.dataSource = builder.dataSource;
        this.description = builder.description;
        this.mapArn = builder.mapArn;
        this.mapName = builder.mapName;
        this.pricingPlan = builder.pricingPlan;
        this.tags = builder.tags;
        this.updateTime = builder.updateTime;
    }

    public final MapConfiguration configuration() {
        return this.configuration;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final String dataSource() {
        return this.dataSource;
    }

    public final String description() {
        return this.description;
    }

    public final String mapArn() {
        return this.mapArn;
    }

    public final String mapName() {
        return this.mapName;
    }

    public final PricingPlan pricingPlan() {
        return PricingPlan.fromValue(this.pricingPlan);
    }

    public final String pricingPlanAsString() {
        return this.pricingPlan;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.mapArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.mapName());
        hashCode = 31 * hashCode + Objects.hashCode(this.pricingPlanAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMapResponse)) {
            return false;
        }
        DescribeMapResponse other = (DescribeMapResponse)((Object)obj);
        return Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.dataSource(), other.dataSource()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.mapArn(), other.mapArn()) && Objects.equals(this.mapName(), other.mapName()) && Objects.equals(this.pricingPlanAsString(), other.pricingPlanAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.updateTime(), other.updateTime());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeMapResponse").add("Configuration", (Object)this.configuration()).add("CreateTime", (Object)this.createTime()).add("DataSource", (Object)this.dataSource()).add("Description", (Object)this.description()).add("MapArn", (Object)this.mapArn()).add("MapName", (Object)this.mapName()).add("PricingPlan", (Object)this.pricingPlanAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("UpdateTime", (Object)this.updateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "DataSource": {
                return Optional.ofNullable(clazz.cast(this.dataSource()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "MapArn": {
                return Optional.ofNullable(clazz.cast(this.mapArn()));
            }
            case "MapName": {
                return Optional.ofNullable(clazz.cast(this.mapName()));
            }
            case "PricingPlan": {
                return Optional.ofNullable(clazz.cast(this.pricingPlanAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "UpdateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMapResponse, T> g) {
        return obj -> g.apply((DescribeMapResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationResponse.BuilderImpl
    implements Builder {
        private MapConfiguration configuration;
        private Instant createTime;
        private String dataSource;
        private String description;
        private String mapArn;
        private String mapName;
        private String pricingPlan;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMapResponse model) {
            super(model);
            this.configuration(model.configuration);
            this.createTime(model.createTime);
            this.dataSource(model.dataSource);
            this.description(model.description);
            this.mapArn(model.mapArn);
            this.mapName(model.mapName);
            this.pricingPlan(model.pricingPlan);
            this.tags(model.tags);
            this.updateTime(model.updateTime);
        }

        public final MapConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        @Override
        public final Builder configuration(MapConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final void setConfiguration(MapConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        public final String getDataSource() {
            return this.dataSource;
        }

        @Override
        public final Builder dataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final void setDataSource(String dataSource) {
            this.dataSource = dataSource;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getMapArn() {
            return this.mapArn;
        }

        @Override
        public final Builder mapArn(String mapArn) {
            this.mapArn = mapArn;
            return this;
        }

        public final void setMapArn(String mapArn) {
            this.mapArn = mapArn;
        }

        public final String getMapName() {
            return this.mapName;
        }

        @Override
        public final Builder mapName(String mapName) {
            this.mapName = mapName;
            return this;
        }

        public final void setMapName(String mapName) {
            this.mapName = mapName;
        }

        public final String getPricingPlan() {
            return this.pricingPlan;
        }

        @Override
        public final Builder pricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
            return this;
        }

        @Override
        public final Builder pricingPlan(PricingPlan pricingPlan) {
            this.pricingPlan(pricingPlan == null ? null : pricingPlan.toString());
            return this;
        }

        public final void setPricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public DescribeMapResponse build() {
            return new DescribeMapResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LocationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeMapResponse> {
        public Builder configuration(MapConfiguration var1);

        default public Builder configuration(Consumer<MapConfiguration.Builder> configuration) {
            return this.configuration((MapConfiguration)((MapConfiguration.Builder)MapConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder createTime(Instant var1);

        public Builder dataSource(String var1);

        public Builder description(String var1);

        public Builder mapArn(String var1);

        public Builder mapName(String var1);

        public Builder pricingPlan(String var1);

        public Builder pricingPlan(PricingPlan var1);

        public Builder tags(Map<String, String> var1);

        public Builder updateTime(Instant var1);
    }
}

