/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.location.model.PositionCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDevicePositionsResponseEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListDevicePositionsResponseEntry> {
    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceId").getter(ListDevicePositionsResponseEntry.getter(ListDevicePositionsResponseEntry::deviceId)).setter(ListDevicePositionsResponseEntry.setter(Builder::deviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceId").build()}).build();
    private static final SdkField<List<Double>> POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Position").getter(ListDevicePositionsResponseEntry.getter(ListDevicePositionsResponseEntry::position)).setter(ListDevicePositionsResponseEntry.setter(Builder::position)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Position").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> SAMPLE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("SampleTime").getter(ListDevicePositionsResponseEntry.getter(ListDevicePositionsResponseEntry::sampleTime)).setter(ListDevicePositionsResponseEntry.setter(Builder::sampleTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampleTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_ID_FIELD, POSITION_FIELD, SAMPLE_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String deviceId;
    private final List<Double> position;
    private final Instant sampleTime;

    private ListDevicePositionsResponseEntry(BuilderImpl builder) {
        this.deviceId = builder.deviceId;
        this.position = builder.position;
        this.sampleTime = builder.sampleTime;
    }

    public final String deviceId() {
        return this.deviceId;
    }

    public final boolean hasPosition() {
        return this.position != null && !(this.position instanceof SdkAutoConstructList);
    }

    public final List<Double> position() {
        return this.position;
    }

    public final Instant sampleTime() {
        return this.sampleTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPosition() ? this.position() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDevicePositionsResponseEntry)) {
            return false;
        }
        ListDevicePositionsResponseEntry other = (ListDevicePositionsResponseEntry)obj;
        return Objects.equals(this.deviceId(), other.deviceId()) && this.hasPosition() == other.hasPosition() && Objects.equals(this.position(), other.position()) && Objects.equals(this.sampleTime(), other.sampleTime());
    }

    public final String toString() {
        return ToString.builder((String)"ListDevicePositionsResponseEntry").add("DeviceId", (Object)this.deviceId()).add("Position", (Object)(this.position() == null ? null : "*** Sensitive Data Redacted ***")).add("SampleTime", (Object)this.sampleTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceId": {
                return Optional.ofNullable(clazz.cast(this.deviceId()));
            }
            case "Position": {
                return Optional.ofNullable(clazz.cast(this.position()));
            }
            case "SampleTime": {
                return Optional.ofNullable(clazz.cast(this.sampleTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDevicePositionsResponseEntry, T> g) {
        return obj -> g.apply((ListDevicePositionsResponseEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deviceId;
        private List<Double> position = DefaultSdkAutoConstructList.getInstance();
        private Instant sampleTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDevicePositionsResponseEntry model) {
            this.deviceId(model.deviceId);
            this.position(model.position);
            this.sampleTime(model.sampleTime);
        }

        public final String getDeviceId() {
            return this.deviceId;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        @Override
        @Transient
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final Collection<Double> getPosition() {
            if (this.position instanceof SdkAutoConstructList) {
                return null;
            }
            return this.position;
        }

        public final void setPosition(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
        }

        @Override
        @Transient
        public final Builder position(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder position(Double ... position) {
            this.position(Arrays.asList(position));
            return this;
        }

        public final Instant getSampleTime() {
            return this.sampleTime;
        }

        public final void setSampleTime(Instant sampleTime) {
            this.sampleTime = sampleTime;
        }

        @Override
        @Transient
        public final Builder sampleTime(Instant sampleTime) {
            this.sampleTime = sampleTime;
            return this;
        }

        public ListDevicePositionsResponseEntry build() {
            return new ListDevicePositionsResponseEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListDevicePositionsResponseEntry> {
        public Builder deviceId(String var1);

        public Builder position(Collection<Double> var1);

        public Builder position(Double ... var1);

        public Builder sampleTime(Instant var1);
    }
}

