/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.location.LocationClient;
import software.amazon.awssdk.services.location.model.ListMapsRequest;
import software.amazon.awssdk.services.location.model.ListMapsResponse;
import software.amazon.awssdk.services.location.model.ListMapsResponseEntry;

public class ListMapsIterable
implements SdkIterable<ListMapsResponse> {
    private final LocationClient client;
    private final ListMapsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMapsIterable(LocationClient client, ListMapsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListMapsResponseFetcher();
    }

    public Iterator<ListMapsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ListMapsResponseEntry> entries() {
        Function<ListMapsResponse, Iterator> getIterator = response -> {
            if (response != null && response.entries() != null) {
                return response.entries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListMapsResponseFetcher
    implements SyncPageFetcher<ListMapsResponse> {
        private ListMapsResponseFetcher() {
        }

        public boolean hasNextPage(ListMapsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMapsResponse nextPage(ListMapsResponse previousPage) {
            if (previousPage == null) {
                return ListMapsIterable.this.client.listMaps(ListMapsIterable.this.firstRequest);
            }
            return ListMapsIterable.this.client.listMaps((ListMapsRequest)((Object)ListMapsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

