/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMapsResponseEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListMapsResponseEntry> {
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTime").getter(ListMapsResponseEntry.getter(ListMapsResponseEntry::createTime)).setter(ListMapsResponseEntry.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSource").getter(ListMapsResponseEntry.getter(ListMapsResponseEntry::dataSource)).setter(ListMapsResponseEntry.setter(Builder::dataSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ListMapsResponseEntry.getter(ListMapsResponseEntry::description)).setter(ListMapsResponseEntry.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> MAP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MapName").getter(ListMapsResponseEntry.getter(ListMapsResponseEntry::mapName)).setter(ListMapsResponseEntry.setter(Builder::mapName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MapName").build()}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdateTime").getter(ListMapsResponseEntry.getter(ListMapsResponseEntry::updateTime)).setter(ListMapsResponseEntry.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_TIME_FIELD, DATA_SOURCE_FIELD, DESCRIPTION_FIELD, MAP_NAME_FIELD, UPDATE_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant createTime;
    private final String dataSource;
    private final String description;
    private final String mapName;
    private final Instant updateTime;

    private ListMapsResponseEntry(BuilderImpl builder) {
        this.createTime = builder.createTime;
        this.dataSource = builder.dataSource;
        this.description = builder.description;
        this.mapName = builder.mapName;
        this.updateTime = builder.updateTime;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final String dataSource() {
        return this.dataSource;
    }

    public final String description() {
        return this.description;
    }

    public final String mapName() {
        return this.mapName;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.mapName());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMapsResponseEntry)) {
            return false;
        }
        ListMapsResponseEntry other = (ListMapsResponseEntry)obj;
        return Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.dataSource(), other.dataSource()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.mapName(), other.mapName()) && Objects.equals(this.updateTime(), other.updateTime());
    }

    public final String toString() {
        return ToString.builder((String)"ListMapsResponseEntry").add("CreateTime", (Object)this.createTime()).add("DataSource", (Object)this.dataSource()).add("Description", (Object)this.description()).add("MapName", (Object)this.mapName()).add("UpdateTime", (Object)this.updateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "DataSource": {
                return Optional.ofNullable(clazz.cast(this.dataSource()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "MapName": {
                return Optional.ofNullable(clazz.cast(this.mapName()));
            }
            case "UpdateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMapsResponseEntry, T> g) {
        return obj -> g.apply((ListMapsResponseEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createTime;
        private String dataSource;
        private String description;
        private String mapName;
        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMapsResponseEntry model) {
            this.createTime(model.createTime);
            this.dataSource(model.dataSource);
            this.description(model.description);
            this.mapName(model.mapName);
            this.updateTime(model.updateTime);
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        public final String getDataSource() {
            return this.dataSource;
        }

        @Override
        public final Builder dataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final void setDataSource(String dataSource) {
            this.dataSource = dataSource;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getMapName() {
            return this.mapName;
        }

        @Override
        public final Builder mapName(String mapName) {
            this.mapName = mapName;
            return this;
        }

        public final void setMapName(String mapName) {
            this.mapName = mapName;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        public ListMapsResponseEntry build() {
            return new ListMapsResponseEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListMapsResponseEntry> {
        public Builder createTime(Instant var1);

        public Builder dataSource(String var1);

        public Builder description(String var1);

        public Builder mapName(String var1);

        public Builder updateTime(Instant var1);
    }
}

