/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of the geocoding request sent using <code>SearchPlaceIndexForText</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchPlaceIndexForTextSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<SearchPlaceIndexForTextSummary.Builder, SearchPlaceIndexForTextSummary> {
    private static final SdkField<List<Double>> BIAS_POSITION_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("BiasPosition")
            .getter(getter(SearchPlaceIndexForTextSummary::biasPosition))
            .setter(setter(Builder::biasPosition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BiasPosition").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DATA_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSource").getter(getter(SearchPlaceIndexForTextSummary::dataSource))
            .setter(setter(Builder::dataSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()).build();

    private static final SdkField<List<Double>> FILTER_B_BOX_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("FilterBBox")
            .getter(getter(SearchPlaceIndexForTextSummary::filterBBox))
            .setter(setter(Builder::filterBBox))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterBBox").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> FILTER_COUNTRIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FilterCountries")
            .getter(getter(SearchPlaceIndexForTextSummary::filterCountries))
            .setter(setter(Builder::filterCountries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterCountries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(SearchPlaceIndexForTextSummary::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<List<Double>> RESULT_B_BOX_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("ResultBBox")
            .getter(getter(SearchPlaceIndexForTextSummary::resultBBox))
            .setter(setter(Builder::resultBBox))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultBBox").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Text")
            .getter(getter(SearchPlaceIndexForTextSummary::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BIAS_POSITION_FIELD,
            DATA_SOURCE_FIELD, FILTER_B_BOX_FIELD, FILTER_COUNTRIES_FIELD, MAX_RESULTS_FIELD, RESULT_B_BOX_FIELD, TEXT_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Double> biasPosition;

    private final String dataSource;

    private final List<Double> filterBBox;

    private final List<String> filterCountries;

    private final Integer maxResults;

    private final List<Double> resultBBox;

    private final String text;

    private SearchPlaceIndexForTextSummary(BuilderImpl builder) {
        this.biasPosition = builder.biasPosition;
        this.dataSource = builder.dataSource;
        this.filterBBox = builder.filterBBox;
        this.filterCountries = builder.filterCountries;
        this.maxResults = builder.maxResults;
        this.resultBBox = builder.resultBBox;
        this.text = builder.text;
    }

    /**
     * Returns true if the BiasPosition property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasBiasPosition() {
        return biasPosition != null && !(biasPosition instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains the coordinates for the bias position entered in the geocoding request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBiasPosition()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Contains the coordinates for the bias position entered in the geocoding request.
     */
    public final List<Double> biasPosition() {
        return biasPosition;
    }

    /**
     * <p>
     * The data provider of geospatial data for the Place index resource.
     * </p>
     * 
     * @return The data provider of geospatial data for the Place index resource.
     */
    public final String dataSource() {
        return dataSource;
    }

    /**
     * Returns true if the FilterBBox property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFilterBBox() {
        return filterBBox != null && !(filterBBox instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains the coordinates for the optional bounding box coordinated entered in the geocoding request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilterBBox()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Contains the coordinates for the optional bounding box coordinated entered in the geocoding request.
     */
    public final List<Double> filterBBox() {
        return filterBBox;
    }

    /**
     * Returns true if the FilterCountries property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasFilterCountries() {
        return filterCountries != null && !(filterCountries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains the country filter entered in the geocoding request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilterCountries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Contains the country filter entered in the geocoding request.
     */
    public final List<String> filterCountries() {
        return filterCountries;
    }

    /**
     * <p>
     * Contains the maximum number of results indicated for the request.
     * </p>
     * 
     * @return Contains the maximum number of results indicated for the request.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * Returns true if the ResultBBox property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasResultBBox() {
        return resultBBox != null && !(resultBBox instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A bounding box that contains the search results within the specified area indicated by <code>FilterBBox</code>. A
     * subset of bounding box specified using <code>FilterBBox</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResultBBox()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A bounding box that contains the search results within the specified area indicated by
     *         <code>FilterBBox</code>. A subset of bounding box specified using <code>FilterBBox</code>.
     */
    public final List<Double> resultBBox() {
        return resultBBox;
    }

    /**
     * <p>
     * The address, name, city or region to be used in the geocoding request. In free-form text format. For example,
     * <code>Vancouver</code>.
     * </p>
     * 
     * @return The address, name, city or region to be used in the geocoding request. In free-form text format. For
     *         example, <code>Vancouver</code>.
     */
    public final String text() {
        return text;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasBiasPosition() ? biasPosition() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilterBBox() ? filterBBox() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFilterCountries() ? filterCountries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(hasResultBBox() ? resultBBox() : null);
        hashCode = 31 * hashCode + Objects.hashCode(text());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchPlaceIndexForTextSummary)) {
            return false;
        }
        SearchPlaceIndexForTextSummary other = (SearchPlaceIndexForTextSummary) obj;
        return hasBiasPosition() == other.hasBiasPosition() && Objects.equals(biasPosition(), other.biasPosition())
                && Objects.equals(dataSource(), other.dataSource()) && hasFilterBBox() == other.hasFilterBBox()
                && Objects.equals(filterBBox(), other.filterBBox()) && hasFilterCountries() == other.hasFilterCountries()
                && Objects.equals(filterCountries(), other.filterCountries()) && Objects.equals(maxResults(), other.maxResults())
                && hasResultBBox() == other.hasResultBBox() && Objects.equals(resultBBox(), other.resultBBox())
                && Objects.equals(text(), other.text());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchPlaceIndexForTextSummary")
                .add("BiasPosition", biasPosition() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DataSource", dataSource())
                .add("FilterBBox", filterBBox() == null ? null : "*** Sensitive Data Redacted ***")
                .add("FilterCountries", hasFilterCountries() ? filterCountries() : null).add("MaxResults", maxResults())
                .add("ResultBBox", resultBBox() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Text", text() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BiasPosition":
            return Optional.ofNullable(clazz.cast(biasPosition()));
        case "DataSource":
            return Optional.ofNullable(clazz.cast(dataSource()));
        case "FilterBBox":
            return Optional.ofNullable(clazz.cast(filterBBox()));
        case "FilterCountries":
            return Optional.ofNullable(clazz.cast(filterCountries()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "ResultBBox":
            return Optional.ofNullable(clazz.cast(resultBBox()));
        case "Text":
            return Optional.ofNullable(clazz.cast(text()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchPlaceIndexForTextSummary, T> g) {
        return obj -> g.apply((SearchPlaceIndexForTextSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SearchPlaceIndexForTextSummary> {
        /**
         * <p>
         * Contains the coordinates for the bias position entered in the geocoding request.
         * </p>
         * 
         * @param biasPosition
         *        Contains the coordinates for the bias position entered in the geocoding request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder biasPosition(Collection<Double> biasPosition);

        /**
         * <p>
         * Contains the coordinates for the bias position entered in the geocoding request.
         * </p>
         * 
         * @param biasPosition
         *        Contains the coordinates for the bias position entered in the geocoding request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder biasPosition(Double... biasPosition);

        /**
         * <p>
         * The data provider of geospatial data for the Place index resource.
         * </p>
         * 
         * @param dataSource
         *        The data provider of geospatial data for the Place index resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSource(String dataSource);

        /**
         * <p>
         * Contains the coordinates for the optional bounding box coordinated entered in the geocoding request.
         * </p>
         * 
         * @param filterBBox
         *        Contains the coordinates for the optional bounding box coordinated entered in the geocoding request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterBBox(Collection<Double> filterBBox);

        /**
         * <p>
         * Contains the coordinates for the optional bounding box coordinated entered in the geocoding request.
         * </p>
         * 
         * @param filterBBox
         *        Contains the coordinates for the optional bounding box coordinated entered in the geocoding request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterBBox(Double... filterBBox);

        /**
         * <p>
         * Contains the country filter entered in the geocoding request.
         * </p>
         * 
         * @param filterCountries
         *        Contains the country filter entered in the geocoding request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterCountries(Collection<String> filterCountries);

        /**
         * <p>
         * Contains the country filter entered in the geocoding request.
         * </p>
         * 
         * @param filterCountries
         *        Contains the country filter entered in the geocoding request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterCountries(String... filterCountries);

        /**
         * <p>
         * Contains the maximum number of results indicated for the request.
         * </p>
         * 
         * @param maxResults
         *        Contains the maximum number of results indicated for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A bounding box that contains the search results within the specified area indicated by
         * <code>FilterBBox</code>. A subset of bounding box specified using <code>FilterBBox</code>.
         * </p>
         * 
         * @param resultBBox
         *        A bounding box that contains the search results within the specified area indicated by
         *        <code>FilterBBox</code>. A subset of bounding box specified using <code>FilterBBox</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultBBox(Collection<Double> resultBBox);

        /**
         * <p>
         * A bounding box that contains the search results within the specified area indicated by
         * <code>FilterBBox</code>. A subset of bounding box specified using <code>FilterBBox</code>.
         * </p>
         * 
         * @param resultBBox
         *        A bounding box that contains the search results within the specified area indicated by
         *        <code>FilterBBox</code>. A subset of bounding box specified using <code>FilterBBox</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultBBox(Double... resultBBox);

        /**
         * <p>
         * The address, name, city or region to be used in the geocoding request. In free-form text format. For example,
         * <code>Vancouver</code>.
         * </p>
         * 
         * @param text
         *        The address, name, city or region to be used in the geocoding request. In free-form text format. For
         *        example, <code>Vancouver</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);
    }

    static final class BuilderImpl implements Builder {
        private List<Double> biasPosition = DefaultSdkAutoConstructList.getInstance();

        private String dataSource;

        private List<Double> filterBBox = DefaultSdkAutoConstructList.getInstance();

        private List<String> filterCountries = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private List<Double> resultBBox = DefaultSdkAutoConstructList.getInstance();

        private String text;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchPlaceIndexForTextSummary model) {
            biasPosition(model.biasPosition);
            dataSource(model.dataSource);
            filterBBox(model.filterBBox);
            filterCountries(model.filterCountries);
            maxResults(model.maxResults);
            resultBBox(model.resultBBox);
            text(model.text);
        }

        public final Collection<Double> getBiasPosition() {
            if (biasPosition instanceof SdkAutoConstructList) {
                return null;
            }
            return biasPosition;
        }

        @Override
        public final Builder biasPosition(Collection<Double> biasPosition) {
            this.biasPosition = PositionCopier.copy(biasPosition);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder biasPosition(Double... biasPosition) {
            biasPosition(Arrays.asList(biasPosition));
            return this;
        }

        public final void setBiasPosition(Collection<Double> biasPosition) {
            this.biasPosition = PositionCopier.copy(biasPosition);
        }

        public final String getDataSource() {
            return dataSource;
        }

        @Override
        public final Builder dataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final void setDataSource(String dataSource) {
            this.dataSource = dataSource;
        }

        public final Collection<Double> getFilterBBox() {
            if (filterBBox instanceof SdkAutoConstructList) {
                return null;
            }
            return filterBBox;
        }

        @Override
        public final Builder filterBBox(Collection<Double> filterBBox) {
            this.filterBBox = BoundingBoxCopier.copy(filterBBox);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterBBox(Double... filterBBox) {
            filterBBox(Arrays.asList(filterBBox));
            return this;
        }

        public final void setFilterBBox(Collection<Double> filterBBox) {
            this.filterBBox = BoundingBoxCopier.copy(filterBBox);
        }

        public final Collection<String> getFilterCountries() {
            if (filterCountries instanceof SdkAutoConstructList) {
                return null;
            }
            return filterCountries;
        }

        @Override
        public final Builder filterCountries(Collection<String> filterCountries) {
            this.filterCountries = CountryCodeListCopier.copy(filterCountries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterCountries(String... filterCountries) {
            filterCountries(Arrays.asList(filterCountries));
            return this;
        }

        public final void setFilterCountries(Collection<String> filterCountries) {
            this.filterCountries = CountryCodeListCopier.copy(filterCountries);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final Collection<Double> getResultBBox() {
            if (resultBBox instanceof SdkAutoConstructList) {
                return null;
            }
            return resultBBox;
        }

        @Override
        public final Builder resultBBox(Collection<Double> resultBBox) {
            this.resultBBox = BoundingBoxCopier.copy(resultBBox);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultBBox(Double... resultBBox) {
            resultBBox(Arrays.asList(resultBBox));
            return this;
        }

        public final void setResultBBox(Collection<Double> resultBBox) {
            this.resultBBox = BoundingBoxCopier.copy(resultBBox);
        }

        public final String getText() {
            return text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public SearchPlaceIndexForTextSummary build() {
            return new SearchPlaceIndexForTextSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
