/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchPlaceIndexForTextResponse extends LocationResponse implements
        ToCopyableBuilder<SearchPlaceIndexForTextResponse.Builder, SearchPlaceIndexForTextResponse> {
    private static final SdkField<List<SearchForTextResult>> RESULTS_FIELD = SdkField
            .<List<SearchForTextResult>> builder(MarshallingType.LIST)
            .memberName("Results")
            .getter(getter(SearchPlaceIndexForTextResponse::results))
            .setter(setter(Builder::results))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Results").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SearchForTextResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(SearchForTextResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SearchPlaceIndexForTextSummary> SUMMARY_FIELD = SdkField
            .<SearchPlaceIndexForTextSummary> builder(MarshallingType.SDK_POJO).memberName("Summary")
            .getter(getter(SearchPlaceIndexForTextResponse::summary)).setter(setter(Builder::summary))
            .constructor(SearchPlaceIndexForTextSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Summary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULTS_FIELD, SUMMARY_FIELD));

    private final List<SearchForTextResult> results;

    private final SearchPlaceIndexForTextSummary summary;

    private SearchPlaceIndexForTextResponse(BuilderImpl builder) {
        super(builder);
        this.results = builder.results;
        this.summary = builder.summary;
    }

    /**
     * Returns true if the Results property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasResults() {
        return results != null && !(results instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Places closest to the specified position. Each result contains additional information about the
     * specific point of interest.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResults()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of Places closest to the specified position. Each result contains additional information about the
     *         specific point of interest.
     */
    public final List<SearchForTextResult> results() {
        return results;
    }

    /**
     * <p>
     * Contains a summary of the request. Contains the <code>BiasPosition</code>, <code>DataSource</code>,
     * <code>FilterBBox</code>, <code>FilterCountries</code>, <code>MaxResults</code>, <code>ResultBBox</code>, and
     * <code>Text</code>.
     * </p>
     * 
     * @return Contains a summary of the request. Contains the <code>BiasPosition</code>, <code>DataSource</code>,
     *         <code>FilterBBox</code>, <code>FilterCountries</code>, <code>MaxResults</code>, <code>ResultBBox</code>,
     *         and <code>Text</code>.
     */
    public final SearchPlaceIndexForTextSummary summary() {
        return summary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasResults() ? results() : null);
        hashCode = 31 * hashCode + Objects.hashCode(summary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchPlaceIndexForTextResponse)) {
            return false;
        }
        SearchPlaceIndexForTextResponse other = (SearchPlaceIndexForTextResponse) obj;
        return hasResults() == other.hasResults() && Objects.equals(results(), other.results())
                && Objects.equals(summary(), other.summary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchPlaceIndexForTextResponse").add("Results", hasResults() ? results() : null)
                .add("Summary", summary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Results":
            return Optional.ofNullable(clazz.cast(results()));
        case "Summary":
            return Optional.ofNullable(clazz.cast(summary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchPlaceIndexForTextResponse, T> g) {
        return obj -> g.apply((SearchPlaceIndexForTextResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LocationResponse.Builder, SdkPojo, CopyableBuilder<Builder, SearchPlaceIndexForTextResponse> {
        /**
         * <p>
         * A list of Places closest to the specified position. Each result contains additional information about the
         * specific point of interest.
         * </p>
         * 
         * @param results
         *        A list of Places closest to the specified position. Each result contains additional information about
         *        the specific point of interest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(Collection<SearchForTextResult> results);

        /**
         * <p>
         * A list of Places closest to the specified position. Each result contains additional information about the
         * specific point of interest.
         * </p>
         * 
         * @param results
         *        A list of Places closest to the specified position. Each result contains additional information about
         *        the specific point of interest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(SearchForTextResult... results);

        /**
         * <p>
         * A list of Places closest to the specified position. Each result contains additional information about the
         * specific point of interest.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SearchForTextResult>.Builder} avoiding the
         * need to create one manually via {@link List<SearchForTextResult>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SearchForTextResult>.Builder#build()} is called immediately
         * and its result is passed to {@link #results(List<SearchForTextResult>)}.
         * 
         * @param results
         *        a consumer that will call methods on {@link List<SearchForTextResult>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #results(List<SearchForTextResult>)
         */
        Builder results(Consumer<SearchForTextResult.Builder>... results);

        /**
         * <p>
         * Contains a summary of the request. Contains the <code>BiasPosition</code>, <code>DataSource</code>,
         * <code>FilterBBox</code>, <code>FilterCountries</code>, <code>MaxResults</code>, <code>ResultBBox</code>, and
         * <code>Text</code>.
         * </p>
         * 
         * @param summary
         *        Contains a summary of the request. Contains the <code>BiasPosition</code>, <code>DataSource</code>,
         *        <code>FilterBBox</code>, <code>FilterCountries</code>, <code>MaxResults</code>,
         *        <code>ResultBBox</code>, and <code>Text</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summary(SearchPlaceIndexForTextSummary summary);

        /**
         * <p>
         * Contains a summary of the request. Contains the <code>BiasPosition</code>, <code>DataSource</code>,
         * <code>FilterBBox</code>, <code>FilterCountries</code>, <code>MaxResults</code>, <code>ResultBBox</code>, and
         * <code>Text</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link SearchPlaceIndexForTextSummary.Builder} avoiding
         * the need to create one manually via {@link SearchPlaceIndexForTextSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link SearchPlaceIndexForTextSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #summary(SearchPlaceIndexForTextSummary)}.
         * 
         * @param summary
         *        a consumer that will call methods on {@link SearchPlaceIndexForTextSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #summary(SearchPlaceIndexForTextSummary)
         */
        default Builder summary(Consumer<SearchPlaceIndexForTextSummary.Builder> summary) {
            return summary(SearchPlaceIndexForTextSummary.builder().applyMutation(summary).build());
        }
    }

    static final class BuilderImpl extends LocationResponse.BuilderImpl implements Builder {
        private List<SearchForTextResult> results = DefaultSdkAutoConstructList.getInstance();

        private SearchPlaceIndexForTextSummary summary;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchPlaceIndexForTextResponse model) {
            super(model);
            results(model.results);
            summary(model.summary);
        }

        public final Collection<SearchForTextResult.Builder> getResults() {
            if (results instanceof SdkAutoConstructList) {
                return null;
            }
            return results != null ? results.stream().map(SearchForTextResult::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder results(Collection<SearchForTextResult> results) {
            this.results = SearchForTextResultListCopier.copy(results);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(SearchForTextResult... results) {
            results(Arrays.asList(results));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(Consumer<SearchForTextResult.Builder>... results) {
            results(Stream.of(results).map(c -> SearchForTextResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setResults(Collection<SearchForTextResult.BuilderImpl> results) {
            this.results = SearchForTextResultListCopier.copyFromBuilder(results);
        }

        public final SearchPlaceIndexForTextSummary.Builder getSummary() {
            return summary != null ? summary.toBuilder() : null;
        }

        @Override
        public final Builder summary(SearchPlaceIndexForTextSummary summary) {
            this.summary = summary;
            return this;
        }

        public final void setSummary(SearchPlaceIndexForTextSummary.BuilderImpl summary) {
            this.summary = summary != null ? summary.build() : null;
        }

        @Override
        public SearchPlaceIndexForTextResponse build() {
            return new SearchPlaceIndexForTextResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
