/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.location.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeMapResponse extends LocationResponse implements
        ToCopyableBuilder<DescribeMapResponse.Builder, DescribeMapResponse> {
    private static final SdkField<MapConfiguration> CONFIGURATION_FIELD = SdkField
            .<MapConfiguration> builder(MarshallingType.SDK_POJO).memberName("Configuration")
            .getter(getter(DescribeMapResponse::configuration)).setter(setter(Builder::configuration))
            .constructor(MapConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateTime")
            .getter(getter(DescribeMapResponse::createTime))
            .setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DATA_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSource").getter(getter(DescribeMapResponse::dataSource)).setter(setter(Builder::dataSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DescribeMapResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> MAP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("MapArn")
            .getter(getter(DescribeMapResponse::mapArn)).setter(setter(Builder::mapArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MapArn").build()).build();

    private static final SdkField<String> MAP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MapName").getter(getter(DescribeMapResponse::mapName)).setter(setter(Builder::mapName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MapName").build()).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdateTime")
            .getter(getter(DescribeMapResponse::updateTime))
            .setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_FIELD,
            CREATE_TIME_FIELD, DATA_SOURCE_FIELD, DESCRIPTION_FIELD, MAP_ARN_FIELD, MAP_NAME_FIELD, UPDATE_TIME_FIELD));

    private final MapConfiguration configuration;

    private final Instant createTime;

    private final String dataSource;

    private final String description;

    private final String mapArn;

    private final String mapName;

    private final Instant updateTime;

    private DescribeMapResponse(BuilderImpl builder) {
        super(builder);
        this.configuration = builder.configuration;
        this.createTime = builder.createTime;
        this.dataSource = builder.dataSource;
        this.description = builder.description;
        this.mapArn = builder.mapArn;
        this.mapName = builder.mapName;
        this.updateTime = builder.updateTime;
    }

    /**
     * <p>
     * Specifies the map tile style selected from a partner data provider.
     * </p>
     * 
     * @return Specifies the map tile style selected from a partner data provider.
     */
    public final MapConfiguration configuration() {
        return configuration;
    }

    /**
     * <p>
     * The timestamp for when the map resource was created in <a
     * href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
     * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
     * </p>
     * 
     * @return The timestamp for when the map resource was created in <a
     *         href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
     *         <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * Specifies the data provider for the associated map tiles.
     * </p>
     * 
     * @return Specifies the data provider for the associated map tiles.
     */
    public final String dataSource() {
        return dataSource;
    }

    /**
     * <p>
     * The optional description for the map resource.
     * </p>
     * 
     * @return The optional description for the map resource.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the map resource. Used when you need to specify a resource across all AWS.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the map resource. Used when you need to specify a resource across all
     *         AWS.
     */
    public final String mapArn() {
        return mapArn;
    }

    /**
     * <p>
     * The map style selected from an available provider.
     * </p>
     * 
     * @return The map style selected from an available provider.
     */
    public final String mapName() {
        return mapName;
    }

    /**
     * <p>
     * The timestamp for when the map resource was last update in <a
     * href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
     * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
     * </p>
     * 
     * @return The timestamp for when the map resource was last update in <a
     *         href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
     *         <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(mapArn());
        hashCode = 31 * hashCode + Objects.hashCode(mapName());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMapResponse)) {
            return false;
        }
        DescribeMapResponse other = (DescribeMapResponse) obj;
        return Objects.equals(configuration(), other.configuration()) && Objects.equals(createTime(), other.createTime())
                && Objects.equals(dataSource(), other.dataSource()) && Objects.equals(description(), other.description())
                && Objects.equals(mapArn(), other.mapArn()) && Objects.equals(mapName(), other.mapName())
                && Objects.equals(updateTime(), other.updateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeMapResponse").add("Configuration", configuration()).add("CreateTime", createTime())
                .add("DataSource", dataSource()).add("Description", description()).add("MapArn", mapArn())
                .add("MapName", mapName()).add("UpdateTime", updateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "CreateTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "DataSource":
            return Optional.ofNullable(clazz.cast(dataSource()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "MapArn":
            return Optional.ofNullable(clazz.cast(mapArn()));
        case "MapName":
            return Optional.ofNullable(clazz.cast(mapName()));
        case "UpdateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMapResponse, T> g) {
        return obj -> g.apply((DescribeMapResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LocationResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeMapResponse> {
        /**
         * <p>
         * Specifies the map tile style selected from a partner data provider.
         * </p>
         * 
         * @param configuration
         *        Specifies the map tile style selected from a partner data provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(MapConfiguration configuration);

        /**
         * <p>
         * Specifies the map tile style selected from a partner data provider.
         * </p>
         * This is a convenience that creates an instance of the {@link MapConfiguration.Builder} avoiding the need to
         * create one manually via {@link MapConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link MapConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #configuration(MapConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link MapConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(MapConfiguration)
         */
        default Builder configuration(Consumer<MapConfiguration.Builder> configuration) {
            return configuration(MapConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * The timestamp for when the map resource was created in <a
         * href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
         * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
         * </p>
         * 
         * @param createTime
         *        The timestamp for when the map resource was created in <a
         *        href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
         *        <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * Specifies the data provider for the associated map tiles.
         * </p>
         * 
         * @param dataSource
         *        Specifies the data provider for the associated map tiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSource(String dataSource);

        /**
         * <p>
         * The optional description for the map resource.
         * </p>
         * 
         * @param description
         *        The optional description for the map resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the map resource. Used when you need to specify a resource across all AWS.
         * </p>
         * 
         * @param mapArn
         *        The Amazon Resource Name (ARN) for the map resource. Used when you need to specify a resource across
         *        all AWS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapArn(String mapArn);

        /**
         * <p>
         * The map style selected from an available provider.
         * </p>
         * 
         * @param mapName
         *        The map style selected from an available provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapName(String mapName);

        /**
         * <p>
         * The timestamp for when the map resource was last update in <a
         * href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
         * <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
         * </p>
         * 
         * @param updateTime
         *        The timestamp for when the map resource was last update in <a
         *        href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format:
         *        <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);
    }

    static final class BuilderImpl extends LocationResponse.BuilderImpl implements Builder {
        private MapConfiguration configuration;

        private Instant createTime;

        private String dataSource;

        private String description;

        private String mapArn;

        private String mapName;

        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMapResponse model) {
            super(model);
            configuration(model.configuration);
            createTime(model.createTime);
            dataSource(model.dataSource);
            description(model.description);
            mapArn(model.mapArn);
            mapName(model.mapName);
            updateTime(model.updateTime);
        }

        public final MapConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        @Override
        public final Builder configuration(MapConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final void setConfiguration(MapConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        public final String getDataSource() {
            return dataSource;
        }

        @Override
        public final Builder dataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final void setDataSource(String dataSource) {
            this.dataSource = dataSource;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getMapArn() {
            return mapArn;
        }

        @Override
        public final Builder mapArn(String mapArn) {
            this.mapArn = mapArn;
            return this;
        }

        public final void setMapArn(String mapArn) {
            this.mapArn = mapArn;
        }

        public final String getMapName() {
            return mapName;
        }

        @Override
        public final Builder mapName(String mapName) {
            this.mapName = mapName;
            return this;
        }

        public final void setMapName(String mapName) {
            this.mapName = mapName;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public DescribeMapResponse build() {
            return new DescribeMapResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
