/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RelationalDatabaseEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RelationalDatabaseEvent> {
    private static final SdkField<String> RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RelationalDatabaseEvent.getter(RelationalDatabaseEvent::resource)).setter(RelationalDatabaseEvent.setter(Builder::resource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(RelationalDatabaseEvent.getter(RelationalDatabaseEvent::createdAt)).setter(RelationalDatabaseEvent.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RelationalDatabaseEvent.getter(RelationalDatabaseEvent::message)).setter(RelationalDatabaseEvent.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<List<String>> EVENT_CATEGORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(RelationalDatabaseEvent.getter(RelationalDatabaseEvent::eventCategories)).setter(RelationalDatabaseEvent.setter(Builder::eventCategories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventCategories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_FIELD, CREATED_AT_FIELD, MESSAGE_FIELD, EVENT_CATEGORIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String resource;
    private final Instant createdAt;
    private final String message;
    private final List<String> eventCategories;

    private RelationalDatabaseEvent(BuilderImpl builder) {
        this.resource = builder.resource;
        this.createdAt = builder.createdAt;
        this.message = builder.message;
        this.eventCategories = builder.eventCategories;
    }

    public String resource() {
        return this.resource;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public String message() {
        return this.message;
    }

    public List<String> eventCategories() {
        return this.eventCategories;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventCategories());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelationalDatabaseEvent)) {
            return false;
        }
        RelationalDatabaseEvent other = (RelationalDatabaseEvent)obj;
        return Objects.equals(this.resource(), other.resource()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.eventCategories(), other.eventCategories());
    }

    public String toString() {
        return ToString.builder((String)"RelationalDatabaseEvent").add("Resource", (Object)this.resource()).add("CreatedAt", (Object)this.createdAt()).add("Message", (Object)this.message()).add("EventCategories", this.eventCategories()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resource": {
                return Optional.ofNullable(clazz.cast(this.resource()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "eventCategories": {
                return Optional.ofNullable(clazz.cast(this.eventCategories()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RelationalDatabaseEvent, T> g) {
        return obj -> g.apply((RelationalDatabaseEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resource;
        private Instant createdAt;
        private String message;
        private List<String> eventCategories = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RelationalDatabaseEvent model) {
            this.resource(model.resource);
            this.createdAt(model.createdAt);
            this.message(model.message);
            this.eventCategories(model.eventCategories);
        }

        public final String getResource() {
            return this.resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Collection<String> getEventCategories() {
            return this.eventCategories;
        }

        @Override
        public final Builder eventCategories(Collection<String> eventCategories) {
            this.eventCategories = StringListCopier.copy(eventCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventCategories(String ... eventCategories) {
            this.eventCategories(Arrays.asList(eventCategories));
            return this;
        }

        public final void setEventCategories(Collection<String> eventCategories) {
            this.eventCategories = StringListCopier.copy(eventCategories);
        }

        public RelationalDatabaseEvent build() {
            return new RelationalDatabaseEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RelationalDatabaseEvent> {
        public Builder resource(String var1);

        public Builder createdAt(Instant var1);

        public Builder message(String var1);

        public Builder eventCategories(Collection<String> var1);

        public Builder eventCategories(String ... var1);
    }
}

