/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.services.lightsail.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRelationalDatabaseLogStreamsResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, GetRelationalDatabaseLogStreamsResponse> {
    private static final SdkField<List<String>> LOG_STREAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetRelationalDatabaseLogStreamsResponse.getter(GetRelationalDatabaseLogStreamsResponse::logStreams)).setter(GetRelationalDatabaseLogStreamsResponse.setter(Builder::logStreams)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logStreams").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_STREAMS_FIELD));
    private final List<String> logStreams;

    private GetRelationalDatabaseLogStreamsResponse(BuilderImpl builder) {
        super(builder);
        this.logStreams = builder.logStreams;
    }

    public List<String> logStreams() {
        return this.logStreams;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.logStreams());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRelationalDatabaseLogStreamsResponse)) {
            return false;
        }
        GetRelationalDatabaseLogStreamsResponse other = (GetRelationalDatabaseLogStreamsResponse)((Object)obj);
        return Objects.equals(this.logStreams(), other.logStreams());
    }

    public String toString() {
        return ToString.builder((String)"GetRelationalDatabaseLogStreamsResponse").add("LogStreams", this.logStreams()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "logStreams": {
                return Optional.ofNullable(clazz.cast(this.logStreams()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRelationalDatabaseLogStreamsResponse, T> g) {
        return obj -> g.apply((GetRelationalDatabaseLogStreamsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private List<String> logStreams = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetRelationalDatabaseLogStreamsResponse model) {
            super(model);
            this.logStreams(model.logStreams);
        }

        public final Collection<String> getLogStreams() {
            return this.logStreams;
        }

        @Override
        public final Builder logStreams(Collection<String> logStreams) {
            this.logStreams = StringListCopier.copy(logStreams);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logStreams(String ... logStreams) {
            this.logStreams(Arrays.asList(logStreams));
            return this;
        }

        public final void setLogStreams(Collection<String> logStreams) {
            this.logStreams = StringListCopier.copy(logStreams);
        }

        @Override
        public GetRelationalDatabaseLogStreamsResponse build() {
            return new GetRelationalDatabaseLogStreamsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRelationalDatabaseLogStreamsResponse> {
        public Builder logStreams(Collection<String> var1);

        public Builder logStreams(String ... var1);
    }
}

