/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.AddOnRequest;
import software.amazon.awssdk.services.lightsail.model.AddOnRequestListCopier;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.services.lightsail.model.StringListCopier;
import software.amazon.awssdk.services.lightsail.model.Tag;
import software.amazon.awssdk.services.lightsail.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateInstancesRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, CreateInstancesRequest> {
    private static final SdkField<List<String>> INSTANCE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateInstancesRequest.getter(CreateInstancesRequest::instanceNames)).setter(CreateInstancesRequest.setter(Builder::instanceNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateInstancesRequest.getter(CreateInstancesRequest::availabilityZone)).setter(CreateInstancesRequest.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()}).build();
    private static final SdkField<String> CUSTOM_IMAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateInstancesRequest.getter(CreateInstancesRequest::customImageName)).setter(CreateInstancesRequest.setter(Builder::customImageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customImageName").build()}).build();
    private static final SdkField<String> BLUEPRINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateInstancesRequest.getter(CreateInstancesRequest::blueprintId)).setter(CreateInstancesRequest.setter(Builder::blueprintId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprintId").build()}).build();
    private static final SdkField<String> BUNDLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateInstancesRequest.getter(CreateInstancesRequest::bundleId)).setter(CreateInstancesRequest.setter(Builder::bundleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bundleId").build()}).build();
    private static final SdkField<String> USER_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateInstancesRequest.getter(CreateInstancesRequest::userData)).setter(CreateInstancesRequest.setter(Builder::userData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userData").build()}).build();
    private static final SdkField<String> KEY_PAIR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateInstancesRequest.getter(CreateInstancesRequest::keyPairName)).setter(CreateInstancesRequest.setter(Builder::keyPairName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyPairName").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateInstancesRequest.getter(CreateInstancesRequest::tags)).setter(CreateInstancesRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AddOnRequest>> ADD_ONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateInstancesRequest.getter(CreateInstancesRequest::addOns)).setter(CreateInstancesRequest.setter(Builder::addOns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addOns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AddOnRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_NAMES_FIELD, AVAILABILITY_ZONE_FIELD, CUSTOM_IMAGE_NAME_FIELD, BLUEPRINT_ID_FIELD, BUNDLE_ID_FIELD, USER_DATA_FIELD, KEY_PAIR_NAME_FIELD, TAGS_FIELD, ADD_ONS_FIELD));
    private final List<String> instanceNames;
    private final String availabilityZone;
    private final String customImageName;
    private final String blueprintId;
    private final String bundleId;
    private final String userData;
    private final String keyPairName;
    private final List<Tag> tags;
    private final List<AddOnRequest> addOns;

    private CreateInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.instanceNames = builder.instanceNames;
        this.availabilityZone = builder.availabilityZone;
        this.customImageName = builder.customImageName;
        this.blueprintId = builder.blueprintId;
        this.bundleId = builder.bundleId;
        this.userData = builder.userData;
        this.keyPairName = builder.keyPairName;
        this.tags = builder.tags;
        this.addOns = builder.addOns;
    }

    public List<String> instanceNames() {
        return this.instanceNames;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public String customImageName() {
        return this.customImageName;
    }

    public String blueprintId() {
        return this.blueprintId;
    }

    public String bundleId() {
        return this.bundleId;
    }

    public String userData() {
        return this.userData;
    }

    public String keyPairName() {
        return this.keyPairName;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public List<AddOnRequest> addOns() {
        return this.addOns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.customImageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.blueprintId());
        hashCode = 31 * hashCode + Objects.hashCode(this.bundleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userData());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyPairName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.addOns());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInstancesRequest)) {
            return false;
        }
        CreateInstancesRequest other = (CreateInstancesRequest)((Object)obj);
        return Objects.equals(this.instanceNames(), other.instanceNames()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.customImageName(), other.customImageName()) && Objects.equals(this.blueprintId(), other.blueprintId()) && Objects.equals(this.bundleId(), other.bundleId()) && Objects.equals(this.userData(), other.userData()) && Objects.equals(this.keyPairName(), other.keyPairName()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.addOns(), other.addOns());
    }

    public String toString() {
        return ToString.builder((String)"CreateInstancesRequest").add("InstanceNames", this.instanceNames()).add("AvailabilityZone", (Object)this.availabilityZone()).add("CustomImageName", (Object)this.customImageName()).add("BlueprintId", (Object)this.blueprintId()).add("BundleId", (Object)this.bundleId()).add("UserData", (Object)this.userData()).add("KeyPairName", (Object)this.keyPairName()).add("Tags", this.tags()).add("AddOns", this.addOns()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceNames": {
                return Optional.ofNullable(clazz.cast(this.instanceNames()));
            }
            case "availabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "customImageName": {
                return Optional.ofNullable(clazz.cast(this.customImageName()));
            }
            case "blueprintId": {
                return Optional.ofNullable(clazz.cast(this.blueprintId()));
            }
            case "bundleId": {
                return Optional.ofNullable(clazz.cast(this.bundleId()));
            }
            case "userData": {
                return Optional.ofNullable(clazz.cast(this.userData()));
            }
            case "keyPairName": {
                return Optional.ofNullable(clazz.cast(this.keyPairName()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "addOns": {
                return Optional.ofNullable(clazz.cast(this.addOns()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateInstancesRequest, T> g) {
        return obj -> g.apply((CreateInstancesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private List<String> instanceNames = DefaultSdkAutoConstructList.getInstance();
        private String availabilityZone;
        private String customImageName;
        private String blueprintId;
        private String bundleId;
        private String userData;
        private String keyPairName;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private List<AddOnRequest> addOns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInstancesRequest model) {
            super(model);
            this.instanceNames(model.instanceNames);
            this.availabilityZone(model.availabilityZone);
            this.customImageName(model.customImageName);
            this.blueprintId(model.blueprintId);
            this.bundleId(model.bundleId);
            this.userData(model.userData);
            this.keyPairName(model.keyPairName);
            this.tags(model.tags);
            this.addOns(model.addOns);
        }

        public final Collection<String> getInstanceNames() {
            return this.instanceNames;
        }

        @Override
        public final Builder instanceNames(Collection<String> instanceNames) {
            this.instanceNames = StringListCopier.copy(instanceNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceNames(String ... instanceNames) {
            this.instanceNames(Arrays.asList(instanceNames));
            return this;
        }

        public final void setInstanceNames(Collection<String> instanceNames) {
            this.instanceNames = StringListCopier.copy(instanceNames);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getCustomImageName() {
            return this.customImageName;
        }

        @Override
        public final Builder customImageName(String customImageName) {
            this.customImageName = customImageName;
            return this;
        }

        public final void setCustomImageName(String customImageName) {
            this.customImageName = customImageName;
        }

        public final String getBlueprintId() {
            return this.blueprintId;
        }

        @Override
        public final Builder blueprintId(String blueprintId) {
            this.blueprintId = blueprintId;
            return this;
        }

        public final void setBlueprintId(String blueprintId) {
            this.blueprintId = blueprintId;
        }

        public final String getBundleId() {
            return this.bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        public final String getUserData() {
            return this.userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        public final String getKeyPairName() {
            return this.keyPairName;
        }

        @Override
        public final Builder keyPairName(String keyPairName) {
            this.keyPairName = keyPairName;
            return this;
        }

        public final void setKeyPairName(String keyPairName) {
            this.keyPairName = keyPairName;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Collection<AddOnRequest.Builder> getAddOns() {
            return this.addOns != null ? (Collection)this.addOns.stream().map(AddOnRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder addOns(Collection<AddOnRequest> addOns) {
            this.addOns = AddOnRequestListCopier.copy(addOns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addOns(AddOnRequest ... addOns) {
            this.addOns(Arrays.asList(addOns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addOns(Consumer<AddOnRequest.Builder> ... addOns) {
            this.addOns(Stream.of(addOns).map(c -> (AddOnRequest)((AddOnRequest.Builder)AddOnRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAddOns(Collection<AddOnRequest.BuilderImpl> addOns) {
            this.addOns = AddOnRequestListCopier.copyFromBuilder(addOns);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateInstancesRequest build() {
            return new CreateInstancesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateInstancesRequest> {
        public Builder instanceNames(Collection<String> var1);

        public Builder instanceNames(String ... var1);

        public Builder availabilityZone(String var1);

        public Builder customImageName(String var1);

        public Builder blueprintId(String var1);

        public Builder bundleId(String var1);

        public Builder userData(String var1);

        public Builder keyPairName(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder addOns(Collection<AddOnRequest> var1);

        public Builder addOns(AddOnRequest ... var1);

        public Builder addOns(Consumer<AddOnRequest.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

