/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ResourceType {
    INSTANCE("Instance"),
    STATIC_IP("StaticIp"),
    KEY_PAIR("KeyPair"),
    INSTANCE_SNAPSHOT("InstanceSnapshot"),
    DOMAIN("Domain"),
    PEERED_VPC("PeeredVpc"),
    LOAD_BALANCER("LoadBalancer"),
    LOAD_BALANCER_TLS_CERTIFICATE("LoadBalancerTlsCertificate"),
    DISK("Disk"),
    DISK_SNAPSHOT("DiskSnapshot"),
    RELATIONAL_DATABASE("RelationalDatabase"),
    RELATIONAL_DATABASE_SNAPSHOT("RelationalDatabaseSnapshot"),
    EXPORT_SNAPSHOT_RECORD("ExportSnapshotRecord"),
    CLOUD_FORMATION_STACK_RECORD("CloudFormationStackRecord"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ResourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ResourceType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceType> knownValues() {
        return Stream.of(ResourceType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

