/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum NetworkProtocol {
    TCP("tcp"),
    ALL("all"),
    UDP("udp"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private NetworkProtocol(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NetworkProtocol fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(NetworkProtocol.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NetworkProtocol> knownValues() {
        return Stream.of(NetworkProtocol.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

