/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AccessDirection {
    INBOUND("inbound"),
    OUTBOUND("outbound"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AccessDirection(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AccessDirection fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AccessDirection.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AccessDirection> knownValues() {
        return Stream.of(AccessDirection.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

