/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.ResourceLocation;
import software.amazon.awssdk.services.lightsail.model.ResourceType;
import software.amazon.awssdk.services.lightsail.model.Tag;
import software.amazon.awssdk.services.lightsail.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RelationalDatabaseSnapshot
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RelationalDatabaseSnapshot> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RelationalDatabaseSnapshot.getter(RelationalDatabaseSnapshot::name)).setter(RelationalDatabaseSnapshot.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RelationalDatabaseSnapshot.getter(RelationalDatabaseSnapshot::arn)).setter(RelationalDatabaseSnapshot.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> SUPPORT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RelationalDatabaseSnapshot.getter(RelationalDatabaseSnapshot::supportCode)).setter(RelationalDatabaseSnapshot.setter(Builder::supportCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportCode").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(RelationalDatabaseSnapshot.getter(RelationalDatabaseSnapshot::createdAt)).setter(RelationalDatabaseSnapshot.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<ResourceLocation> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(RelationalDatabaseSnapshot.getter(RelationalDatabaseSnapshot::location)).setter(RelationalDatabaseSnapshot.setter(Builder::location)).constructor(ResourceLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RelationalDatabaseSnapshot.getter(RelationalDatabaseSnapshot::resourceTypeAsString)).setter(RelationalDatabaseSnapshot.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(RelationalDatabaseSnapshot.getter(RelationalDatabaseSnapshot::tags)).setter(RelationalDatabaseSnapshot.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RelationalDatabaseSnapshot.getter(RelationalDatabaseSnapshot::engine)).setter(RelationalDatabaseSnapshot.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engine").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RelationalDatabaseSnapshot.getter(RelationalDatabaseSnapshot::engineVersion)).setter(RelationalDatabaseSnapshot.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineVersion").build()}).build();
    private static final SdkField<Integer> SIZE_IN_GB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(RelationalDatabaseSnapshot.getter(RelationalDatabaseSnapshot::sizeInGb)).setter(RelationalDatabaseSnapshot.setter(Builder::sizeInGb)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sizeInGb").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RelationalDatabaseSnapshot.getter(RelationalDatabaseSnapshot::state)).setter(RelationalDatabaseSnapshot.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> FROM_RELATIONAL_DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RelationalDatabaseSnapshot.getter(RelationalDatabaseSnapshot::fromRelationalDatabaseName)).setter(RelationalDatabaseSnapshot.setter(Builder::fromRelationalDatabaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fromRelationalDatabaseName").build()}).build();
    private static final SdkField<String> FROM_RELATIONAL_DATABASE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RelationalDatabaseSnapshot.getter(RelationalDatabaseSnapshot::fromRelationalDatabaseArn)).setter(RelationalDatabaseSnapshot.setter(Builder::fromRelationalDatabaseArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fromRelationalDatabaseArn").build()}).build();
    private static final SdkField<String> FROM_RELATIONAL_DATABASE_BUNDLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RelationalDatabaseSnapshot.getter(RelationalDatabaseSnapshot::fromRelationalDatabaseBundleId)).setter(RelationalDatabaseSnapshot.setter(Builder::fromRelationalDatabaseBundleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fromRelationalDatabaseBundleId").build()}).build();
    private static final SdkField<String> FROM_RELATIONAL_DATABASE_BLUEPRINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RelationalDatabaseSnapshot.getter(RelationalDatabaseSnapshot::fromRelationalDatabaseBlueprintId)).setter(RelationalDatabaseSnapshot.setter(Builder::fromRelationalDatabaseBlueprintId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fromRelationalDatabaseBlueprintId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD, SUPPORT_CODE_FIELD, CREATED_AT_FIELD, LOCATION_FIELD, RESOURCE_TYPE_FIELD, TAGS_FIELD, ENGINE_FIELD, ENGINE_VERSION_FIELD, SIZE_IN_GB_FIELD, STATE_FIELD, FROM_RELATIONAL_DATABASE_NAME_FIELD, FROM_RELATIONAL_DATABASE_ARN_FIELD, FROM_RELATIONAL_DATABASE_BUNDLE_ID_FIELD, FROM_RELATIONAL_DATABASE_BLUEPRINT_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String arn;
    private final String supportCode;
    private final Instant createdAt;
    private final ResourceLocation location;
    private final String resourceType;
    private final List<Tag> tags;
    private final String engine;
    private final String engineVersion;
    private final Integer sizeInGb;
    private final String state;
    private final String fromRelationalDatabaseName;
    private final String fromRelationalDatabaseArn;
    private final String fromRelationalDatabaseBundleId;
    private final String fromRelationalDatabaseBlueprintId;

    private RelationalDatabaseSnapshot(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.supportCode = builder.supportCode;
        this.createdAt = builder.createdAt;
        this.location = builder.location;
        this.resourceType = builder.resourceType;
        this.tags = builder.tags;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.sizeInGb = builder.sizeInGb;
        this.state = builder.state;
        this.fromRelationalDatabaseName = builder.fromRelationalDatabaseName;
        this.fromRelationalDatabaseArn = builder.fromRelationalDatabaseArn;
        this.fromRelationalDatabaseBundleId = builder.fromRelationalDatabaseBundleId;
        this.fromRelationalDatabaseBlueprintId = builder.fromRelationalDatabaseBlueprintId;
    }

    public String name() {
        return this.name;
    }

    public String arn() {
        return this.arn;
    }

    public String supportCode() {
        return this.supportCode;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public ResourceLocation location() {
        return this.location;
    }

    public ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public String resourceTypeAsString() {
        return this.resourceType;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public String engine() {
        return this.engine;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public Integer sizeInGb() {
        return this.sizeInGb;
    }

    public String state() {
        return this.state;
    }

    public String fromRelationalDatabaseName() {
        return this.fromRelationalDatabaseName;
    }

    public String fromRelationalDatabaseArn() {
        return this.fromRelationalDatabaseArn;
    }

    public String fromRelationalDatabaseBundleId() {
        return this.fromRelationalDatabaseBundleId;
    }

    public String fromRelationalDatabaseBlueprintId() {
        return this.fromRelationalDatabaseBlueprintId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeInGb());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.fromRelationalDatabaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.fromRelationalDatabaseArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.fromRelationalDatabaseBundleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fromRelationalDatabaseBlueprintId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelationalDatabaseSnapshot)) {
            return false;
        }
        RelationalDatabaseSnapshot other = (RelationalDatabaseSnapshot)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.supportCode(), other.supportCode()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.sizeInGb(), other.sizeInGb()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.fromRelationalDatabaseName(), other.fromRelationalDatabaseName()) && Objects.equals(this.fromRelationalDatabaseArn(), other.fromRelationalDatabaseArn()) && Objects.equals(this.fromRelationalDatabaseBundleId(), other.fromRelationalDatabaseBundleId()) && Objects.equals(this.fromRelationalDatabaseBlueprintId(), other.fromRelationalDatabaseBlueprintId());
    }

    public String toString() {
        return ToString.builder((String)"RelationalDatabaseSnapshot").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("SupportCode", (Object)this.supportCode()).add("CreatedAt", (Object)this.createdAt()).add("Location", (Object)this.location()).add("ResourceType", (Object)this.resourceTypeAsString()).add("Tags", this.tags()).add("Engine", (Object)this.engine()).add("EngineVersion", (Object)this.engineVersion()).add("SizeInGb", (Object)this.sizeInGb()).add("State", (Object)this.state()).add("FromRelationalDatabaseName", (Object)this.fromRelationalDatabaseName()).add("FromRelationalDatabaseArn", (Object)this.fromRelationalDatabaseArn()).add("FromRelationalDatabaseBundleId", (Object)this.fromRelationalDatabaseBundleId()).add("FromRelationalDatabaseBlueprintId", (Object)this.fromRelationalDatabaseBlueprintId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "supportCode": {
                return Optional.ofNullable(clazz.cast(this.supportCode()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "engineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "sizeInGb": {
                return Optional.ofNullable(clazz.cast(this.sizeInGb()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "fromRelationalDatabaseName": {
                return Optional.ofNullable(clazz.cast(this.fromRelationalDatabaseName()));
            }
            case "fromRelationalDatabaseArn": {
                return Optional.ofNullable(clazz.cast(this.fromRelationalDatabaseArn()));
            }
            case "fromRelationalDatabaseBundleId": {
                return Optional.ofNullable(clazz.cast(this.fromRelationalDatabaseBundleId()));
            }
            case "fromRelationalDatabaseBlueprintId": {
                return Optional.ofNullable(clazz.cast(this.fromRelationalDatabaseBlueprintId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RelationalDatabaseSnapshot, T> g) {
        return obj -> g.apply((RelationalDatabaseSnapshot)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private String supportCode;
        private Instant createdAt;
        private ResourceLocation location;
        private String resourceType;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String engine;
        private String engineVersion;
        private Integer sizeInGb;
        private String state;
        private String fromRelationalDatabaseName;
        private String fromRelationalDatabaseArn;
        private String fromRelationalDatabaseBundleId;
        private String fromRelationalDatabaseBlueprintId;

        private BuilderImpl() {
        }

        private BuilderImpl(RelationalDatabaseSnapshot model) {
            this.name(model.name);
            this.arn(model.arn);
            this.supportCode(model.supportCode);
            this.createdAt(model.createdAt);
            this.location(model.location);
            this.resourceType(model.resourceType);
            this.tags(model.tags);
            this.engine(model.engine);
            this.engineVersion(model.engineVersion);
            this.sizeInGb(model.sizeInGb);
            this.state(model.state);
            this.fromRelationalDatabaseName(model.fromRelationalDatabaseName);
            this.fromRelationalDatabaseArn(model.fromRelationalDatabaseArn);
            this.fromRelationalDatabaseBundleId(model.fromRelationalDatabaseBundleId);
            this.fromRelationalDatabaseBlueprintId(model.fromRelationalDatabaseBlueprintId);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getSupportCode() {
            return this.supportCode;
        }

        @Override
        public final Builder supportCode(String supportCode) {
            this.supportCode = supportCode;
            return this;
        }

        public final void setSupportCode(String supportCode) {
            this.supportCode = supportCode;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final ResourceLocation.Builder getLocation() {
            return this.location != null ? this.location.toBuilder() : null;
        }

        @Override
        public final Builder location(ResourceLocation location) {
            this.location = location;
            return this;
        }

        public final void setLocation(ResourceLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        public final String getResourceTypeAsString() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final Integer getSizeInGb() {
            return this.sizeInGb;
        }

        @Override
        public final Builder sizeInGb(Integer sizeInGb) {
            this.sizeInGb = sizeInGb;
            return this;
        }

        public final void setSizeInGb(Integer sizeInGb) {
            this.sizeInGb = sizeInGb;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getFromRelationalDatabaseName() {
            return this.fromRelationalDatabaseName;
        }

        @Override
        public final Builder fromRelationalDatabaseName(String fromRelationalDatabaseName) {
            this.fromRelationalDatabaseName = fromRelationalDatabaseName;
            return this;
        }

        public final void setFromRelationalDatabaseName(String fromRelationalDatabaseName) {
            this.fromRelationalDatabaseName = fromRelationalDatabaseName;
        }

        public final String getFromRelationalDatabaseArn() {
            return this.fromRelationalDatabaseArn;
        }

        @Override
        public final Builder fromRelationalDatabaseArn(String fromRelationalDatabaseArn) {
            this.fromRelationalDatabaseArn = fromRelationalDatabaseArn;
            return this;
        }

        public final void setFromRelationalDatabaseArn(String fromRelationalDatabaseArn) {
            this.fromRelationalDatabaseArn = fromRelationalDatabaseArn;
        }

        public final String getFromRelationalDatabaseBundleId() {
            return this.fromRelationalDatabaseBundleId;
        }

        @Override
        public final Builder fromRelationalDatabaseBundleId(String fromRelationalDatabaseBundleId) {
            this.fromRelationalDatabaseBundleId = fromRelationalDatabaseBundleId;
            return this;
        }

        public final void setFromRelationalDatabaseBundleId(String fromRelationalDatabaseBundleId) {
            this.fromRelationalDatabaseBundleId = fromRelationalDatabaseBundleId;
        }

        public final String getFromRelationalDatabaseBlueprintId() {
            return this.fromRelationalDatabaseBlueprintId;
        }

        @Override
        public final Builder fromRelationalDatabaseBlueprintId(String fromRelationalDatabaseBlueprintId) {
            this.fromRelationalDatabaseBlueprintId = fromRelationalDatabaseBlueprintId;
            return this;
        }

        public final void setFromRelationalDatabaseBlueprintId(String fromRelationalDatabaseBlueprintId) {
            this.fromRelationalDatabaseBlueprintId = fromRelationalDatabaseBlueprintId;
        }

        public RelationalDatabaseSnapshot build() {
            return new RelationalDatabaseSnapshot(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RelationalDatabaseSnapshot> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder supportCode(String var1);

        public Builder createdAt(Instant var1);

        public Builder location(ResourceLocation var1);

        default public Builder location(Consumer<ResourceLocation.Builder> location) {
            return this.location((ResourceLocation)((ResourceLocation.Builder)ResourceLocation.builder().applyMutation(location)).build());
        }

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder sizeInGb(Integer var1);

        public Builder state(String var1);

        public Builder fromRelationalDatabaseName(String var1);

        public Builder fromRelationalDatabaseArn(String var1);

        public Builder fromRelationalDatabaseBundleId(String var1);

        public Builder fromRelationalDatabaseBlueprintId(String var1);
    }
}

