/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRelationalDatabaseLogEventsRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, GetRelationalDatabaseLogEventsRequest> {
    private static final SdkField<String> RELATIONAL_DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetRelationalDatabaseLogEventsRequest.getter(GetRelationalDatabaseLogEventsRequest::relationalDatabaseName)).setter(GetRelationalDatabaseLogEventsRequest.setter(Builder::relationalDatabaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationalDatabaseName").build()}).build();
    private static final SdkField<String> LOG_STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetRelationalDatabaseLogEventsRequest.getter(GetRelationalDatabaseLogEventsRequest::logStreamName)).setter(GetRelationalDatabaseLogEventsRequest.setter(Builder::logStreamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logStreamName").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(GetRelationalDatabaseLogEventsRequest.getter(GetRelationalDatabaseLogEventsRequest::startTime)).setter(GetRelationalDatabaseLogEventsRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(GetRelationalDatabaseLogEventsRequest.getter(GetRelationalDatabaseLogEventsRequest::endTime)).setter(GetRelationalDatabaseLogEventsRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<Boolean> START_FROM_HEAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(GetRelationalDatabaseLogEventsRequest.getter(GetRelationalDatabaseLogEventsRequest::startFromHead)).setter(GetRelationalDatabaseLogEventsRequest.setter(Builder::startFromHead)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startFromHead").build()}).build();
    private static final SdkField<String> PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetRelationalDatabaseLogEventsRequest.getter(GetRelationalDatabaseLogEventsRequest::pageToken)).setter(GetRelationalDatabaseLogEventsRequest.setter(Builder::pageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RELATIONAL_DATABASE_NAME_FIELD, LOG_STREAM_NAME_FIELD, START_TIME_FIELD, END_TIME_FIELD, START_FROM_HEAD_FIELD, PAGE_TOKEN_FIELD));
    private final String relationalDatabaseName;
    private final String logStreamName;
    private final Instant startTime;
    private final Instant endTime;
    private final Boolean startFromHead;
    private final String pageToken;

    private GetRelationalDatabaseLogEventsRequest(BuilderImpl builder) {
        super(builder);
        this.relationalDatabaseName = builder.relationalDatabaseName;
        this.logStreamName = builder.logStreamName;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.startFromHead = builder.startFromHead;
        this.pageToken = builder.pageToken;
    }

    public String relationalDatabaseName() {
        return this.relationalDatabaseName;
    }

    public String logStreamName() {
        return this.logStreamName;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public Boolean startFromHead() {
        return this.startFromHead;
    }

    public String pageToken() {
        return this.pageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.relationalDatabaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.logStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.startFromHead());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRelationalDatabaseLogEventsRequest)) {
            return false;
        }
        GetRelationalDatabaseLogEventsRequest other = (GetRelationalDatabaseLogEventsRequest)((Object)obj);
        return Objects.equals(this.relationalDatabaseName(), other.relationalDatabaseName()) && Objects.equals(this.logStreamName(), other.logStreamName()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.startFromHead(), other.startFromHead()) && Objects.equals(this.pageToken(), other.pageToken());
    }

    public String toString() {
        return ToString.builder((String)"GetRelationalDatabaseLogEventsRequest").add("RelationalDatabaseName", (Object)this.relationalDatabaseName()).add("LogStreamName", (Object)this.logStreamName()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("StartFromHead", (Object)this.startFromHead()).add("PageToken", (Object)this.pageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "relationalDatabaseName": {
                return Optional.ofNullable(clazz.cast(this.relationalDatabaseName()));
            }
            case "logStreamName": {
                return Optional.ofNullable(clazz.cast(this.logStreamName()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "startFromHead": {
                return Optional.ofNullable(clazz.cast(this.startFromHead()));
            }
            case "pageToken": {
                return Optional.ofNullable(clazz.cast(this.pageToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRelationalDatabaseLogEventsRequest, T> g) {
        return obj -> g.apply((GetRelationalDatabaseLogEventsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private String relationalDatabaseName;
        private String logStreamName;
        private Instant startTime;
        private Instant endTime;
        private Boolean startFromHead;
        private String pageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRelationalDatabaseLogEventsRequest model) {
            super(model);
            this.relationalDatabaseName(model.relationalDatabaseName);
            this.logStreamName(model.logStreamName);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.startFromHead(model.startFromHead);
            this.pageToken(model.pageToken);
        }

        public final String getRelationalDatabaseName() {
            return this.relationalDatabaseName;
        }

        @Override
        public final Builder relationalDatabaseName(String relationalDatabaseName) {
            this.relationalDatabaseName = relationalDatabaseName;
            return this;
        }

        public final void setRelationalDatabaseName(String relationalDatabaseName) {
            this.relationalDatabaseName = relationalDatabaseName;
        }

        public final String getLogStreamName() {
            return this.logStreamName;
        }

        @Override
        public final Builder logStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
            return this;
        }

        public final void setLogStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Boolean getStartFromHead() {
            return this.startFromHead;
        }

        @Override
        public final Builder startFromHead(Boolean startFromHead) {
            this.startFromHead = startFromHead;
            return this;
        }

        public final void setStartFromHead(Boolean startFromHead) {
            this.startFromHead = startFromHead;
        }

        public final String getPageToken() {
            return this.pageToken;
        }

        @Override
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetRelationalDatabaseLogEventsRequest build() {
            return new GetRelationalDatabaseLogEventsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRelationalDatabaseLogEventsRequest> {
        public Builder relationalDatabaseName(String var1);

        public Builder logStreamName(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder startFromHead(Boolean var1);

        public Builder pageToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

