/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRegionsRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, GetRegionsRequest> {
    private static final SdkField<Boolean> INCLUDE_AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(GetRegionsRequest.getter(GetRegionsRequest::includeAvailabilityZones)).setter(GetRegionsRequest.setter(Builder::includeAvailabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeAvailabilityZones").build()}).build();
    private static final SdkField<Boolean> INCLUDE_RELATIONAL_DATABASE_AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(GetRegionsRequest.getter(GetRegionsRequest::includeRelationalDatabaseAvailabilityZones)).setter(GetRegionsRequest.setter(Builder::includeRelationalDatabaseAvailabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeRelationalDatabaseAvailabilityZones").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INCLUDE_AVAILABILITY_ZONES_FIELD, INCLUDE_RELATIONAL_DATABASE_AVAILABILITY_ZONES_FIELD));
    private final Boolean includeAvailabilityZones;
    private final Boolean includeRelationalDatabaseAvailabilityZones;

    private GetRegionsRequest(BuilderImpl builder) {
        super(builder);
        this.includeAvailabilityZones = builder.includeAvailabilityZones;
        this.includeRelationalDatabaseAvailabilityZones = builder.includeRelationalDatabaseAvailabilityZones;
    }

    public Boolean includeAvailabilityZones() {
        return this.includeAvailabilityZones;
    }

    public Boolean includeRelationalDatabaseAvailabilityZones() {
        return this.includeRelationalDatabaseAvailabilityZones;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.includeAvailabilityZones());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeRelationalDatabaseAvailabilityZones());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRegionsRequest)) {
            return false;
        }
        GetRegionsRequest other = (GetRegionsRequest)((Object)obj);
        return Objects.equals(this.includeAvailabilityZones(), other.includeAvailabilityZones()) && Objects.equals(this.includeRelationalDatabaseAvailabilityZones(), other.includeRelationalDatabaseAvailabilityZones());
    }

    public String toString() {
        return ToString.builder((String)"GetRegionsRequest").add("IncludeAvailabilityZones", (Object)this.includeAvailabilityZones()).add("IncludeRelationalDatabaseAvailabilityZones", (Object)this.includeRelationalDatabaseAvailabilityZones()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "includeAvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.includeAvailabilityZones()));
            }
            case "includeRelationalDatabaseAvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.includeRelationalDatabaseAvailabilityZones()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRegionsRequest, T> g) {
        return obj -> g.apply((GetRegionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private Boolean includeAvailabilityZones;
        private Boolean includeRelationalDatabaseAvailabilityZones;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRegionsRequest model) {
            super(model);
            this.includeAvailabilityZones(model.includeAvailabilityZones);
            this.includeRelationalDatabaseAvailabilityZones(model.includeRelationalDatabaseAvailabilityZones);
        }

        public final Boolean getIncludeAvailabilityZones() {
            return this.includeAvailabilityZones;
        }

        @Override
        public final Builder includeAvailabilityZones(Boolean includeAvailabilityZones) {
            this.includeAvailabilityZones = includeAvailabilityZones;
            return this;
        }

        public final void setIncludeAvailabilityZones(Boolean includeAvailabilityZones) {
            this.includeAvailabilityZones = includeAvailabilityZones;
        }

        public final Boolean getIncludeRelationalDatabaseAvailabilityZones() {
            return this.includeRelationalDatabaseAvailabilityZones;
        }

        @Override
        public final Builder includeRelationalDatabaseAvailabilityZones(Boolean includeRelationalDatabaseAvailabilityZones) {
            this.includeRelationalDatabaseAvailabilityZones = includeRelationalDatabaseAvailabilityZones;
            return this;
        }

        public final void setIncludeRelationalDatabaseAvailabilityZones(Boolean includeRelationalDatabaseAvailabilityZones) {
            this.includeRelationalDatabaseAvailabilityZones = includeRelationalDatabaseAvailabilityZones;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetRegionsRequest build() {
            return new GetRegionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRegionsRequest> {
        public Builder includeAvailabilityZones(Boolean var1);

        public Builder includeRelationalDatabaseAvailabilityZones(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

