/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.DiskSnapshotState;
import software.amazon.awssdk.services.lightsail.model.ResourceLocation;
import software.amazon.awssdk.services.lightsail.model.ResourceType;
import software.amazon.awssdk.services.lightsail.model.Tag;
import software.amazon.awssdk.services.lightsail.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DiskSnapshot
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DiskSnapshot> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DiskSnapshot.getter(DiskSnapshot::name)).setter(DiskSnapshot.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DiskSnapshot.getter(DiskSnapshot::arn)).setter(DiskSnapshot.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> SUPPORT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DiskSnapshot.getter(DiskSnapshot::supportCode)).setter(DiskSnapshot.setter(Builder::supportCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportCode").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DiskSnapshot.getter(DiskSnapshot::createdAt)).setter(DiskSnapshot.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<ResourceLocation> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DiskSnapshot.getter(DiskSnapshot::location)).setter(DiskSnapshot.setter(Builder::location)).constructor(ResourceLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DiskSnapshot.getter(DiskSnapshot::resourceTypeAsString)).setter(DiskSnapshot.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DiskSnapshot.getter(DiskSnapshot::tags)).setter(DiskSnapshot.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> SIZE_IN_GB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DiskSnapshot.getter(DiskSnapshot::sizeInGb)).setter(DiskSnapshot.setter(Builder::sizeInGb)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sizeInGb").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DiskSnapshot.getter(DiskSnapshot::stateAsString)).setter(DiskSnapshot.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DiskSnapshot.getter(DiskSnapshot::progress)).setter(DiskSnapshot.setter(Builder::progress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("progress").build()}).build();
    private static final SdkField<String> FROM_DISK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DiskSnapshot.getter(DiskSnapshot::fromDiskName)).setter(DiskSnapshot.setter(Builder::fromDiskName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fromDiskName").build()}).build();
    private static final SdkField<String> FROM_DISK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DiskSnapshot.getter(DiskSnapshot::fromDiskArn)).setter(DiskSnapshot.setter(Builder::fromDiskArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fromDiskArn").build()}).build();
    private static final SdkField<String> FROM_INSTANCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DiskSnapshot.getter(DiskSnapshot::fromInstanceName)).setter(DiskSnapshot.setter(Builder::fromInstanceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fromInstanceName").build()}).build();
    private static final SdkField<String> FROM_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DiskSnapshot.getter(DiskSnapshot::fromInstanceArn)).setter(DiskSnapshot.setter(Builder::fromInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fromInstanceArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD, SUPPORT_CODE_FIELD, CREATED_AT_FIELD, LOCATION_FIELD, RESOURCE_TYPE_FIELD, TAGS_FIELD, SIZE_IN_GB_FIELD, STATE_FIELD, PROGRESS_FIELD, FROM_DISK_NAME_FIELD, FROM_DISK_ARN_FIELD, FROM_INSTANCE_NAME_FIELD, FROM_INSTANCE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String arn;
    private final String supportCode;
    private final Instant createdAt;
    private final ResourceLocation location;
    private final String resourceType;
    private final List<Tag> tags;
    private final Integer sizeInGb;
    private final String state;
    private final String progress;
    private final String fromDiskName;
    private final String fromDiskArn;
    private final String fromInstanceName;
    private final String fromInstanceArn;

    private DiskSnapshot(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.supportCode = builder.supportCode;
        this.createdAt = builder.createdAt;
        this.location = builder.location;
        this.resourceType = builder.resourceType;
        this.tags = builder.tags;
        this.sizeInGb = builder.sizeInGb;
        this.state = builder.state;
        this.progress = builder.progress;
        this.fromDiskName = builder.fromDiskName;
        this.fromDiskArn = builder.fromDiskArn;
        this.fromInstanceName = builder.fromInstanceName;
        this.fromInstanceArn = builder.fromInstanceArn;
    }

    public String name() {
        return this.name;
    }

    public String arn() {
        return this.arn;
    }

    public String supportCode() {
        return this.supportCode;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public ResourceLocation location() {
        return this.location;
    }

    public ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public String resourceTypeAsString() {
        return this.resourceType;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Integer sizeInGb() {
        return this.sizeInGb;
    }

    public DiskSnapshotState state() {
        return DiskSnapshotState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public String progress() {
        return this.progress;
    }

    public String fromDiskName() {
        return this.fromDiskName;
    }

    public String fromDiskArn() {
        return this.fromDiskArn;
    }

    public String fromInstanceName() {
        return this.fromInstanceName;
    }

    public String fromInstanceArn() {
        return this.fromInstanceArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeInGb());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.progress());
        hashCode = 31 * hashCode + Objects.hashCode(this.fromDiskName());
        hashCode = 31 * hashCode + Objects.hashCode(this.fromDiskArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.fromInstanceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.fromInstanceArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiskSnapshot)) {
            return false;
        }
        DiskSnapshot other = (DiskSnapshot)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.supportCode(), other.supportCode()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.sizeInGb(), other.sizeInGb()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.progress(), other.progress()) && Objects.equals(this.fromDiskName(), other.fromDiskName()) && Objects.equals(this.fromDiskArn(), other.fromDiskArn()) && Objects.equals(this.fromInstanceName(), other.fromInstanceName()) && Objects.equals(this.fromInstanceArn(), other.fromInstanceArn());
    }

    public String toString() {
        return ToString.builder((String)"DiskSnapshot").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("SupportCode", (Object)this.supportCode()).add("CreatedAt", (Object)this.createdAt()).add("Location", (Object)this.location()).add("ResourceType", (Object)this.resourceTypeAsString()).add("Tags", this.tags()).add("SizeInGb", (Object)this.sizeInGb()).add("State", (Object)this.stateAsString()).add("Progress", (Object)this.progress()).add("FromDiskName", (Object)this.fromDiskName()).add("FromDiskArn", (Object)this.fromDiskArn()).add("FromInstanceName", (Object)this.fromInstanceName()).add("FromInstanceArn", (Object)this.fromInstanceArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "supportCode": {
                return Optional.ofNullable(clazz.cast(this.supportCode()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "sizeInGb": {
                return Optional.ofNullable(clazz.cast(this.sizeInGb()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "progress": {
                return Optional.ofNullable(clazz.cast(this.progress()));
            }
            case "fromDiskName": {
                return Optional.ofNullable(clazz.cast(this.fromDiskName()));
            }
            case "fromDiskArn": {
                return Optional.ofNullable(clazz.cast(this.fromDiskArn()));
            }
            case "fromInstanceName": {
                return Optional.ofNullable(clazz.cast(this.fromInstanceName()));
            }
            case "fromInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.fromInstanceArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DiskSnapshot, T> g) {
        return obj -> g.apply((DiskSnapshot)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private String supportCode;
        private Instant createdAt;
        private ResourceLocation location;
        private String resourceType;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private Integer sizeInGb;
        private String state;
        private String progress;
        private String fromDiskName;
        private String fromDiskArn;
        private String fromInstanceName;
        private String fromInstanceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DiskSnapshot model) {
            this.name(model.name);
            this.arn(model.arn);
            this.supportCode(model.supportCode);
            this.createdAt(model.createdAt);
            this.location(model.location);
            this.resourceType(model.resourceType);
            this.tags(model.tags);
            this.sizeInGb(model.sizeInGb);
            this.state(model.state);
            this.progress(model.progress);
            this.fromDiskName(model.fromDiskName);
            this.fromDiskArn(model.fromDiskArn);
            this.fromInstanceName(model.fromInstanceName);
            this.fromInstanceArn(model.fromInstanceArn);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getSupportCode() {
            return this.supportCode;
        }

        @Override
        public final Builder supportCode(String supportCode) {
            this.supportCode = supportCode;
            return this;
        }

        public final void setSupportCode(String supportCode) {
            this.supportCode = supportCode;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final ResourceLocation.Builder getLocation() {
            return this.location != null ? this.location.toBuilder() : null;
        }

        @Override
        public final Builder location(ResourceLocation location) {
            this.location = location;
            return this;
        }

        public final void setLocation(ResourceLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        public final String getResourceTypeAsString() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Integer getSizeInGb() {
            return this.sizeInGb;
        }

        @Override
        public final Builder sizeInGb(Integer sizeInGb) {
            this.sizeInGb = sizeInGb;
            return this;
        }

        public final void setSizeInGb(Integer sizeInGb) {
            this.sizeInGb = sizeInGb;
        }

        public final String getStateAsString() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(DiskSnapshotState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getProgress() {
            return this.progress;
        }

        @Override
        public final Builder progress(String progress) {
            this.progress = progress;
            return this;
        }

        public final void setProgress(String progress) {
            this.progress = progress;
        }

        public final String getFromDiskName() {
            return this.fromDiskName;
        }

        @Override
        public final Builder fromDiskName(String fromDiskName) {
            this.fromDiskName = fromDiskName;
            return this;
        }

        public final void setFromDiskName(String fromDiskName) {
            this.fromDiskName = fromDiskName;
        }

        public final String getFromDiskArn() {
            return this.fromDiskArn;
        }

        @Override
        public final Builder fromDiskArn(String fromDiskArn) {
            this.fromDiskArn = fromDiskArn;
            return this;
        }

        public final void setFromDiskArn(String fromDiskArn) {
            this.fromDiskArn = fromDiskArn;
        }

        public final String getFromInstanceName() {
            return this.fromInstanceName;
        }

        @Override
        public final Builder fromInstanceName(String fromInstanceName) {
            this.fromInstanceName = fromInstanceName;
            return this;
        }

        public final void setFromInstanceName(String fromInstanceName) {
            this.fromInstanceName = fromInstanceName;
        }

        public final String getFromInstanceArn() {
            return this.fromInstanceArn;
        }

        @Override
        public final Builder fromInstanceArn(String fromInstanceArn) {
            this.fromInstanceArn = fromInstanceArn;
            return this;
        }

        public final void setFromInstanceArn(String fromInstanceArn) {
            this.fromInstanceArn = fromInstanceArn;
        }

        public DiskSnapshot build() {
            return new DiskSnapshot(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DiskSnapshot> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder supportCode(String var1);

        public Builder createdAt(Instant var1);

        public Builder location(ResourceLocation var1);

        default public Builder location(Consumer<ResourceLocation.Builder> location) {
            return this.location((ResourceLocation)((ResourceLocation.Builder)ResourceLocation.builder().applyMutation(location)).build());
        }

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder sizeInGb(Integer var1);

        public Builder state(String var1);

        public Builder state(DiskSnapshotState var1);

        public Builder progress(String var1);

        public Builder fromDiskName(String var1);

        public Builder fromDiskArn(String var1);

        public Builder fromInstanceName(String var1);

        public Builder fromInstanceArn(String var1);
    }
}

