/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.services.lightsail.model.Tag;
import software.amazon.awssdk.services.lightsail.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRelationalDatabaseRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, CreateRelationalDatabaseRequest> {
    private static final SdkField<String> RELATIONAL_DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("relationalDatabaseName").getter(CreateRelationalDatabaseRequest.getter(CreateRelationalDatabaseRequest::relationalDatabaseName)).setter(CreateRelationalDatabaseRequest.setter(Builder::relationalDatabaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationalDatabaseName").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("availabilityZone").getter(CreateRelationalDatabaseRequest.getter(CreateRelationalDatabaseRequest::availabilityZone)).setter(CreateRelationalDatabaseRequest.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()}).build();
    private static final SdkField<String> RELATIONAL_DATABASE_BLUEPRINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("relationalDatabaseBlueprintId").getter(CreateRelationalDatabaseRequest.getter(CreateRelationalDatabaseRequest::relationalDatabaseBlueprintId)).setter(CreateRelationalDatabaseRequest.setter(Builder::relationalDatabaseBlueprintId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationalDatabaseBlueprintId").build()}).build();
    private static final SdkField<String> RELATIONAL_DATABASE_BUNDLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("relationalDatabaseBundleId").getter(CreateRelationalDatabaseRequest.getter(CreateRelationalDatabaseRequest::relationalDatabaseBundleId)).setter(CreateRelationalDatabaseRequest.setter(Builder::relationalDatabaseBundleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationalDatabaseBundleId").build()}).build();
    private static final SdkField<String> MASTER_DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("masterDatabaseName").getter(CreateRelationalDatabaseRequest.getter(CreateRelationalDatabaseRequest::masterDatabaseName)).setter(CreateRelationalDatabaseRequest.setter(Builder::masterDatabaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("masterDatabaseName").build()}).build();
    private static final SdkField<String> MASTER_USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("masterUsername").getter(CreateRelationalDatabaseRequest.getter(CreateRelationalDatabaseRequest::masterUsername)).setter(CreateRelationalDatabaseRequest.setter(Builder::masterUsername)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("masterUsername").build()}).build();
    private static final SdkField<String> MASTER_USER_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("masterUserPassword").getter(CreateRelationalDatabaseRequest.getter(CreateRelationalDatabaseRequest::masterUserPassword)).setter(CreateRelationalDatabaseRequest.setter(Builder::masterUserPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("masterUserPassword").build()}).build();
    private static final SdkField<String> PREFERRED_BACKUP_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("preferredBackupWindow").getter(CreateRelationalDatabaseRequest.getter(CreateRelationalDatabaseRequest::preferredBackupWindow)).setter(CreateRelationalDatabaseRequest.setter(Builder::preferredBackupWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preferredBackupWindow").build()}).build();
    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("preferredMaintenanceWindow").getter(CreateRelationalDatabaseRequest.getter(CreateRelationalDatabaseRequest::preferredMaintenanceWindow)).setter(CreateRelationalDatabaseRequest.setter(Builder::preferredMaintenanceWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preferredMaintenanceWindow").build()}).build();
    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("publiclyAccessible").getter(CreateRelationalDatabaseRequest.getter(CreateRelationalDatabaseRequest::publiclyAccessible)).setter(CreateRelationalDatabaseRequest.setter(Builder::publiclyAccessible)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publiclyAccessible").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateRelationalDatabaseRequest.getter(CreateRelationalDatabaseRequest::tags)).setter(CreateRelationalDatabaseRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RELATIONAL_DATABASE_NAME_FIELD, AVAILABILITY_ZONE_FIELD, RELATIONAL_DATABASE_BLUEPRINT_ID_FIELD, RELATIONAL_DATABASE_BUNDLE_ID_FIELD, MASTER_DATABASE_NAME_FIELD, MASTER_USERNAME_FIELD, MASTER_USER_PASSWORD_FIELD, PREFERRED_BACKUP_WINDOW_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, PUBLICLY_ACCESSIBLE_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateRelationalDatabaseRequest.memberNameToFieldInitializer();
    private final String relationalDatabaseName;
    private final String availabilityZone;
    private final String relationalDatabaseBlueprintId;
    private final String relationalDatabaseBundleId;
    private final String masterDatabaseName;
    private final String masterUsername;
    private final String masterUserPassword;
    private final String preferredBackupWindow;
    private final String preferredMaintenanceWindow;
    private final Boolean publiclyAccessible;
    private final List<Tag> tags;

    private CreateRelationalDatabaseRequest(BuilderImpl builder) {
        super(builder);
        this.relationalDatabaseName = builder.relationalDatabaseName;
        this.availabilityZone = builder.availabilityZone;
        this.relationalDatabaseBlueprintId = builder.relationalDatabaseBlueprintId;
        this.relationalDatabaseBundleId = builder.relationalDatabaseBundleId;
        this.masterDatabaseName = builder.masterDatabaseName;
        this.masterUsername = builder.masterUsername;
        this.masterUserPassword = builder.masterUserPassword;
        this.preferredBackupWindow = builder.preferredBackupWindow;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.tags = builder.tags;
    }

    public final String relationalDatabaseName() {
        return this.relationalDatabaseName;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final String relationalDatabaseBlueprintId() {
        return this.relationalDatabaseBlueprintId;
    }

    public final String relationalDatabaseBundleId() {
        return this.relationalDatabaseBundleId;
    }

    public final String masterDatabaseName() {
        return this.masterDatabaseName;
    }

    public final String masterUsername() {
        return this.masterUsername;
    }

    public final String masterUserPassword() {
        return this.masterUserPassword;
    }

    public final String preferredBackupWindow() {
        return this.preferredBackupWindow;
    }

    public final String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public final Boolean publiclyAccessible() {
        return this.publiclyAccessible;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.relationalDatabaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.relationalDatabaseBlueprintId());
        hashCode = 31 * hashCode + Objects.hashCode(this.relationalDatabaseBundleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterDatabaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterUsername());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredBackupWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRelationalDatabaseRequest)) {
            return false;
        }
        CreateRelationalDatabaseRequest other = (CreateRelationalDatabaseRequest)((Object)obj);
        return Objects.equals(this.relationalDatabaseName(), other.relationalDatabaseName()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.relationalDatabaseBlueprintId(), other.relationalDatabaseBlueprintId()) && Objects.equals(this.relationalDatabaseBundleId(), other.relationalDatabaseBundleId()) && Objects.equals(this.masterDatabaseName(), other.masterDatabaseName()) && Objects.equals(this.masterUsername(), other.masterUsername()) && Objects.equals(this.masterUserPassword(), other.masterUserPassword()) && Objects.equals(this.preferredBackupWindow(), other.preferredBackupWindow()) && Objects.equals(this.preferredMaintenanceWindow(), other.preferredMaintenanceWindow()) && Objects.equals(this.publiclyAccessible(), other.publiclyAccessible()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateRelationalDatabaseRequest").add("RelationalDatabaseName", (Object)this.relationalDatabaseName()).add("AvailabilityZone", (Object)this.availabilityZone()).add("RelationalDatabaseBlueprintId", (Object)this.relationalDatabaseBlueprintId()).add("RelationalDatabaseBundleId", (Object)this.relationalDatabaseBundleId()).add("MasterDatabaseName", (Object)this.masterDatabaseName()).add("MasterUsername", (Object)this.masterUsername()).add("MasterUserPassword", (Object)(this.masterUserPassword() == null ? null : "*** Sensitive Data Redacted ***")).add("PreferredBackupWindow", (Object)this.preferredBackupWindow()).add("PreferredMaintenanceWindow", (Object)this.preferredMaintenanceWindow()).add("PubliclyAccessible", (Object)this.publiclyAccessible()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "relationalDatabaseName": {
                return Optional.ofNullable(clazz.cast(this.relationalDatabaseName()));
            }
            case "availabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "relationalDatabaseBlueprintId": {
                return Optional.ofNullable(clazz.cast(this.relationalDatabaseBlueprintId()));
            }
            case "relationalDatabaseBundleId": {
                return Optional.ofNullable(clazz.cast(this.relationalDatabaseBundleId()));
            }
            case "masterDatabaseName": {
                return Optional.ofNullable(clazz.cast(this.masterDatabaseName()));
            }
            case "masterUsername": {
                return Optional.ofNullable(clazz.cast(this.masterUsername()));
            }
            case "masterUserPassword": {
                return Optional.ofNullable(clazz.cast(this.masterUserPassword()));
            }
            case "preferredBackupWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredBackupWindow()));
            }
            case "preferredMaintenanceWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredMaintenanceWindow()));
            }
            case "publiclyAccessible": {
                return Optional.ofNullable(clazz.cast(this.publiclyAccessible()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("relationalDatabaseName", RELATIONAL_DATABASE_NAME_FIELD);
        map.put("availabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("relationalDatabaseBlueprintId", RELATIONAL_DATABASE_BLUEPRINT_ID_FIELD);
        map.put("relationalDatabaseBundleId", RELATIONAL_DATABASE_BUNDLE_ID_FIELD);
        map.put("masterDatabaseName", MASTER_DATABASE_NAME_FIELD);
        map.put("masterUsername", MASTER_USERNAME_FIELD);
        map.put("masterUserPassword", MASTER_USER_PASSWORD_FIELD);
        map.put("preferredBackupWindow", PREFERRED_BACKUP_WINDOW_FIELD);
        map.put("preferredMaintenanceWindow", PREFERRED_MAINTENANCE_WINDOW_FIELD);
        map.put("publiclyAccessible", PUBLICLY_ACCESSIBLE_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateRelationalDatabaseRequest, T> g) {
        return obj -> g.apply((CreateRelationalDatabaseRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private String relationalDatabaseName;
        private String availabilityZone;
        private String relationalDatabaseBlueprintId;
        private String relationalDatabaseBundleId;
        private String masterDatabaseName;
        private String masterUsername;
        private String masterUserPassword;
        private String preferredBackupWindow;
        private String preferredMaintenanceWindow;
        private Boolean publiclyAccessible;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRelationalDatabaseRequest model) {
            super(model);
            this.relationalDatabaseName(model.relationalDatabaseName);
            this.availabilityZone(model.availabilityZone);
            this.relationalDatabaseBlueprintId(model.relationalDatabaseBlueprintId);
            this.relationalDatabaseBundleId(model.relationalDatabaseBundleId);
            this.masterDatabaseName(model.masterDatabaseName);
            this.masterUsername(model.masterUsername);
            this.masterUserPassword(model.masterUserPassword);
            this.preferredBackupWindow(model.preferredBackupWindow);
            this.preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.publiclyAccessible(model.publiclyAccessible);
            this.tags(model.tags);
        }

        public final String getRelationalDatabaseName() {
            return this.relationalDatabaseName;
        }

        public final void setRelationalDatabaseName(String relationalDatabaseName) {
            this.relationalDatabaseName = relationalDatabaseName;
        }

        @Override
        public final Builder relationalDatabaseName(String relationalDatabaseName) {
            this.relationalDatabaseName = relationalDatabaseName;
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getRelationalDatabaseBlueprintId() {
            return this.relationalDatabaseBlueprintId;
        }

        public final void setRelationalDatabaseBlueprintId(String relationalDatabaseBlueprintId) {
            this.relationalDatabaseBlueprintId = relationalDatabaseBlueprintId;
        }

        @Override
        public final Builder relationalDatabaseBlueprintId(String relationalDatabaseBlueprintId) {
            this.relationalDatabaseBlueprintId = relationalDatabaseBlueprintId;
            return this;
        }

        public final String getRelationalDatabaseBundleId() {
            return this.relationalDatabaseBundleId;
        }

        public final void setRelationalDatabaseBundleId(String relationalDatabaseBundleId) {
            this.relationalDatabaseBundleId = relationalDatabaseBundleId;
        }

        @Override
        public final Builder relationalDatabaseBundleId(String relationalDatabaseBundleId) {
            this.relationalDatabaseBundleId = relationalDatabaseBundleId;
            return this;
        }

        public final String getMasterDatabaseName() {
            return this.masterDatabaseName;
        }

        public final void setMasterDatabaseName(String masterDatabaseName) {
            this.masterDatabaseName = masterDatabaseName;
        }

        @Override
        public final Builder masterDatabaseName(String masterDatabaseName) {
            this.masterDatabaseName = masterDatabaseName;
            return this;
        }

        public final String getMasterUsername() {
            return this.masterUsername;
        }

        public final void setMasterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
        }

        @Override
        public final Builder masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        public final String getMasterUserPassword() {
            return this.masterUserPassword;
        }

        public final void setMasterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
        }

        @Override
        public final Builder masterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
            return this;
        }

        public final String getPreferredBackupWindow() {
            return this.preferredBackupWindow;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        @Override
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final Boolean getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRelationalDatabaseRequest build() {
            return new CreateRelationalDatabaseRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRelationalDatabaseRequest> {
        public Builder relationalDatabaseName(String var1);

        public Builder availabilityZone(String var1);

        public Builder relationalDatabaseBlueprintId(String var1);

        public Builder relationalDatabaseBundleId(String var1);

        public Builder masterDatabaseName(String var1);

        public Builder masterUsername(String var1);

        public Builder masterUserPassword(String var1);

        public Builder preferredBackupWindow(String var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder publiclyAccessible(Boolean var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

