/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PortAccessType {
    PUBLIC("Public"),
    PRIVATE("Private"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PortAccessType> VALUE_MAP;
    private final String value;

    private PortAccessType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PortAccessType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PortAccessType> knownValues() {
        EnumSet<PortAccessType> knownValues = EnumSet.allOf(PortAccessType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PortAccessType.class, PortAccessType::toString);
    }
}

