/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.CloudFormationStackRecord;
import software.amazon.awssdk.services.lightsail.model.CloudFormationStackRecordListCopier;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCloudFormationStackRecordsResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, GetCloudFormationStackRecordsResponse> {
    private static final SdkField<List<CloudFormationStackRecord>> CLOUD_FORMATION_STACK_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("cloudFormationStackRecords").getter(GetCloudFormationStackRecordsResponse.getter(GetCloudFormationStackRecordsResponse::cloudFormationStackRecords)).setter(GetCloudFormationStackRecordsResponse.setter(Builder::cloudFormationStackRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudFormationStackRecords").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CloudFormationStackRecord::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextPageToken").getter(GetCloudFormationStackRecordsResponse.getter(GetCloudFormationStackRecordsResponse::nextPageToken)).setter(GetCloudFormationStackRecordsResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_FORMATION_STACK_RECORDS_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetCloudFormationStackRecordsResponse.memberNameToFieldInitializer();
    private final List<CloudFormationStackRecord> cloudFormationStackRecords;
    private final String nextPageToken;

    private GetCloudFormationStackRecordsResponse(BuilderImpl builder) {
        super(builder);
        this.cloudFormationStackRecords = builder.cloudFormationStackRecords;
        this.nextPageToken = builder.nextPageToken;
    }

    public final boolean hasCloudFormationStackRecords() {
        return this.cloudFormationStackRecords != null && !(this.cloudFormationStackRecords instanceof SdkAutoConstructList);
    }

    public final List<CloudFormationStackRecord> cloudFormationStackRecords() {
        return this.cloudFormationStackRecords;
    }

    public final String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCloudFormationStackRecords() ? this.cloudFormationStackRecords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCloudFormationStackRecordsResponse)) {
            return false;
        }
        GetCloudFormationStackRecordsResponse other = (GetCloudFormationStackRecordsResponse)((Object)obj);
        return this.hasCloudFormationStackRecords() == other.hasCloudFormationStackRecords() && Objects.equals(this.cloudFormationStackRecords(), other.cloudFormationStackRecords()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetCloudFormationStackRecordsResponse").add("CloudFormationStackRecords", this.hasCloudFormationStackRecords() ? this.cloudFormationStackRecords() : null).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cloudFormationStackRecords": {
                return Optional.ofNullable(clazz.cast(this.cloudFormationStackRecords()));
            }
            case "nextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cloudFormationStackRecords", CLOUD_FORMATION_STACK_RECORDS_FIELD);
        map.put("nextPageToken", NEXT_PAGE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCloudFormationStackRecordsResponse, T> g) {
        return obj -> g.apply((GetCloudFormationStackRecordsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private List<CloudFormationStackRecord> cloudFormationStackRecords = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCloudFormationStackRecordsResponse model) {
            super(model);
            this.cloudFormationStackRecords(model.cloudFormationStackRecords);
            this.nextPageToken(model.nextPageToken);
        }

        public final List<CloudFormationStackRecord.Builder> getCloudFormationStackRecords() {
            List<CloudFormationStackRecord.Builder> result = CloudFormationStackRecordListCopier.copyToBuilder(this.cloudFormationStackRecords);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCloudFormationStackRecords(Collection<CloudFormationStackRecord.BuilderImpl> cloudFormationStackRecords) {
            this.cloudFormationStackRecords = CloudFormationStackRecordListCopier.copyFromBuilder(cloudFormationStackRecords);
        }

        @Override
        public final Builder cloudFormationStackRecords(Collection<CloudFormationStackRecord> cloudFormationStackRecords) {
            this.cloudFormationStackRecords = CloudFormationStackRecordListCopier.copy(cloudFormationStackRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudFormationStackRecords(CloudFormationStackRecord ... cloudFormationStackRecords) {
            this.cloudFormationStackRecords(Arrays.asList(cloudFormationStackRecords));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudFormationStackRecords(Consumer<CloudFormationStackRecord.Builder> ... cloudFormationStackRecords) {
            this.cloudFormationStackRecords(Stream.of(cloudFormationStackRecords).map(c -> (CloudFormationStackRecord)((CloudFormationStackRecord.Builder)CloudFormationStackRecord.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public GetCloudFormationStackRecordsResponse build() {
            return new GetCloudFormationStackRecordsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LightsailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCloudFormationStackRecordsResponse> {
        public Builder cloudFormationStackRecords(Collection<CloudFormationStackRecord> var1);

        public Builder cloudFormationStackRecords(CloudFormationStackRecord ... var1);

        public Builder cloudFormationStackRecords(Consumer<CloudFormationStackRecord.Builder> ... var1);

        public Builder nextPageToken(String var1);
    }
}

