/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Session
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Session> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Session.getter(Session::name)).setter(Session.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("url").getter(Session.getter(Session::url)).setter(Session.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()}).build();
    private static final SdkField<Boolean> IS_PRIMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isPrimary").getter(Session.getter(Session::isPrimary)).setter(Session.setter(Builder::isPrimary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isPrimary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, URL_FIELD, IS_PRIMARY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Session.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String url;
    private final Boolean isPrimary;

    private Session(BuilderImpl builder) {
        this.name = builder.name;
        this.url = builder.url;
        this.isPrimary = builder.isPrimary;
    }

    public final String name() {
        return this.name;
    }

    public final String url() {
        return this.url;
    }

    public final Boolean isPrimary() {
        return this.isPrimary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.isPrimary());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Session)) {
            return false;
        }
        Session other = (Session)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.url(), other.url()) && Objects.equals(this.isPrimary(), other.isPrimary());
    }

    public final String toString() {
        return ToString.builder((String)"Session").add("Name", (Object)this.name()).add("Url", (Object)(this.url() == null ? null : "*** Sensitive Data Redacted ***")).add("IsPrimary", (Object)this.isPrimary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
            case "isPrimary": {
                return Optional.ofNullable(clazz.cast(this.isPrimary()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("url", URL_FIELD);
        map.put("isPrimary", IS_PRIMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Session, T> g) {
        return obj -> g.apply((Session)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String url;
        private Boolean isPrimary;

        private BuilderImpl() {
        }

        private BuilderImpl(Session model) {
            this.name(model.name);
            this.url(model.url);
            this.isPrimary(model.isPrimary);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final Boolean getIsPrimary() {
            return this.isPrimary;
        }

        public final void setIsPrimary(Boolean isPrimary) {
            this.isPrimary = isPrimary;
        }

        @Override
        public final Builder isPrimary(Boolean isPrimary) {
            this.isPrimary = isPrimary;
            return this;
        }

        public Session build() {
            return new Session(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Session> {
        public Builder name(String var1);

        public Builder url(String var1);

        public Builder isPrimary(Boolean var1);
    }
}

