/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RelationalDatabaseEndpoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RelationalDatabaseEndpoint> {
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("port").getter(RelationalDatabaseEndpoint.getter(RelationalDatabaseEndpoint::port)).setter(RelationalDatabaseEndpoint.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()}).build();
    private static final SdkField<String> ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("address").getter(RelationalDatabaseEndpoint.getter(RelationalDatabaseEndpoint::address)).setter(RelationalDatabaseEndpoint.setter(Builder::address)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("address").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORT_FIELD, ADDRESS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RelationalDatabaseEndpoint.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer port;
    private final String address;

    private RelationalDatabaseEndpoint(BuilderImpl builder) {
        this.port = builder.port;
        this.address = builder.address;
    }

    public final Integer port() {
        return this.port;
    }

    public final String address() {
        return this.address;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.address());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelationalDatabaseEndpoint)) {
            return false;
        }
        RelationalDatabaseEndpoint other = (RelationalDatabaseEndpoint)obj;
        return Objects.equals(this.port(), other.port()) && Objects.equals(this.address(), other.address());
    }

    public final String toString() {
        return ToString.builder((String)"RelationalDatabaseEndpoint").add("Port", (Object)this.port()).add("Address", (Object)this.address()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "address": {
                return Optional.ofNullable(clazz.cast(this.address()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("port", PORT_FIELD);
        map.put("address", ADDRESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RelationalDatabaseEndpoint, T> g) {
        return obj -> g.apply((RelationalDatabaseEndpoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer port;
        private String address;

        private BuilderImpl() {
        }

        private BuilderImpl(RelationalDatabaseEndpoint model) {
            this.port(model.port);
            this.address(model.address);
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getAddress() {
            return this.address;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        @Override
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public RelationalDatabaseEndpoint build() {
            return new RelationalDatabaseEndpoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RelationalDatabaseEndpoint> {
        public Builder port(Integer var1);

        public Builder address(String var1);
    }
}

