/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ContainerServiceState {
    PENDING("PENDING"),
    READY("READY"),
    RUNNING("RUNNING"),
    UPDATING("UPDATING"),
    DELETING("DELETING"),
    DISABLED("DISABLED"),
    DEPLOYING("DEPLOYING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ContainerServiceState> VALUE_MAP;
    private final String value;

    private ContainerServiceState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ContainerServiceState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ContainerServiceState> knownValues() {
        EnumSet<ContainerServiceState> knownValues = EnumSet.allOf(ContainerServiceState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ContainerServiceState.class, ContainerServiceState::toString);
    }
}

