/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BucketMetricName {
    BUCKET_SIZE_BYTES("BucketSizeBytes"),
    NUMBER_OF_OBJECTS("NumberOfObjects"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BucketMetricName> VALUE_MAP;
    private final String value;

    private BucketMetricName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BucketMetricName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BucketMetricName> knownValues() {
        EnumSet<BucketMetricName> knownValues = EnumSet.allOf(BucketMetricName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BucketMetricName.class, BucketMetricName::toString);
    }
}

