/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.services.lightsail.model.Operation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResetDistributionCacheResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, ResetDistributionCacheResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ResetDistributionCacheResponse.getter(ResetDistributionCacheResponse::status)).setter(ResetDistributionCacheResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createTime").getter(ResetDistributionCacheResponse.getter(ResetDistributionCacheResponse::createTime)).setter(ResetDistributionCacheResponse.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()}).build();
    private static final SdkField<Operation> OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("operation").getter(ResetDistributionCacheResponse.getter(ResetDistributionCacheResponse::operation)).setter(ResetDistributionCacheResponse.setter(Builder::operation)).constructor(Operation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, CREATE_TIME_FIELD, OPERATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("status", STATUS_FIELD);
            this.put("createTime", CREATE_TIME_FIELD);
            this.put("operation", OPERATION_FIELD);
        }
    });
    private final String status;
    private final Instant createTime;
    private final Operation operation;

    private ResetDistributionCacheResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.createTime = builder.createTime;
        this.operation = builder.operation;
    }

    public final String status() {
        return this.status;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Operation operation() {
        return this.operation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.operation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResetDistributionCacheResponse)) {
            return false;
        }
        ResetDistributionCacheResponse other = (ResetDistributionCacheResponse)((Object)obj);
        return Objects.equals(this.status(), other.status()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.operation(), other.operation());
    }

    public final String toString() {
        return ToString.builder((String)"ResetDistributionCacheResponse").add("Status", (Object)this.status()).add("CreateTime", (Object)this.createTime()).add("Operation", (Object)this.operation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "operation": {
                return Optional.ofNullable(clazz.cast(this.operation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ResetDistributionCacheResponse, T> g) {
        return obj -> g.apply((ResetDistributionCacheResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private String status;
        private Instant createTime;
        private Operation operation;

        private BuilderImpl() {
        }

        private BuilderImpl(ResetDistributionCacheResponse model) {
            super(model);
            this.status(model.status);
            this.createTime(model.createTime);
            this.operation(model.operation);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Operation.Builder getOperation() {
            return this.operation != null ? this.operation.toBuilder() : null;
        }

        public final void setOperation(Operation.BuilderImpl operation) {
            this.operation = operation != null ? operation.build() : null;
        }

        @Override
        public final Builder operation(Operation operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public ResetDistributionCacheResponse build() {
            return new ResetDistributionCacheResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LightsailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ResetDistributionCacheResponse> {
        public Builder status(String var1);

        public Builder createTime(Instant var1);

        public Builder operation(Operation var1);

        default public Builder operation(Consumer<Operation.Builder> operation) {
            return this.operation((Operation)((Operation.Builder)Operation.builder().applyMutation(operation)).build());
        }
    }
}

