/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AppCategory {
    LFR("LfR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AppCategory> VALUE_MAP;
    private final String value;

    private AppCategory(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AppCategory fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AppCategory> knownValues() {
        EnumSet<AppCategory> knownValues = EnumSet.allOf(AppCategory.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AppCategory.class, AppCategory::toString);
    }
}

