/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RelationalDatabaseHardware
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RelationalDatabaseHardware> {
    private static final SdkField<Integer> CPU_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("cpuCount").getter(RelationalDatabaseHardware.getter(RelationalDatabaseHardware::cpuCount)).setter(RelationalDatabaseHardware.setter(Builder::cpuCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpuCount").build()}).build();
    private static final SdkField<Integer> DISK_SIZE_IN_GB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("diskSizeInGb").getter(RelationalDatabaseHardware.getter(RelationalDatabaseHardware::diskSizeInGb)).setter(RelationalDatabaseHardware.setter(Builder::diskSizeInGb)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("diskSizeInGb").build()}).build();
    private static final SdkField<Float> RAM_SIZE_IN_GB_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("ramSizeInGb").getter(RelationalDatabaseHardware.getter(RelationalDatabaseHardware::ramSizeInGb)).setter(RelationalDatabaseHardware.setter(Builder::ramSizeInGb)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ramSizeInGb").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CPU_COUNT_FIELD, DISK_SIZE_IN_GB_FIELD, RAM_SIZE_IN_GB_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer cpuCount;
    private final Integer diskSizeInGb;
    private final Float ramSizeInGb;

    private RelationalDatabaseHardware(BuilderImpl builder) {
        this.cpuCount = builder.cpuCount;
        this.diskSizeInGb = builder.diskSizeInGb;
        this.ramSizeInGb = builder.ramSizeInGb;
    }

    public final Integer cpuCount() {
        return this.cpuCount;
    }

    public final Integer diskSizeInGb() {
        return this.diskSizeInGb;
    }

    public final Float ramSizeInGb() {
        return this.ramSizeInGb;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cpuCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.diskSizeInGb());
        hashCode = 31 * hashCode + Objects.hashCode(this.ramSizeInGb());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelationalDatabaseHardware)) {
            return false;
        }
        RelationalDatabaseHardware other = (RelationalDatabaseHardware)obj;
        return Objects.equals(this.cpuCount(), other.cpuCount()) && Objects.equals(this.diskSizeInGb(), other.diskSizeInGb()) && Objects.equals(this.ramSizeInGb(), other.ramSizeInGb());
    }

    public final String toString() {
        return ToString.builder((String)"RelationalDatabaseHardware").add("CpuCount", (Object)this.cpuCount()).add("DiskSizeInGb", (Object)this.diskSizeInGb()).add("RamSizeInGb", (Object)this.ramSizeInGb()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cpuCount": {
                return Optional.ofNullable(clazz.cast(this.cpuCount()));
            }
            case "diskSizeInGb": {
                return Optional.ofNullable(clazz.cast(this.diskSizeInGb()));
            }
            case "ramSizeInGb": {
                return Optional.ofNullable(clazz.cast(this.ramSizeInGb()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RelationalDatabaseHardware, T> g) {
        return obj -> g.apply((RelationalDatabaseHardware)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer cpuCount;
        private Integer diskSizeInGb;
        private Float ramSizeInGb;

        private BuilderImpl() {
        }

        private BuilderImpl(RelationalDatabaseHardware model) {
            this.cpuCount(model.cpuCount);
            this.diskSizeInGb(model.diskSizeInGb);
            this.ramSizeInGb(model.ramSizeInGb);
        }

        public final Integer getCpuCount() {
            return this.cpuCount;
        }

        public final void setCpuCount(Integer cpuCount) {
            this.cpuCount = cpuCount;
        }

        @Override
        public final Builder cpuCount(Integer cpuCount) {
            this.cpuCount = cpuCount;
            return this;
        }

        public final Integer getDiskSizeInGb() {
            return this.diskSizeInGb;
        }

        public final void setDiskSizeInGb(Integer diskSizeInGb) {
            this.diskSizeInGb = diskSizeInGb;
        }

        @Override
        public final Builder diskSizeInGb(Integer diskSizeInGb) {
            this.diskSizeInGb = diskSizeInGb;
            return this;
        }

        public final Float getRamSizeInGb() {
            return this.ramSizeInGb;
        }

        public final void setRamSizeInGb(Float ramSizeInGb) {
            this.ramSizeInGb = ramSizeInGb;
        }

        @Override
        public final Builder ramSizeInGb(Float ramSizeInGb) {
            this.ramSizeInGb = ramSizeInGb;
            return this;
        }

        public RelationalDatabaseHardware build() {
            return new RelationalDatabaseHardware(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RelationalDatabaseHardware> {
        public Builder cpuCount(Integer var1);

        public Builder diskSizeInGb(Integer var1);

        public Builder ramSizeInGb(Float var1);
    }
}

