/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.MetricUnit;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricDatapoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricDatapoint> {
    private static final SdkField<Double> AVERAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("average").getter(MetricDatapoint.getter(MetricDatapoint::average)).setter(MetricDatapoint.setter(Builder::average)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("average").build()}).build();
    private static final SdkField<Double> MAXIMUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("maximum").getter(MetricDatapoint.getter(MetricDatapoint::maximum)).setter(MetricDatapoint.setter(Builder::maximum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximum").build()}).build();
    private static final SdkField<Double> MINIMUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("minimum").getter(MetricDatapoint.getter(MetricDatapoint::minimum)).setter(MetricDatapoint.setter(Builder::minimum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimum").build()}).build();
    private static final SdkField<Double> SAMPLE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("sampleCount").getter(MetricDatapoint.getter(MetricDatapoint::sampleCount)).setter(MetricDatapoint.setter(Builder::sampleCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleCount").build()}).build();
    private static final SdkField<Double> SUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("sum").getter(MetricDatapoint.getter(MetricDatapoint::sum)).setter(MetricDatapoint.setter(Builder::sum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sum").build()}).build();
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("timestamp").getter(MetricDatapoint.getter(MetricDatapoint::timestamp)).setter(MetricDatapoint.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()}).build();
    private static final SdkField<String> UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("unit").getter(MetricDatapoint.getter(MetricDatapoint::unitAsString)).setter(MetricDatapoint.setter(Builder::unit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVERAGE_FIELD, MAXIMUM_FIELD, MINIMUM_FIELD, SAMPLE_COUNT_FIELD, SUM_FIELD, TIMESTAMP_FIELD, UNIT_FIELD));
    private static final long serialVersionUID = 1L;
    private final Double average;
    private final Double maximum;
    private final Double minimum;
    private final Double sampleCount;
    private final Double sum;
    private final Instant timestamp;
    private final String unit;

    private MetricDatapoint(BuilderImpl builder) {
        this.average = builder.average;
        this.maximum = builder.maximum;
        this.minimum = builder.minimum;
        this.sampleCount = builder.sampleCount;
        this.sum = builder.sum;
        this.timestamp = builder.timestamp;
        this.unit = builder.unit;
    }

    public final Double average() {
        return this.average;
    }

    public final Double maximum() {
        return this.maximum;
    }

    public final Double minimum() {
        return this.minimum;
    }

    public final Double sampleCount() {
        return this.sampleCount;
    }

    public final Double sum() {
        return this.sum;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    public final MetricUnit unit() {
        return MetricUnit.fromValue(this.unit);
    }

    public final String unitAsString() {
        return this.unit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.average());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximum());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimum());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.sum());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.unitAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricDatapoint)) {
            return false;
        }
        MetricDatapoint other = (MetricDatapoint)obj;
        return Objects.equals(this.average(), other.average()) && Objects.equals(this.maximum(), other.maximum()) && Objects.equals(this.minimum(), other.minimum()) && Objects.equals(this.sampleCount(), other.sampleCount()) && Objects.equals(this.sum(), other.sum()) && Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.unitAsString(), other.unitAsString());
    }

    public final String toString() {
        return ToString.builder((String)"MetricDatapoint").add("Average", (Object)this.average()).add("Maximum", (Object)this.maximum()).add("Minimum", (Object)this.minimum()).add("SampleCount", (Object)this.sampleCount()).add("Sum", (Object)this.sum()).add("Timestamp", (Object)this.timestamp()).add("Unit", (Object)this.unitAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "average": {
                return Optional.ofNullable(clazz.cast(this.average()));
            }
            case "maximum": {
                return Optional.ofNullable(clazz.cast(this.maximum()));
            }
            case "minimum": {
                return Optional.ofNullable(clazz.cast(this.minimum()));
            }
            case "sampleCount": {
                return Optional.ofNullable(clazz.cast(this.sampleCount()));
            }
            case "sum": {
                return Optional.ofNullable(clazz.cast(this.sum()));
            }
            case "timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "unit": {
                return Optional.ofNullable(clazz.cast(this.unitAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricDatapoint, T> g) {
        return obj -> g.apply((MetricDatapoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double average;
        private Double maximum;
        private Double minimum;
        private Double sampleCount;
        private Double sum;
        private Instant timestamp;
        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricDatapoint model) {
            this.average(model.average);
            this.maximum(model.maximum);
            this.minimum(model.minimum);
            this.sampleCount(model.sampleCount);
            this.sum(model.sum);
            this.timestamp(model.timestamp);
            this.unit(model.unit);
        }

        public final Double getAverage() {
            return this.average;
        }

        public final void setAverage(Double average) {
            this.average = average;
        }

        @Override
        public final Builder average(Double average) {
            this.average = average;
            return this;
        }

        public final Double getMaximum() {
            return this.maximum;
        }

        public final void setMaximum(Double maximum) {
            this.maximum = maximum;
        }

        @Override
        public final Builder maximum(Double maximum) {
            this.maximum = maximum;
            return this;
        }

        public final Double getMinimum() {
            return this.minimum;
        }

        public final void setMinimum(Double minimum) {
            this.minimum = minimum;
        }

        @Override
        public final Builder minimum(Double minimum) {
            this.minimum = minimum;
            return this;
        }

        public final Double getSampleCount() {
            return this.sampleCount;
        }

        public final void setSampleCount(Double sampleCount) {
            this.sampleCount = sampleCount;
        }

        @Override
        public final Builder sampleCount(Double sampleCount) {
            this.sampleCount = sampleCount;
            return this;
        }

        public final Double getSum() {
            return this.sum;
        }

        public final void setSum(Double sum) {
            this.sum = sum;
        }

        @Override
        public final Builder sum(Double sum) {
            this.sum = sum;
            return this;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final String getUnit() {
            return this.unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(MetricUnit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        public MetricDatapoint build() {
            return new MetricDatapoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricDatapoint> {
        public Builder average(Double var1);

        public Builder maximum(Double var1);

        public Builder minimum(Double var1);

        public Builder sampleCount(Double var1);

        public Builder sum(Double var1);

        public Builder timestamp(Instant var1);

        public Builder unit(String var1);

        public Builder unit(MetricUnit var1);
    }
}

