/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InstanceHealthState {
    INITIAL("initial"),
    HEALTHY("healthy"),
    UNHEALTHY("unhealthy"),
    UNUSED("unused"),
    DRAINING("draining"),
    UNAVAILABLE("unavailable"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InstanceHealthState> VALUE_MAP;
    private final String value;

    private InstanceHealthState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InstanceHealthState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InstanceHealthState> knownValues() {
        EnumSet<InstanceHealthState> knownValues = EnumSet.allOf(InstanceHealthState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InstanceHealthState.class, InstanceHealthState::toString);
    }
}

