/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RenewalStatus {
    PENDING_AUTO_RENEWAL("PendingAutoRenewal"),
    PENDING_VALIDATION("PendingValidation"),
    SUCCESS("Success"),
    FAILED("Failed"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RenewalStatus> VALUE_MAP;
    private final String value;

    private RenewalStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RenewalStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RenewalStatus> knownValues() {
        EnumSet<RenewalStatus> knownValues = EnumSet.allOf(RenewalStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RenewalStatus.class, RenewalStatus::toString);
    }
}

