/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LoadBalancerAttributeName {
    HEALTH_CHECK_PATH("HealthCheckPath"),
    SESSION_STICKINESS_ENABLED("SessionStickinessEnabled"),
    SESSION_STICKINESS_LB_COOKIE_DURATION_SECONDS("SessionStickiness_LB_CookieDurationSeconds"),
    HTTPS_REDIRECTION_ENABLED("HttpsRedirectionEnabled"),
    TLS_POLICY_NAME("TlsPolicyName"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LoadBalancerAttributeName> VALUE_MAP;
    private final String value;

    private LoadBalancerAttributeName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LoadBalancerAttributeName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LoadBalancerAttributeName> knownValues() {
        EnumSet<LoadBalancerAttributeName> knownValues = EnumSet.allOf(LoadBalancerAttributeName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LoadBalancerAttributeName.class, LoadBalancerAttributeName::toString);
    }
}

