/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AttachDiskRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, AttachDiskRequest> {
    private static final SdkField<String> DISK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("diskName").getter(AttachDiskRequest.getter(AttachDiskRequest::diskName)).setter(AttachDiskRequest.setter(Builder::diskName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("diskName").build()}).build();
    private static final SdkField<String> INSTANCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceName").getter(AttachDiskRequest.getter(AttachDiskRequest::instanceName)).setter(AttachDiskRequest.setter(Builder::instanceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceName").build()}).build();
    private static final SdkField<String> DISK_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("diskPath").getter(AttachDiskRequest.getter(AttachDiskRequest::diskPath)).setter(AttachDiskRequest.setter(Builder::diskPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("diskPath").build()}).build();
    private static final SdkField<Boolean> AUTO_MOUNTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("autoMounting").getter(AttachDiskRequest.getter(AttachDiskRequest::autoMounting)).setter(AttachDiskRequest.setter(Builder::autoMounting)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoMounting").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISK_NAME_FIELD, INSTANCE_NAME_FIELD, DISK_PATH_FIELD, AUTO_MOUNTING_FIELD));
    private final String diskName;
    private final String instanceName;
    private final String diskPath;
    private final Boolean autoMounting;

    private AttachDiskRequest(BuilderImpl builder) {
        super(builder);
        this.diskName = builder.diskName;
        this.instanceName = builder.instanceName;
        this.diskPath = builder.diskPath;
        this.autoMounting = builder.autoMounting;
    }

    public final String diskName() {
        return this.diskName;
    }

    public final String instanceName() {
        return this.instanceName;
    }

    public final String diskPath() {
        return this.diskPath;
    }

    public final Boolean autoMounting() {
        return this.autoMounting;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.diskName());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.diskPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMounting());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachDiskRequest)) {
            return false;
        }
        AttachDiskRequest other = (AttachDiskRequest)((Object)obj);
        return Objects.equals(this.diskName(), other.diskName()) && Objects.equals(this.instanceName(), other.instanceName()) && Objects.equals(this.diskPath(), other.diskPath()) && Objects.equals(this.autoMounting(), other.autoMounting());
    }

    public final String toString() {
        return ToString.builder((String)"AttachDiskRequest").add("DiskName", (Object)this.diskName()).add("InstanceName", (Object)this.instanceName()).add("DiskPath", (Object)this.diskPath()).add("AutoMounting", (Object)this.autoMounting()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "diskName": {
                return Optional.ofNullable(clazz.cast(this.diskName()));
            }
            case "instanceName": {
                return Optional.ofNullable(clazz.cast(this.instanceName()));
            }
            case "diskPath": {
                return Optional.ofNullable(clazz.cast(this.diskPath()));
            }
            case "autoMounting": {
                return Optional.ofNullable(clazz.cast(this.autoMounting()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttachDiskRequest, T> g) {
        return obj -> g.apply((AttachDiskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private String diskName;
        private String instanceName;
        private String diskPath;
        private Boolean autoMounting;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachDiskRequest model) {
            super(model);
            this.diskName(model.diskName);
            this.instanceName(model.instanceName);
            this.diskPath(model.diskPath);
            this.autoMounting(model.autoMounting);
        }

        public final String getDiskName() {
            return this.diskName;
        }

        public final void setDiskName(String diskName) {
            this.diskName = diskName;
        }

        @Override
        public final Builder diskName(String diskName) {
            this.diskName = diskName;
            return this;
        }

        public final String getInstanceName() {
            return this.instanceName;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final String getDiskPath() {
            return this.diskPath;
        }

        public final void setDiskPath(String diskPath) {
            this.diskPath = diskPath;
        }

        @Override
        public final Builder diskPath(String diskPath) {
            this.diskPath = diskPath;
            return this;
        }

        public final Boolean getAutoMounting() {
            return this.autoMounting;
        }

        public final void setAutoMounting(Boolean autoMounting) {
            this.autoMounting = autoMounting;
        }

        @Override
        public final Builder autoMounting(Boolean autoMounting) {
            this.autoMounting = autoMounting;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AttachDiskRequest build() {
            return new AttachDiskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AttachDiskRequest> {
        public Builder diskName(String var1);

        public Builder instanceName(String var1);

        public Builder diskPath(String var1);

        public Builder autoMounting(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

