/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.services.lightsail.model.RelationalDatabasePasswordVersion;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRelationalDatabaseMasterUserPasswordRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, GetRelationalDatabaseMasterUserPasswordRequest> {
    private static final SdkField<String> RELATIONAL_DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetRelationalDatabaseMasterUserPasswordRequest.getter(GetRelationalDatabaseMasterUserPasswordRequest::relationalDatabaseName)).setter(GetRelationalDatabaseMasterUserPasswordRequest.setter(Builder::relationalDatabaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationalDatabaseName").build()}).build();
    private static final SdkField<String> PASSWORD_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetRelationalDatabaseMasterUserPasswordRequest.getter(GetRelationalDatabaseMasterUserPasswordRequest::passwordVersionAsString)).setter(GetRelationalDatabaseMasterUserPasswordRequest.setter(Builder::passwordVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("passwordVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RELATIONAL_DATABASE_NAME_FIELD, PASSWORD_VERSION_FIELD));
    private final String relationalDatabaseName;
    private final String passwordVersion;

    private GetRelationalDatabaseMasterUserPasswordRequest(BuilderImpl builder) {
        super(builder);
        this.relationalDatabaseName = builder.relationalDatabaseName;
        this.passwordVersion = builder.passwordVersion;
    }

    public String relationalDatabaseName() {
        return this.relationalDatabaseName;
    }

    public RelationalDatabasePasswordVersion passwordVersion() {
        return RelationalDatabasePasswordVersion.fromValue(this.passwordVersion);
    }

    public String passwordVersionAsString() {
        return this.passwordVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.relationalDatabaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.passwordVersionAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRelationalDatabaseMasterUserPasswordRequest)) {
            return false;
        }
        GetRelationalDatabaseMasterUserPasswordRequest other = (GetRelationalDatabaseMasterUserPasswordRequest)((Object)obj);
        return Objects.equals(this.relationalDatabaseName(), other.relationalDatabaseName()) && Objects.equals(this.passwordVersionAsString(), other.passwordVersionAsString());
    }

    public String toString() {
        return ToString.builder((String)"GetRelationalDatabaseMasterUserPasswordRequest").add("RelationalDatabaseName", (Object)this.relationalDatabaseName()).add("PasswordVersion", (Object)this.passwordVersionAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "relationalDatabaseName": {
                return Optional.ofNullable(clazz.cast(this.relationalDatabaseName()));
            }
            case "passwordVersion": {
                return Optional.ofNullable(clazz.cast(this.passwordVersionAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRelationalDatabaseMasterUserPasswordRequest, T> g) {
        return obj -> g.apply((GetRelationalDatabaseMasterUserPasswordRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private String relationalDatabaseName;
        private String passwordVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRelationalDatabaseMasterUserPasswordRequest model) {
            super(model);
            this.relationalDatabaseName(model.relationalDatabaseName);
            this.passwordVersion(model.passwordVersion);
        }

        public final String getRelationalDatabaseName() {
            return this.relationalDatabaseName;
        }

        @Override
        public final Builder relationalDatabaseName(String relationalDatabaseName) {
            this.relationalDatabaseName = relationalDatabaseName;
            return this;
        }

        public final void setRelationalDatabaseName(String relationalDatabaseName) {
            this.relationalDatabaseName = relationalDatabaseName;
        }

        public final String getPasswordVersion() {
            return this.passwordVersion;
        }

        @Override
        public final Builder passwordVersion(String passwordVersion) {
            this.passwordVersion = passwordVersion;
            return this;
        }

        @Override
        public final Builder passwordVersion(RelationalDatabasePasswordVersion passwordVersion) {
            this.passwordVersion(passwordVersion.toString());
            return this;
        }

        public final void setPasswordVersion(String passwordVersion) {
            this.passwordVersion = passwordVersion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetRelationalDatabaseMasterUserPasswordRequest build() {
            return new GetRelationalDatabaseMasterUserPasswordRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRelationalDatabaseMasterUserPasswordRequest> {
        public Builder relationalDatabaseName(String var1);

        public Builder passwordVersion(String var1);

        public Builder passwordVersion(RelationalDatabasePasswordVersion var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

