/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.ContainerServiceHealthCheckConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContainerServiceEndpoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContainerServiceEndpoint> {
    private static final SdkField<String> CONTAINER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("containerName").getter(ContainerServiceEndpoint.getter(ContainerServiceEndpoint::containerName)).setter(ContainerServiceEndpoint.setter(Builder::containerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerName").build()}).build();
    private static final SdkField<Integer> CONTAINER_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("containerPort").getter(ContainerServiceEndpoint.getter(ContainerServiceEndpoint::containerPort)).setter(ContainerServiceEndpoint.setter(Builder::containerPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerPort").build()}).build();
    private static final SdkField<ContainerServiceHealthCheckConfig> HEALTH_CHECK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("healthCheck").getter(ContainerServiceEndpoint.getter(ContainerServiceEndpoint::healthCheck)).setter(ContainerServiceEndpoint.setter(Builder::healthCheck)).constructor(ContainerServiceHealthCheckConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthCheck").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_NAME_FIELD, CONTAINER_PORT_FIELD, HEALTH_CHECK_FIELD));
    private static final long serialVersionUID = 1L;
    private final String containerName;
    private final Integer containerPort;
    private final ContainerServiceHealthCheckConfig healthCheck;

    private ContainerServiceEndpoint(BuilderImpl builder) {
        this.containerName = builder.containerName;
        this.containerPort = builder.containerPort;
        this.healthCheck = builder.healthCheck;
    }

    public final String containerName() {
        return this.containerName;
    }

    public final Integer containerPort() {
        return this.containerPort;
    }

    public final ContainerServiceHealthCheckConfig healthCheck() {
        return this.healthCheck;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.containerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheck());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerServiceEndpoint)) {
            return false;
        }
        ContainerServiceEndpoint other = (ContainerServiceEndpoint)obj;
        return Objects.equals(this.containerName(), other.containerName()) && Objects.equals(this.containerPort(), other.containerPort()) && Objects.equals(this.healthCheck(), other.healthCheck());
    }

    public final String toString() {
        return ToString.builder((String)"ContainerServiceEndpoint").add("ContainerName", (Object)this.containerName()).add("ContainerPort", (Object)this.containerPort()).add("HealthCheck", (Object)this.healthCheck()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "containerName": {
                return Optional.ofNullable(clazz.cast(this.containerName()));
            }
            case "containerPort": {
                return Optional.ofNullable(clazz.cast(this.containerPort()));
            }
            case "healthCheck": {
                return Optional.ofNullable(clazz.cast(this.healthCheck()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainerServiceEndpoint, T> g) {
        return obj -> g.apply((ContainerServiceEndpoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String containerName;
        private Integer containerPort;
        private ContainerServiceHealthCheckConfig healthCheck;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerServiceEndpoint model) {
            this.containerName(model.containerName);
            this.containerPort(model.containerPort);
            this.healthCheck(model.healthCheck);
        }

        public final String getContainerName() {
            return this.containerName;
        }

        public final void setContainerName(String containerName) {
            this.containerName = containerName;
        }

        @Override
        public final Builder containerName(String containerName) {
            this.containerName = containerName;
            return this;
        }

        public final Integer getContainerPort() {
            return this.containerPort;
        }

        public final void setContainerPort(Integer containerPort) {
            this.containerPort = containerPort;
        }

        @Override
        public final Builder containerPort(Integer containerPort) {
            this.containerPort = containerPort;
            return this;
        }

        public final ContainerServiceHealthCheckConfig.Builder getHealthCheck() {
            return this.healthCheck != null ? this.healthCheck.toBuilder() : null;
        }

        public final void setHealthCheck(ContainerServiceHealthCheckConfig.BuilderImpl healthCheck) {
            this.healthCheck = healthCheck != null ? healthCheck.build() : null;
        }

        @Override
        public final Builder healthCheck(ContainerServiceHealthCheckConfig healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        public ContainerServiceEndpoint build() {
            return new ContainerServiceEndpoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContainerServiceEndpoint> {
        public Builder containerName(String var1);

        public Builder containerPort(Integer var1);

        public Builder healthCheck(ContainerServiceHealthCheckConfig var1);

        default public Builder healthCheck(Consumer<ContainerServiceHealthCheckConfig.Builder> healthCheck) {
            return this.healthCheck((ContainerServiceHealthCheckConfig)((ContainerServiceHealthCheckConfig.Builder)ContainerServiceHealthCheckConfig.builder().applyMutation(healthCheck)).build());
        }
    }
}

