/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BehaviorEnum {
    DONT_CACHE("dont-cache"),
    CACHE("cache"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BehaviorEnum> VALUE_MAP;
    private final String value;

    private BehaviorEnum(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BehaviorEnum fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BehaviorEnum> knownValues() {
        EnumSet<BehaviorEnum> knownValues = EnumSet.allOf(BehaviorEnum.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BehaviorEnum.class, BehaviorEnum::toString);
    }
}

