/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AlarmState {
    OK("OK"),
    ALARM("ALARM"),
    INSUFFICIENT_DATA("INSUFFICIENT_DATA"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AlarmState> VALUE_MAP;
    private final String value;

    private AlarmState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AlarmState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AlarmState> knownValues() {
        EnumSet<AlarmState> knownValues = EnumSet.allOf(AlarmState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AlarmState.class, AlarmState::toString);
    }
}

