/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.AddOnType;
import software.amazon.awssdk.services.lightsail.model.AutoSnapshotAddOnRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddOnRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AddOnRequest> {
    private static final SdkField<String> ADD_ON_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("addOnType").getter(AddOnRequest.getter(AddOnRequest::addOnTypeAsString)).setter(AddOnRequest.setter(Builder::addOnType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addOnType").build()}).build();
    private static final SdkField<AutoSnapshotAddOnRequest> AUTO_SNAPSHOT_ADD_ON_REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("autoSnapshotAddOnRequest").getter(AddOnRequest.getter(AddOnRequest::autoSnapshotAddOnRequest)).setter(AddOnRequest.setter(Builder::autoSnapshotAddOnRequest)).constructor(AutoSnapshotAddOnRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoSnapshotAddOnRequest").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADD_ON_TYPE_FIELD, AUTO_SNAPSHOT_ADD_ON_REQUEST_FIELD));
    private static final long serialVersionUID = 1L;
    private final String addOnType;
    private final AutoSnapshotAddOnRequest autoSnapshotAddOnRequest;

    private AddOnRequest(BuilderImpl builder) {
        this.addOnType = builder.addOnType;
        this.autoSnapshotAddOnRequest = builder.autoSnapshotAddOnRequest;
    }

    public final AddOnType addOnType() {
        return AddOnType.fromValue(this.addOnType);
    }

    public final String addOnTypeAsString() {
        return this.addOnType;
    }

    public final AutoSnapshotAddOnRequest autoSnapshotAddOnRequest() {
        return this.autoSnapshotAddOnRequest;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.addOnTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoSnapshotAddOnRequest());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddOnRequest)) {
            return false;
        }
        AddOnRequest other = (AddOnRequest)obj;
        return Objects.equals(this.addOnTypeAsString(), other.addOnTypeAsString()) && Objects.equals(this.autoSnapshotAddOnRequest(), other.autoSnapshotAddOnRequest());
    }

    public final String toString() {
        return ToString.builder((String)"AddOnRequest").add("AddOnType", (Object)this.addOnTypeAsString()).add("AutoSnapshotAddOnRequest", (Object)this.autoSnapshotAddOnRequest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "addOnType": {
                return Optional.ofNullable(clazz.cast(this.addOnTypeAsString()));
            }
            case "autoSnapshotAddOnRequest": {
                return Optional.ofNullable(clazz.cast(this.autoSnapshotAddOnRequest()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddOnRequest, T> g) {
        return obj -> g.apply((AddOnRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String addOnType;
        private AutoSnapshotAddOnRequest autoSnapshotAddOnRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(AddOnRequest model) {
            this.addOnType(model.addOnType);
            this.autoSnapshotAddOnRequest(model.autoSnapshotAddOnRequest);
        }

        public final String getAddOnType() {
            return this.addOnType;
        }

        @Override
        public final Builder addOnType(String addOnType) {
            this.addOnType = addOnType;
            return this;
        }

        @Override
        public final Builder addOnType(AddOnType addOnType) {
            this.addOnType(addOnType == null ? null : addOnType.toString());
            return this;
        }

        public final void setAddOnType(String addOnType) {
            this.addOnType = addOnType;
        }

        public final AutoSnapshotAddOnRequest.Builder getAutoSnapshotAddOnRequest() {
            return this.autoSnapshotAddOnRequest != null ? this.autoSnapshotAddOnRequest.toBuilder() : null;
        }

        @Override
        public final Builder autoSnapshotAddOnRequest(AutoSnapshotAddOnRequest autoSnapshotAddOnRequest) {
            this.autoSnapshotAddOnRequest = autoSnapshotAddOnRequest;
            return this;
        }

        public final void setAutoSnapshotAddOnRequest(AutoSnapshotAddOnRequest.BuilderImpl autoSnapshotAddOnRequest) {
            this.autoSnapshotAddOnRequest = autoSnapshotAddOnRequest != null ? autoSnapshotAddOnRequest.build() : null;
        }

        public AddOnRequest build() {
            return new AddOnRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AddOnRequest> {
        public Builder addOnType(String var1);

        public Builder addOnType(AddOnType var1);

        public Builder autoSnapshotAddOnRequest(AutoSnapshotAddOnRequest var1);

        default public Builder autoSnapshotAddOnRequest(Consumer<AutoSnapshotAddOnRequest.Builder> autoSnapshotAddOnRequest) {
            return this.autoSnapshotAddOnRequest((AutoSnapshotAddOnRequest)((AutoSnapshotAddOnRequest.Builder)AutoSnapshotAddOnRequest.builder().applyMutation(autoSnapshotAddOnRequest)).build());
        }
    }
}

