/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lightsail.model.ContainerServiceDeployment;
import software.amazon.awssdk.services.lightsail.model.ContainerServicePowerName;
import software.amazon.awssdk.services.lightsail.model.ContainerServicePublicDomainsCopier;
import software.amazon.awssdk.services.lightsail.model.ContainerServiceState;
import software.amazon.awssdk.services.lightsail.model.ResourceLocation;
import software.amazon.awssdk.services.lightsail.model.ResourceType;
import software.amazon.awssdk.services.lightsail.model.Tag;
import software.amazon.awssdk.services.lightsail.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContainerService
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContainerService> {
    private static final SdkField<String> CONTAINER_SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("containerServiceName").getter(ContainerService.getter(ContainerService::containerServiceName)).setter(ContainerService.setter(Builder::containerServiceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerServiceName").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ContainerService.getter(ContainerService::arn)).setter(ContainerService.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(ContainerService.getter(ContainerService::createdAt)).setter(ContainerService.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<ResourceLocation> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("location").getter(ContainerService.getter(ContainerService::location)).setter(ContainerService.setter(Builder::location)).constructor(ResourceLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(ContainerService.getter(ContainerService::resourceTypeAsString)).setter(ContainerService.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(ContainerService.getter(ContainerService::tags)).setter(ContainerService.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> POWER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("power").getter(ContainerService.getter(ContainerService::powerAsString)).setter(ContainerService.setter(Builder::power)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("power").build()}).build();
    private static final SdkField<String> POWER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("powerId").getter(ContainerService.getter(ContainerService::powerId)).setter(ContainerService.setter(Builder::powerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("powerId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(ContainerService.getter(ContainerService::stateAsString)).setter(ContainerService.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<Integer> SCALE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("scale").getter(ContainerService.getter(ContainerService::scale)).setter(ContainerService.setter(Builder::scale)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scale").build()}).build();
    private static final SdkField<ContainerServiceDeployment> CURRENT_DEPLOYMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("currentDeployment").getter(ContainerService.getter(ContainerService::currentDeployment)).setter(ContainerService.setter(Builder::currentDeployment)).constructor(ContainerServiceDeployment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentDeployment").build()}).build();
    private static final SdkField<ContainerServiceDeployment> NEXT_DEPLOYMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("nextDeployment").getter(ContainerService.getter(ContainerService::nextDeployment)).setter(ContainerService.setter(Builder::nextDeployment)).constructor(ContainerServiceDeployment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextDeployment").build()}).build();
    private static final SdkField<Boolean> IS_DISABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isDisabled").getter(ContainerService.getter(ContainerService::isDisabled)).setter(ContainerService.setter(Builder::isDisabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isDisabled").build()}).build();
    private static final SdkField<String> PRINCIPAL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("principalArn").getter(ContainerService.getter(ContainerService::principalArn)).setter(ContainerService.setter(Builder::principalArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalArn").build()}).build();
    private static final SdkField<String> PRIVATE_DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("privateDomainName").getter(ContainerService.getter(ContainerService::privateDomainName)).setter(ContainerService.setter(Builder::privateDomainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privateDomainName").build()}).build();
    private static final SdkField<Map<String, List<String>>> PUBLIC_DOMAIN_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("publicDomainNames").getter(ContainerService.getter(ContainerService::publicDomainNames)).setter(ContainerService.setter(Builder::publicDomainNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicDomainNames").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("url").getter(ContainerService.getter(ContainerService::url)).setter(ContainerService.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_SERVICE_NAME_FIELD, ARN_FIELD, CREATED_AT_FIELD, LOCATION_FIELD, RESOURCE_TYPE_FIELD, TAGS_FIELD, POWER_FIELD, POWER_ID_FIELD, STATE_FIELD, SCALE_FIELD, CURRENT_DEPLOYMENT_FIELD, NEXT_DEPLOYMENT_FIELD, IS_DISABLED_FIELD, PRINCIPAL_ARN_FIELD, PRIVATE_DOMAIN_NAME_FIELD, PUBLIC_DOMAIN_NAMES_FIELD, URL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String containerServiceName;
    private final String arn;
    private final Instant createdAt;
    private final ResourceLocation location;
    private final String resourceType;
    private final List<Tag> tags;
    private final String power;
    private final String powerId;
    private final String state;
    private final Integer scale;
    private final ContainerServiceDeployment currentDeployment;
    private final ContainerServiceDeployment nextDeployment;
    private final Boolean isDisabled;
    private final String principalArn;
    private final String privateDomainName;
    private final Map<String, List<String>> publicDomainNames;
    private final String url;

    private ContainerService(BuilderImpl builder) {
        this.containerServiceName = builder.containerServiceName;
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.location = builder.location;
        this.resourceType = builder.resourceType;
        this.tags = builder.tags;
        this.power = builder.power;
        this.powerId = builder.powerId;
        this.state = builder.state;
        this.scale = builder.scale;
        this.currentDeployment = builder.currentDeployment;
        this.nextDeployment = builder.nextDeployment;
        this.isDisabled = builder.isDisabled;
        this.principalArn = builder.principalArn;
        this.privateDomainName = builder.privateDomainName;
        this.publicDomainNames = builder.publicDomainNames;
        this.url = builder.url;
    }

    public final String containerServiceName() {
        return this.containerServiceName;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final ResourceLocation location() {
        return this.location;
    }

    public final ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final ContainerServicePowerName power() {
        return ContainerServicePowerName.fromValue(this.power);
    }

    public final String powerAsString() {
        return this.power;
    }

    public final String powerId() {
        return this.powerId;
    }

    public final ContainerServiceState state() {
        return ContainerServiceState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Integer scale() {
        return this.scale;
    }

    public final ContainerServiceDeployment currentDeployment() {
        return this.currentDeployment;
    }

    public final ContainerServiceDeployment nextDeployment() {
        return this.nextDeployment;
    }

    public final Boolean isDisabled() {
        return this.isDisabled;
    }

    public final String principalArn() {
        return this.principalArn;
    }

    public final String privateDomainName() {
        return this.privateDomainName;
    }

    public final boolean hasPublicDomainNames() {
        return this.publicDomainNames != null && !(this.publicDomainNames instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> publicDomainNames() {
        return this.publicDomainNames;
    }

    public final String url() {
        return this.url;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.containerServiceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.powerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.powerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scale());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentDeployment());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextDeployment());
        hashCode = 31 * hashCode + Objects.hashCode(this.isDisabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateDomainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPublicDomainNames() ? this.publicDomainNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerService)) {
            return false;
        }
        ContainerService other = (ContainerService)obj;
        return Objects.equals(this.containerServiceName(), other.containerServiceName()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.powerAsString(), other.powerAsString()) && Objects.equals(this.powerId(), other.powerId()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.scale(), other.scale()) && Objects.equals(this.currentDeployment(), other.currentDeployment()) && Objects.equals(this.nextDeployment(), other.nextDeployment()) && Objects.equals(this.isDisabled(), other.isDisabled()) && Objects.equals(this.principalArn(), other.principalArn()) && Objects.equals(this.privateDomainName(), other.privateDomainName()) && this.hasPublicDomainNames() == other.hasPublicDomainNames() && Objects.equals(this.publicDomainNames(), other.publicDomainNames()) && Objects.equals(this.url(), other.url());
    }

    public final String toString() {
        return ToString.builder((String)"ContainerService").add("ContainerServiceName", (Object)this.containerServiceName()).add("Arn", (Object)this.arn()).add("CreatedAt", (Object)this.createdAt()).add("Location", (Object)this.location()).add("ResourceType", (Object)this.resourceTypeAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("Power", (Object)this.powerAsString()).add("PowerId", (Object)this.powerId()).add("State", (Object)this.stateAsString()).add("Scale", (Object)this.scale()).add("CurrentDeployment", (Object)this.currentDeployment()).add("NextDeployment", (Object)this.nextDeployment()).add("IsDisabled", (Object)this.isDisabled()).add("PrincipalArn", (Object)this.principalArn()).add("PrivateDomainName", (Object)this.privateDomainName()).add("PublicDomainNames", this.hasPublicDomainNames() ? this.publicDomainNames() : null).add("Url", (Object)this.url()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "containerServiceName": {
                return Optional.ofNullable(clazz.cast(this.containerServiceName()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "power": {
                return Optional.ofNullable(clazz.cast(this.powerAsString()));
            }
            case "powerId": {
                return Optional.ofNullable(clazz.cast(this.powerId()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "scale": {
                return Optional.ofNullable(clazz.cast(this.scale()));
            }
            case "currentDeployment": {
                return Optional.ofNullable(clazz.cast(this.currentDeployment()));
            }
            case "nextDeployment": {
                return Optional.ofNullable(clazz.cast(this.nextDeployment()));
            }
            case "isDisabled": {
                return Optional.ofNullable(clazz.cast(this.isDisabled()));
            }
            case "principalArn": {
                return Optional.ofNullable(clazz.cast(this.principalArn()));
            }
            case "privateDomainName": {
                return Optional.ofNullable(clazz.cast(this.privateDomainName()));
            }
            case "publicDomainNames": {
                return Optional.ofNullable(clazz.cast(this.publicDomainNames()));
            }
            case "url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainerService, T> g) {
        return obj -> g.apply((ContainerService)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String containerServiceName;
        private String arn;
        private Instant createdAt;
        private ResourceLocation location;
        private String resourceType;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String power;
        private String powerId;
        private String state;
        private Integer scale;
        private ContainerServiceDeployment currentDeployment;
        private ContainerServiceDeployment nextDeployment;
        private Boolean isDisabled;
        private String principalArn;
        private String privateDomainName;
        private Map<String, List<String>> publicDomainNames = DefaultSdkAutoConstructMap.getInstance();
        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerService model) {
            this.containerServiceName(model.containerServiceName);
            this.arn(model.arn);
            this.createdAt(model.createdAt);
            this.location(model.location);
            this.resourceType(model.resourceType);
            this.tags(model.tags);
            this.power(model.power);
            this.powerId(model.powerId);
            this.state(model.state);
            this.scale(model.scale);
            this.currentDeployment(model.currentDeployment);
            this.nextDeployment(model.nextDeployment);
            this.isDisabled(model.isDisabled);
            this.principalArn(model.principalArn);
            this.privateDomainName(model.privateDomainName);
            this.publicDomainNames(model.publicDomainNames);
            this.url(model.url);
        }

        public final String getContainerServiceName() {
            return this.containerServiceName;
        }

        @Override
        public final Builder containerServiceName(String containerServiceName) {
            this.containerServiceName = containerServiceName;
            return this;
        }

        public final void setContainerServiceName(String containerServiceName) {
            this.containerServiceName = containerServiceName;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final ResourceLocation.Builder getLocation() {
            return this.location != null ? this.location.toBuilder() : null;
        }

        @Override
        public final Builder location(ResourceLocation location) {
            this.location = location;
            return this;
        }

        public final void setLocation(ResourceLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getPower() {
            return this.power;
        }

        @Override
        public final Builder power(String power) {
            this.power = power;
            return this;
        }

        @Override
        public final Builder power(ContainerServicePowerName power) {
            this.power(power == null ? null : power.toString());
            return this;
        }

        public final void setPower(String power) {
            this.power = power;
        }

        public final String getPowerId() {
            return this.powerId;
        }

        @Override
        public final Builder powerId(String powerId) {
            this.powerId = powerId;
            return this;
        }

        public final void setPowerId(String powerId) {
            this.powerId = powerId;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ContainerServiceState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Integer getScale() {
            return this.scale;
        }

        @Override
        public final Builder scale(Integer scale) {
            this.scale = scale;
            return this;
        }

        public final void setScale(Integer scale) {
            this.scale = scale;
        }

        public final ContainerServiceDeployment.Builder getCurrentDeployment() {
            return this.currentDeployment != null ? this.currentDeployment.toBuilder() : null;
        }

        @Override
        public final Builder currentDeployment(ContainerServiceDeployment currentDeployment) {
            this.currentDeployment = currentDeployment;
            return this;
        }

        public final void setCurrentDeployment(ContainerServiceDeployment.BuilderImpl currentDeployment) {
            this.currentDeployment = currentDeployment != null ? currentDeployment.build() : null;
        }

        public final ContainerServiceDeployment.Builder getNextDeployment() {
            return this.nextDeployment != null ? this.nextDeployment.toBuilder() : null;
        }

        @Override
        public final Builder nextDeployment(ContainerServiceDeployment nextDeployment) {
            this.nextDeployment = nextDeployment;
            return this;
        }

        public final void setNextDeployment(ContainerServiceDeployment.BuilderImpl nextDeployment) {
            this.nextDeployment = nextDeployment != null ? nextDeployment.build() : null;
        }

        public final Boolean getIsDisabled() {
            return this.isDisabled;
        }

        @Override
        public final Builder isDisabled(Boolean isDisabled) {
            this.isDisabled = isDisabled;
            return this;
        }

        public final void setIsDisabled(Boolean isDisabled) {
            this.isDisabled = isDisabled;
        }

        public final String getPrincipalArn() {
            return this.principalArn;
        }

        @Override
        public final Builder principalArn(String principalArn) {
            this.principalArn = principalArn;
            return this;
        }

        public final void setPrincipalArn(String principalArn) {
            this.principalArn = principalArn;
        }

        public final String getPrivateDomainName() {
            return this.privateDomainName;
        }

        @Override
        public final Builder privateDomainName(String privateDomainName) {
            this.privateDomainName = privateDomainName;
            return this;
        }

        public final void setPrivateDomainName(String privateDomainName) {
            this.privateDomainName = privateDomainName;
        }

        public final Map<String, ? extends Collection<String>> getPublicDomainNames() {
            if (this.publicDomainNames instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.publicDomainNames;
        }

        @Override
        public final Builder publicDomainNames(Map<String, ? extends Collection<String>> publicDomainNames) {
            this.publicDomainNames = ContainerServicePublicDomainsCopier.copy(publicDomainNames);
            return this;
        }

        public final void setPublicDomainNames(Map<String, ? extends Collection<String>> publicDomainNames) {
            this.publicDomainNames = ContainerServicePublicDomainsCopier.copy(publicDomainNames);
        }

        public final String getUrl() {
            return this.url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public ContainerService build() {
            return new ContainerService(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContainerService> {
        public Builder containerServiceName(String var1);

        public Builder arn(String var1);

        public Builder createdAt(Instant var1);

        public Builder location(ResourceLocation var1);

        default public Builder location(Consumer<ResourceLocation.Builder> location) {
            return this.location((ResourceLocation)((ResourceLocation.Builder)ResourceLocation.builder().applyMutation(location)).build());
        }

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder power(String var1);

        public Builder power(ContainerServicePowerName var1);

        public Builder powerId(String var1);

        public Builder state(String var1);

        public Builder state(ContainerServiceState var1);

        public Builder scale(Integer var1);

        public Builder currentDeployment(ContainerServiceDeployment var1);

        default public Builder currentDeployment(Consumer<ContainerServiceDeployment.Builder> currentDeployment) {
            return this.currentDeployment((ContainerServiceDeployment)((ContainerServiceDeployment.Builder)ContainerServiceDeployment.builder().applyMutation(currentDeployment)).build());
        }

        public Builder nextDeployment(ContainerServiceDeployment var1);

        default public Builder nextDeployment(Consumer<ContainerServiceDeployment.Builder> nextDeployment) {
            return this.nextDeployment((ContainerServiceDeployment)((ContainerServiceDeployment.Builder)ContainerServiceDeployment.builder().applyMutation(nextDeployment)).build());
        }

        public Builder isDisabled(Boolean var1);

        public Builder principalArn(String var1);

        public Builder privateDomainName(String var1);

        public Builder publicDomainNames(Map<String, ? extends Collection<String>> var1);

        public Builder url(String var1);
    }
}

