/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the status of a SSL/TLS certificate renewal managed by Amazon Lightsail.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RenewalSummary implements SdkPojo, Serializable, ToCopyableBuilder<RenewalSummary.Builder, RenewalSummary> {
    private static final SdkField<List<DomainValidationRecord>> DOMAIN_VALIDATION_RECORDS_FIELD = SdkField
            .<List<DomainValidationRecord>> builder(MarshallingType.LIST)
            .memberName("domainValidationRecords")
            .getter(getter(RenewalSummary::domainValidationRecords))
            .setter(setter(Builder::domainValidationRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainValidationRecords").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DomainValidationRecord> builder(MarshallingType.SDK_POJO)
                                            .constructor(DomainValidationRecord::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RENEWAL_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("renewalStatus").getter(getter(RenewalSummary::renewalStatusAsString))
            .setter(setter(Builder::renewalStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("renewalStatus").build()).build();

    private static final SdkField<String> RENEWAL_STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("renewalStatusReason").getter(getter(RenewalSummary::renewalStatusReason))
            .setter(setter(Builder::renewalStatusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("renewalStatusReason").build())
            .build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(RenewalSummary::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DOMAIN_VALIDATION_RECORDS_FIELD, RENEWAL_STATUS_FIELD, RENEWAL_STATUS_REASON_FIELD, UPDATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<DomainValidationRecord> domainValidationRecords;

    private final String renewalStatus;

    private final String renewalStatusReason;

    private final Instant updatedAt;

    private RenewalSummary(BuilderImpl builder) {
        this.domainValidationRecords = builder.domainValidationRecords;
        this.renewalStatus = builder.renewalStatus;
        this.renewalStatusReason = builder.renewalStatusReason;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * Returns true if the DomainValidationRecords property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasDomainValidationRecords() {
        return domainValidationRecords != null && !(domainValidationRecords instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that describe the domain validation records of the certificate.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDomainValidationRecords()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects that describe the domain validation records of the certificate.
     */
    public final List<DomainValidationRecord> domainValidationRecords() {
        return domainValidationRecords;
    }

    /**
     * <p>
     * The renewal status of the certificate.
     * </p>
     * <p>
     * The following renewal status are possible:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>PendingAutoRenewal</code> </b> - Lightsail is attempting to automatically validate the domain names of
     * the certificate. No further action is required.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>PendingValidation</code> </b> - Lightsail couldn't automatically validate one or more domain names of
     * the certificate. You must take action to validate these domain names or the certificate won't be renewed. Check
     * to make sure your certificate's domain validation records exist in your domain's DNS, and that your certificate
     * remains in use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>Success</code> </b> - All domain names in the certificate are validated, and Lightsail renewed the
     * certificate. No further action is required.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>Failed</code> </b> - One or more domain names were not validated before the certificate expired, and
     * Lightsail did not renew the certificate. You can request a new certificate using the
     * <code>CreateCertificate</code> action.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #renewalStatus}
     * will return {@link RenewalStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #renewalStatusAsString}.
     * </p>
     * 
     * @return The renewal status of the certificate.</p>
     *         <p>
     *         The following renewal status are possible:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b> <code>PendingAutoRenewal</code> </b> - Lightsail is attempting to automatically validate the domain
     *         names of the certificate. No further action is required.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>PendingValidation</code> </b> - Lightsail couldn't automatically validate one or more domain
     *         names of the certificate. You must take action to validate these domain names or the certificate won't be
     *         renewed. Check to make sure your certificate's domain validation records exist in your domain's DNS, and
     *         that your certificate remains in use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>Success</code> </b> - All domain names in the certificate are validated, and Lightsail renewed
     *         the certificate. No further action is required.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>Failed</code> </b> - One or more domain names were not validated before the certificate
     *         expired, and Lightsail did not renew the certificate. You can request a new certificate using the
     *         <code>CreateCertificate</code> action.
     *         </p>
     *         </li>
     * @see RenewalStatus
     */
    public final RenewalStatus renewalStatus() {
        return RenewalStatus.fromValue(renewalStatus);
    }

    /**
     * <p>
     * The renewal status of the certificate.
     * </p>
     * <p>
     * The following renewal status are possible:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>PendingAutoRenewal</code> </b> - Lightsail is attempting to automatically validate the domain names of
     * the certificate. No further action is required.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>PendingValidation</code> </b> - Lightsail couldn't automatically validate one or more domain names of
     * the certificate. You must take action to validate these domain names or the certificate won't be renewed. Check
     * to make sure your certificate's domain validation records exist in your domain's DNS, and that your certificate
     * remains in use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>Success</code> </b> - All domain names in the certificate are validated, and Lightsail renewed the
     * certificate. No further action is required.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>Failed</code> </b> - One or more domain names were not validated before the certificate expired, and
     * Lightsail did not renew the certificate. You can request a new certificate using the
     * <code>CreateCertificate</code> action.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #renewalStatus}
     * will return {@link RenewalStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #renewalStatusAsString}.
     * </p>
     * 
     * @return The renewal status of the certificate.</p>
     *         <p>
     *         The following renewal status are possible:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b> <code>PendingAutoRenewal</code> </b> - Lightsail is attempting to automatically validate the domain
     *         names of the certificate. No further action is required.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>PendingValidation</code> </b> - Lightsail couldn't automatically validate one or more domain
     *         names of the certificate. You must take action to validate these domain names or the certificate won't be
     *         renewed. Check to make sure your certificate's domain validation records exist in your domain's DNS, and
     *         that your certificate remains in use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>Success</code> </b> - All domain names in the certificate are validated, and Lightsail renewed
     *         the certificate. No further action is required.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>Failed</code> </b> - One or more domain names were not validated before the certificate
     *         expired, and Lightsail did not renew the certificate. You can request a new certificate using the
     *         <code>CreateCertificate</code> action.
     *         </p>
     *         </li>
     * @see RenewalStatus
     */
    public final String renewalStatusAsString() {
        return renewalStatus;
    }

    /**
     * <p>
     * The reason for the renewal status of the certificate.
     * </p>
     * 
     * @return The reason for the renewal status of the certificate.
     */
    public final String renewalStatusReason() {
        return renewalStatusReason;
    }

    /**
     * <p>
     * The timestamp when the certificate was last updated.
     * </p>
     * 
     * @return The timestamp when the certificate was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDomainValidationRecords() ? domainValidationRecords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(renewalStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(renewalStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RenewalSummary)) {
            return false;
        }
        RenewalSummary other = (RenewalSummary) obj;
        return hasDomainValidationRecords() == other.hasDomainValidationRecords()
                && Objects.equals(domainValidationRecords(), other.domainValidationRecords())
                && Objects.equals(renewalStatusAsString(), other.renewalStatusAsString())
                && Objects.equals(renewalStatusReason(), other.renewalStatusReason())
                && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RenewalSummary")
                .add("DomainValidationRecords", hasDomainValidationRecords() ? domainValidationRecords() : null)
                .add("RenewalStatus", renewalStatusAsString()).add("RenewalStatusReason", renewalStatusReason())
                .add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainValidationRecords":
            return Optional.ofNullable(clazz.cast(domainValidationRecords()));
        case "renewalStatus":
            return Optional.ofNullable(clazz.cast(renewalStatusAsString()));
        case "renewalStatusReason":
            return Optional.ofNullable(clazz.cast(renewalStatusReason()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RenewalSummary, T> g) {
        return obj -> g.apply((RenewalSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RenewalSummary> {
        /**
         * <p>
         * An array of objects that describe the domain validation records of the certificate.
         * </p>
         * 
         * @param domainValidationRecords
         *        An array of objects that describe the domain validation records of the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainValidationRecords(Collection<DomainValidationRecord> domainValidationRecords);

        /**
         * <p>
         * An array of objects that describe the domain validation records of the certificate.
         * </p>
         * 
         * @param domainValidationRecords
         *        An array of objects that describe the domain validation records of the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainValidationRecords(DomainValidationRecord... domainValidationRecords);

        /**
         * <p>
         * An array of objects that describe the domain validation records of the certificate.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DomainValidationRecord>.Builder} avoiding
         * the need to create one manually via {@link List<DomainValidationRecord>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DomainValidationRecord>.Builder#build()} is called
         * immediately and its result is passed to {@link #domainValidationRecords(List<DomainValidationRecord>)}.
         * 
         * @param domainValidationRecords
         *        a consumer that will call methods on {@link List<DomainValidationRecord>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainValidationRecords(List<DomainValidationRecord>)
         */
        Builder domainValidationRecords(Consumer<DomainValidationRecord.Builder>... domainValidationRecords);

        /**
         * <p>
         * The renewal status of the certificate.
         * </p>
         * <p>
         * The following renewal status are possible:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b> <code>PendingAutoRenewal</code> </b> - Lightsail is attempting to automatically validate the domain names
         * of the certificate. No further action is required.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>PendingValidation</code> </b> - Lightsail couldn't automatically validate one or more domain names
         * of the certificate. You must take action to validate these domain names or the certificate won't be renewed.
         * Check to make sure your certificate's domain validation records exist in your domain's DNS, and that your
         * certificate remains in use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>Success</code> </b> - All domain names in the certificate are validated, and Lightsail renewed the
         * certificate. No further action is required.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>Failed</code> </b> - One or more domain names were not validated before the certificate expired,
         * and Lightsail did not renew the certificate. You can request a new certificate using the
         * <code>CreateCertificate</code> action.
         * </p>
         * </li>
         * </ul>
         * 
         * @param renewalStatus
         *        The renewal status of the certificate.</p>
         *        <p>
         *        The following renewal status are possible:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b> <code>PendingAutoRenewal</code> </b> - Lightsail is attempting to automatically validate the
         *        domain names of the certificate. No further action is required.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>PendingValidation</code> </b> - Lightsail couldn't automatically validate one or more domain
         *        names of the certificate. You must take action to validate these domain names or the certificate won't
         *        be renewed. Check to make sure your certificate's domain validation records exist in your domain's
         *        DNS, and that your certificate remains in use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>Success</code> </b> - All domain names in the certificate are validated, and Lightsail
         *        renewed the certificate. No further action is required.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>Failed</code> </b> - One or more domain names were not validated before the certificate
         *        expired, and Lightsail did not renew the certificate. You can request a new certificate using the
         *        <code>CreateCertificate</code> action.
         *        </p>
         *        </li>
         * @see RenewalStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RenewalStatus
         */
        Builder renewalStatus(String renewalStatus);

        /**
         * <p>
         * The renewal status of the certificate.
         * </p>
         * <p>
         * The following renewal status are possible:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b> <code>PendingAutoRenewal</code> </b> - Lightsail is attempting to automatically validate the domain names
         * of the certificate. No further action is required.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>PendingValidation</code> </b> - Lightsail couldn't automatically validate one or more domain names
         * of the certificate. You must take action to validate these domain names or the certificate won't be renewed.
         * Check to make sure your certificate's domain validation records exist in your domain's DNS, and that your
         * certificate remains in use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>Success</code> </b> - All domain names in the certificate are validated, and Lightsail renewed the
         * certificate. No further action is required.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>Failed</code> </b> - One or more domain names were not validated before the certificate expired,
         * and Lightsail did not renew the certificate. You can request a new certificate using the
         * <code>CreateCertificate</code> action.
         * </p>
         * </li>
         * </ul>
         * 
         * @param renewalStatus
         *        The renewal status of the certificate.</p>
         *        <p>
         *        The following renewal status are possible:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b> <code>PendingAutoRenewal</code> </b> - Lightsail is attempting to automatically validate the
         *        domain names of the certificate. No further action is required.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>PendingValidation</code> </b> - Lightsail couldn't automatically validate one or more domain
         *        names of the certificate. You must take action to validate these domain names or the certificate won't
         *        be renewed. Check to make sure your certificate's domain validation records exist in your domain's
         *        DNS, and that your certificate remains in use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>Success</code> </b> - All domain names in the certificate are validated, and Lightsail
         *        renewed the certificate. No further action is required.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>Failed</code> </b> - One or more domain names were not validated before the certificate
         *        expired, and Lightsail did not renew the certificate. You can request a new certificate using the
         *        <code>CreateCertificate</code> action.
         *        </p>
         *        </li>
         * @see RenewalStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RenewalStatus
         */
        Builder renewalStatus(RenewalStatus renewalStatus);

        /**
         * <p>
         * The reason for the renewal status of the certificate.
         * </p>
         * 
         * @param renewalStatusReason
         *        The reason for the renewal status of the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder renewalStatusReason(String renewalStatusReason);

        /**
         * <p>
         * The timestamp when the certificate was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp when the certificate was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private List<DomainValidationRecord> domainValidationRecords = DefaultSdkAutoConstructList.getInstance();

        private String renewalStatus;

        private String renewalStatusReason;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(RenewalSummary model) {
            domainValidationRecords(model.domainValidationRecords);
            renewalStatus(model.renewalStatus);
            renewalStatusReason(model.renewalStatusReason);
            updatedAt(model.updatedAt);
        }

        public final Collection<DomainValidationRecord.Builder> getDomainValidationRecords() {
            if (domainValidationRecords instanceof SdkAutoConstructList) {
                return null;
            }
            return domainValidationRecords != null ? domainValidationRecords.stream().map(DomainValidationRecord::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder domainValidationRecords(Collection<DomainValidationRecord> domainValidationRecords) {
            this.domainValidationRecords = DomainValidationRecordListCopier.copy(domainValidationRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainValidationRecords(DomainValidationRecord... domainValidationRecords) {
            domainValidationRecords(Arrays.asList(domainValidationRecords));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainValidationRecords(Consumer<DomainValidationRecord.Builder>... domainValidationRecords) {
            domainValidationRecords(Stream.of(domainValidationRecords)
                    .map(c -> DomainValidationRecord.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDomainValidationRecords(Collection<DomainValidationRecord.BuilderImpl> domainValidationRecords) {
            this.domainValidationRecords = DomainValidationRecordListCopier.copyFromBuilder(domainValidationRecords);
        }

        public final String getRenewalStatus() {
            return renewalStatus;
        }

        @Override
        public final Builder renewalStatus(String renewalStatus) {
            this.renewalStatus = renewalStatus;
            return this;
        }

        @Override
        public final Builder renewalStatus(RenewalStatus renewalStatus) {
            this.renewalStatus(renewalStatus == null ? null : renewalStatus.toString());
            return this;
        }

        public final void setRenewalStatus(String renewalStatus) {
            this.renewalStatus = renewalStatus;
        }

        public final String getRenewalStatusReason() {
            return renewalStatusReason;
        }

        @Override
        public final Builder renewalStatusReason(String renewalStatusReason) {
            this.renewalStatusReason = renewalStatusReason;
            return this;
        }

        public final void setRenewalStatusReason(String renewalStatusReason) {
            this.renewalStatusReason = renewalStatusReason;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public RenewalSummary build() {
            return new RenewalSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
