/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a database image, or blueprint. A blueprint describes the major engine version of a database.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RelationalDatabaseBlueprint implements SdkPojo, Serializable,
        ToCopyableBuilder<RelationalDatabaseBlueprint.Builder, RelationalDatabaseBlueprint> {
    private static final SdkField<String> BLUEPRINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("blueprintId").getter(getter(RelationalDatabaseBlueprint::blueprintId))
            .setter(setter(Builder::blueprintId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprintId").build()).build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("engine")
            .getter(getter(RelationalDatabaseBlueprint::engineAsString)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engine").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("engineVersion").getter(getter(RelationalDatabaseBlueprint::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineVersion").build()).build();

    private static final SdkField<String> ENGINE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("engineDescription").getter(getter(RelationalDatabaseBlueprint::engineDescription))
            .setter(setter(Builder::engineDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineDescription").build()).build();

    private static final SdkField<String> ENGINE_VERSION_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("engineVersionDescription").getter(getter(RelationalDatabaseBlueprint::engineVersionDescription))
            .setter(setter(Builder::engineVersionDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineVersionDescription").build())
            .build();

    private static final SdkField<Boolean> IS_ENGINE_DEFAULT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isEngineDefault").getter(getter(RelationalDatabaseBlueprint::isEngineDefault))
            .setter(setter(Builder::isEngineDefault))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isEngineDefault").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLUEPRINT_ID_FIELD,
            ENGINE_FIELD, ENGINE_VERSION_FIELD, ENGINE_DESCRIPTION_FIELD, ENGINE_VERSION_DESCRIPTION_FIELD,
            IS_ENGINE_DEFAULT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String blueprintId;

    private final String engine;

    private final String engineVersion;

    private final String engineDescription;

    private final String engineVersionDescription;

    private final Boolean isEngineDefault;

    private RelationalDatabaseBlueprint(BuilderImpl builder) {
        this.blueprintId = builder.blueprintId;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.engineDescription = builder.engineDescription;
        this.engineVersionDescription = builder.engineVersionDescription;
        this.isEngineDefault = builder.isEngineDefault;
    }

    /**
     * <p>
     * The ID for the database blueprint.
     * </p>
     * 
     * @return The ID for the database blueprint.
     */
    public final String blueprintId() {
        return blueprintId;
    }

    /**
     * <p>
     * The database software of the database blueprint (for example, <code>MySQL</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engine} will
     * return {@link RelationalDatabaseEngine#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #engineAsString}.
     * </p>
     * 
     * @return The database software of the database blueprint (for example, <code>MySQL</code>).
     * @see RelationalDatabaseEngine
     */
    public final RelationalDatabaseEngine engine() {
        return RelationalDatabaseEngine.fromValue(engine);
    }

    /**
     * <p>
     * The database software of the database blueprint (for example, <code>MySQL</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engine} will
     * return {@link RelationalDatabaseEngine#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #engineAsString}.
     * </p>
     * 
     * @return The database software of the database blueprint (for example, <code>MySQL</code>).
     * @see RelationalDatabaseEngine
     */
    public final String engineAsString() {
        return engine;
    }

    /**
     * <p>
     * The database engine version for the database blueprint (for example, <code>5.7.23</code>).
     * </p>
     * 
     * @return The database engine version for the database blueprint (for example, <code>5.7.23</code>).
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The description of the database engine for the database blueprint.
     * </p>
     * 
     * @return The description of the database engine for the database blueprint.
     */
    public final String engineDescription() {
        return engineDescription;
    }

    /**
     * <p>
     * The description of the database engine version for the database blueprint.
     * </p>
     * 
     * @return The description of the database engine version for the database blueprint.
     */
    public final String engineVersionDescription() {
        return engineVersionDescription;
    }

    /**
     * <p>
     * A Boolean value indicating whether the engine version is the default for the database blueprint.
     * </p>
     * 
     * @return A Boolean value indicating whether the engine version is the default for the database blueprint.
     */
    public final Boolean isEngineDefault() {
        return isEngineDefault;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(blueprintId());
        hashCode = 31 * hashCode + Objects.hashCode(engineAsString());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(engineDescription());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(isEngineDefault());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelationalDatabaseBlueprint)) {
            return false;
        }
        RelationalDatabaseBlueprint other = (RelationalDatabaseBlueprint) obj;
        return Objects.equals(blueprintId(), other.blueprintId()) && Objects.equals(engineAsString(), other.engineAsString())
                && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(engineDescription(), other.engineDescription())
                && Objects.equals(engineVersionDescription(), other.engineVersionDescription())
                && Objects.equals(isEngineDefault(), other.isEngineDefault());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RelationalDatabaseBlueprint").add("BlueprintId", blueprintId()).add("Engine", engineAsString())
                .add("EngineVersion", engineVersion()).add("EngineDescription", engineDescription())
                .add("EngineVersionDescription", engineVersionDescription()).add("IsEngineDefault", isEngineDefault()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "blueprintId":
            return Optional.ofNullable(clazz.cast(blueprintId()));
        case "engine":
            return Optional.ofNullable(clazz.cast(engineAsString()));
        case "engineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "engineDescription":
            return Optional.ofNullable(clazz.cast(engineDescription()));
        case "engineVersionDescription":
            return Optional.ofNullable(clazz.cast(engineVersionDescription()));
        case "isEngineDefault":
            return Optional.ofNullable(clazz.cast(isEngineDefault()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RelationalDatabaseBlueprint, T> g) {
        return obj -> g.apply((RelationalDatabaseBlueprint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RelationalDatabaseBlueprint> {
        /**
         * <p>
         * The ID for the database blueprint.
         * </p>
         * 
         * @param blueprintId
         *        The ID for the database blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprintId(String blueprintId);

        /**
         * <p>
         * The database software of the database blueprint (for example, <code>MySQL</code>).
         * </p>
         * 
         * @param engine
         *        The database software of the database blueprint (for example, <code>MySQL</code>).
         * @see RelationalDatabaseEngine
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RelationalDatabaseEngine
         */
        Builder engine(String engine);

        /**
         * <p>
         * The database software of the database blueprint (for example, <code>MySQL</code>).
         * </p>
         * 
         * @param engine
         *        The database software of the database blueprint (for example, <code>MySQL</code>).
         * @see RelationalDatabaseEngine
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RelationalDatabaseEngine
         */
        Builder engine(RelationalDatabaseEngine engine);

        /**
         * <p>
         * The database engine version for the database blueprint (for example, <code>5.7.23</code>).
         * </p>
         * 
         * @param engineVersion
         *        The database engine version for the database blueprint (for example, <code>5.7.23</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The description of the database engine for the database blueprint.
         * </p>
         * 
         * @param engineDescription
         *        The description of the database engine for the database blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineDescription(String engineDescription);

        /**
         * <p>
         * The description of the database engine version for the database blueprint.
         * </p>
         * 
         * @param engineVersionDescription
         *        The description of the database engine version for the database blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersionDescription(String engineVersionDescription);

        /**
         * <p>
         * A Boolean value indicating whether the engine version is the default for the database blueprint.
         * </p>
         * 
         * @param isEngineDefault
         *        A Boolean value indicating whether the engine version is the default for the database blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isEngineDefault(Boolean isEngineDefault);
    }

    static final class BuilderImpl implements Builder {
        private String blueprintId;

        private String engine;

        private String engineVersion;

        private String engineDescription;

        private String engineVersionDescription;

        private Boolean isEngineDefault;

        private BuilderImpl() {
        }

        private BuilderImpl(RelationalDatabaseBlueprint model) {
            blueprintId(model.blueprintId);
            engine(model.engine);
            engineVersion(model.engineVersion);
            engineDescription(model.engineDescription);
            engineVersionDescription(model.engineVersionDescription);
            isEngineDefault(model.isEngineDefault);
        }

        public final String getBlueprintId() {
            return blueprintId;
        }

        @Override
        public final Builder blueprintId(String blueprintId) {
            this.blueprintId = blueprintId;
            return this;
        }

        public final void setBlueprintId(String blueprintId) {
            this.blueprintId = blueprintId;
        }

        public final String getEngine() {
            return engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        @Override
        public final Builder engine(RelationalDatabaseEngine engine) {
            this.engine(engine == null ? null : engine.toString());
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final String getEngineDescription() {
            return engineDescription;
        }

        @Override
        public final Builder engineDescription(String engineDescription) {
            this.engineDescription = engineDescription;
            return this;
        }

        public final void setEngineDescription(String engineDescription) {
            this.engineDescription = engineDescription;
        }

        public final String getEngineVersionDescription() {
            return engineVersionDescription;
        }

        @Override
        public final Builder engineVersionDescription(String engineVersionDescription) {
            this.engineVersionDescription = engineVersionDescription;
            return this;
        }

        public final void setEngineVersionDescription(String engineVersionDescription) {
            this.engineVersionDescription = engineVersionDescription;
        }

        public final Boolean getIsEngineDefault() {
            return isEngineDefault;
        }

        @Override
        public final Builder isEngineDefault(Boolean isEngineDefault) {
            this.isEngineDefault = isEngineDefault;
            return this;
        }

        public final void setIsEngineDefault(Boolean isEngineDefault) {
            this.isEngineDefault = isEngineDefault;
        }

        @Override
        public RelationalDatabaseBlueprint build() {
            return new RelationalDatabaseBlueprint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
