/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAlarmsResponse extends LightsailResponse implements
        ToCopyableBuilder<GetAlarmsResponse.Builder, GetAlarmsResponse> {
    private static final SdkField<List<Alarm>> ALARMS_FIELD = SdkField
            .<List<Alarm>> builder(MarshallingType.LIST)
            .memberName("alarms")
            .getter(getter(GetAlarmsResponse::alarms))
            .setter(setter(Builder::alarms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Alarm> builder(MarshallingType.SDK_POJO)
                                            .constructor(Alarm::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextPageToken").getter(getter(GetAlarmsResponse::nextPageToken)).setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALARMS_FIELD,
            NEXT_PAGE_TOKEN_FIELD));

    private final List<Alarm> alarms;

    private final String nextPageToken;

    private GetAlarmsResponse(BuilderImpl builder) {
        super(builder);
        this.alarms = builder.alarms;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * Returns true if the Alarms property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAlarms() {
        return alarms != null && !(alarms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that describe the alarms.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAlarms()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects that describe the alarms.
     */
    public final List<Alarm> alarms() {
        return alarms;
    }

    /**
     * <p>
     * The token to advance to the next page of results from your request.
     * </p>
     * <p>
     * A next page token is not returned if there are no more results to display.
     * </p>
     * <p>
     * To get the next page of results, perform another <code>GetAlarms</code> request and specify the next page token
     * using the <code>pageToken</code> parameter.
     * </p>
     * 
     * @return The token to advance to the next page of results from your request.</p>
     *         <p>
     *         A next page token is not returned if there are no more results to display.
     *         </p>
     *         <p>
     *         To get the next page of results, perform another <code>GetAlarms</code> request and specify the next page
     *         token using the <code>pageToken</code> parameter.
     */
    public final String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAlarms() ? alarms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAlarmsResponse)) {
            return false;
        }
        GetAlarmsResponse other = (GetAlarmsResponse) obj;
        return hasAlarms() == other.hasAlarms() && Objects.equals(alarms(), other.alarms())
                && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAlarmsResponse").add("Alarms", hasAlarms() ? alarms() : null)
                .add("NextPageToken", nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "alarms":
            return Optional.ofNullable(clazz.cast(alarms()));
        case "nextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAlarmsResponse, T> g) {
        return obj -> g.apply((GetAlarmsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetAlarmsResponse> {
        /**
         * <p>
         * An array of objects that describe the alarms.
         * </p>
         * 
         * @param alarms
         *        An array of objects that describe the alarms.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarms(Collection<Alarm> alarms);

        /**
         * <p>
         * An array of objects that describe the alarms.
         * </p>
         * 
         * @param alarms
         *        An array of objects that describe the alarms.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarms(Alarm... alarms);

        /**
         * <p>
         * An array of objects that describe the alarms.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Alarm>.Builder} avoiding the need to create
         * one manually via {@link List<Alarm>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Alarm>.Builder#build()} is called immediately and its result
         * is passed to {@link #alarms(List<Alarm>)}.
         * 
         * @param alarms
         *        a consumer that will call methods on {@link List<Alarm>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #alarms(List<Alarm>)
         */
        Builder alarms(Consumer<Alarm.Builder>... alarms);

        /**
         * <p>
         * The token to advance to the next page of results from your request.
         * </p>
         * <p>
         * A next page token is not returned if there are no more results to display.
         * </p>
         * <p>
         * To get the next page of results, perform another <code>GetAlarms</code> request and specify the next page
         * token using the <code>pageToken</code> parameter.
         * </p>
         * 
         * @param nextPageToken
         *        The token to advance to the next page of results from your request.</p>
         *        <p>
         *        A next page token is not returned if there are no more results to display.
         *        </p>
         *        <p>
         *        To get the next page of results, perform another <code>GetAlarms</code> request and specify the next
         *        page token using the <code>pageToken</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private List<Alarm> alarms = DefaultSdkAutoConstructList.getInstance();

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAlarmsResponse model) {
            super(model);
            alarms(model.alarms);
            nextPageToken(model.nextPageToken);
        }

        public final Collection<Alarm.Builder> getAlarms() {
            if (alarms instanceof SdkAutoConstructList) {
                return null;
            }
            return alarms != null ? alarms.stream().map(Alarm::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder alarms(Collection<Alarm> alarms) {
            this.alarms = AlarmsListCopier.copy(alarms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarms(Alarm... alarms) {
            alarms(Arrays.asList(alarms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarms(Consumer<Alarm.Builder>... alarms) {
            alarms(Stream.of(alarms).map(c -> Alarm.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAlarms(Collection<Alarm.BuilderImpl> alarms) {
            this.alarms = AlarmsListCopier.copyFromBuilder(alarms);
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public GetAlarmsResponse build() {
            return new GetAlarmsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
