/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the powers that can be specified for an Amazon Lightsail container service.
 * </p>
 * <p>
 * The power specifies the amount of RAM, the number of vCPUs, and the base price of the container service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContainerServicePower implements SdkPojo, Serializable,
        ToCopyableBuilder<ContainerServicePower.Builder, ContainerServicePower> {
    private static final SdkField<String> POWER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("powerId").getter(getter(ContainerServicePower::powerId)).setter(setter(Builder::powerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("powerId").build()).build();

    private static final SdkField<Float> PRICE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("price")
            .getter(getter(ContainerServicePower::price)).setter(setter(Builder::price))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("price").build()).build();

    private static final SdkField<Float> CPU_COUNT_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("cpuCount")
            .getter(getter(ContainerServicePower::cpuCount)).setter(setter(Builder::cpuCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpuCount").build()).build();

    private static final SdkField<Float> RAM_SIZE_IN_GB_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("ramSizeInGb").getter(getter(ContainerServicePower::ramSizeInGb)).setter(setter(Builder::ramSizeInGb))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ramSizeInGb").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ContainerServicePower::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Boolean> IS_ACTIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isActive").getter(getter(ContainerServicePower::isActive)).setter(setter(Builder::isActive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isActive").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POWER_ID_FIELD, PRICE_FIELD,
            CPU_COUNT_FIELD, RAM_SIZE_IN_GB_FIELD, NAME_FIELD, IS_ACTIVE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String powerId;

    private final Float price;

    private final Float cpuCount;

    private final Float ramSizeInGb;

    private final String name;

    private final Boolean isActive;

    private ContainerServicePower(BuilderImpl builder) {
        this.powerId = builder.powerId;
        this.price = builder.price;
        this.cpuCount = builder.cpuCount;
        this.ramSizeInGb = builder.ramSizeInGb;
        this.name = builder.name;
        this.isActive = builder.isActive;
    }

    /**
     * <p>
     * The ID of the power (e.g., <code>nano-1</code>).
     * </p>
     * 
     * @return The ID of the power (e.g., <code>nano-1</code>).
     */
    public final String powerId() {
        return powerId;
    }

    /**
     * <p>
     * The monthly price of the power in USD.
     * </p>
     * 
     * @return The monthly price of the power in USD.
     */
    public final Float price() {
        return price;
    }

    /**
     * <p>
     * The number of vCPUs included in the power.
     * </p>
     * 
     * @return The number of vCPUs included in the power.
     */
    public final Float cpuCount() {
        return cpuCount;
    }

    /**
     * <p>
     * The amount of RAM (in GB) of the power.
     * </p>
     * 
     * @return The amount of RAM (in GB) of the power.
     */
    public final Float ramSizeInGb() {
        return ramSizeInGb;
    }

    /**
     * <p>
     * The friendly name of the power (e.g., <code>nano</code>).
     * </p>
     * 
     * @return The friendly name of the power (e.g., <code>nano</code>).
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A Boolean value indicating whether the power is active and can be specified for container services.
     * </p>
     * 
     * @return A Boolean value indicating whether the power is active and can be specified for container services.
     */
    public final Boolean isActive() {
        return isActive;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(powerId());
        hashCode = 31 * hashCode + Objects.hashCode(price());
        hashCode = 31 * hashCode + Objects.hashCode(cpuCount());
        hashCode = 31 * hashCode + Objects.hashCode(ramSizeInGb());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(isActive());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerServicePower)) {
            return false;
        }
        ContainerServicePower other = (ContainerServicePower) obj;
        return Objects.equals(powerId(), other.powerId()) && Objects.equals(price(), other.price())
                && Objects.equals(cpuCount(), other.cpuCount()) && Objects.equals(ramSizeInGb(), other.ramSizeInGb())
                && Objects.equals(name(), other.name()) && Objects.equals(isActive(), other.isActive());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContainerServicePower").add("PowerId", powerId()).add("Price", price())
                .add("CpuCount", cpuCount()).add("RamSizeInGb", ramSizeInGb()).add("Name", name()).add("IsActive", isActive())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "powerId":
            return Optional.ofNullable(clazz.cast(powerId()));
        case "price":
            return Optional.ofNullable(clazz.cast(price()));
        case "cpuCount":
            return Optional.ofNullable(clazz.cast(cpuCount()));
        case "ramSizeInGb":
            return Optional.ofNullable(clazz.cast(ramSizeInGb()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "isActive":
            return Optional.ofNullable(clazz.cast(isActive()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainerServicePower, T> g) {
        return obj -> g.apply((ContainerServicePower) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContainerServicePower> {
        /**
         * <p>
         * The ID of the power (e.g., <code>nano-1</code>).
         * </p>
         * 
         * @param powerId
         *        The ID of the power (e.g., <code>nano-1</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder powerId(String powerId);

        /**
         * <p>
         * The monthly price of the power in USD.
         * </p>
         * 
         * @param price
         *        The monthly price of the power in USD.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder price(Float price);

        /**
         * <p>
         * The number of vCPUs included in the power.
         * </p>
         * 
         * @param cpuCount
         *        The number of vCPUs included in the power.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpuCount(Float cpuCount);

        /**
         * <p>
         * The amount of RAM (in GB) of the power.
         * </p>
         * 
         * @param ramSizeInGb
         *        The amount of RAM (in GB) of the power.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ramSizeInGb(Float ramSizeInGb);

        /**
         * <p>
         * The friendly name of the power (e.g., <code>nano</code>).
         * </p>
         * 
         * @param name
         *        The friendly name of the power (e.g., <code>nano</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A Boolean value indicating whether the power is active and can be specified for container services.
         * </p>
         * 
         * @param isActive
         *        A Boolean value indicating whether the power is active and can be specified for container services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isActive(Boolean isActive);
    }

    static final class BuilderImpl implements Builder {
        private String powerId;

        private Float price;

        private Float cpuCount;

        private Float ramSizeInGb;

        private String name;

        private Boolean isActive;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerServicePower model) {
            powerId(model.powerId);
            price(model.price);
            cpuCount(model.cpuCount);
            ramSizeInGb(model.ramSizeInGb);
            name(model.name);
            isActive(model.isActive);
        }

        public final String getPowerId() {
            return powerId;
        }

        @Override
        public final Builder powerId(String powerId) {
            this.powerId = powerId;
            return this;
        }

        public final void setPowerId(String powerId) {
            this.powerId = powerId;
        }

        public final Float getPrice() {
            return price;
        }

        @Override
        public final Builder price(Float price) {
            this.price = price;
            return this;
        }

        public final void setPrice(Float price) {
            this.price = price;
        }

        public final Float getCpuCount() {
            return cpuCount;
        }

        @Override
        public final Builder cpuCount(Float cpuCount) {
            this.cpuCount = cpuCount;
            return this;
        }

        public final void setCpuCount(Float cpuCount) {
            this.cpuCount = cpuCount;
        }

        public final Float getRamSizeInGb() {
            return ramSizeInGb;
        }

        @Override
        public final Builder ramSizeInGb(Float ramSizeInGb) {
            this.ramSizeInGb = ramSizeInGb;
            return this;
        }

        public final void setRamSizeInGb(Float ramSizeInGb) {
            this.ramSizeInGb = ramSizeInGb;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Boolean getIsActive() {
            return isActive;
        }

        @Override
        public final Builder isActive(Boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        public final void setIsActive(Boolean isActive) {
            this.isActive = isActive;
        }

        @Override
        public ContainerServicePower build() {
            return new ContainerServicePower(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
