/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.lightsail.model.AccessDeniedException;
import software.amazon.awssdk.services.lightsail.model.AccountSetupInProgressException;
import software.amazon.awssdk.services.lightsail.model.AllocateStaticIpRequest;
import software.amazon.awssdk.services.lightsail.model.AllocateStaticIpResponse;
import software.amazon.awssdk.services.lightsail.model.AttachCertificateToDistributionRequest;
import software.amazon.awssdk.services.lightsail.model.AttachCertificateToDistributionResponse;
import software.amazon.awssdk.services.lightsail.model.AttachDiskRequest;
import software.amazon.awssdk.services.lightsail.model.AttachDiskResponse;
import software.amazon.awssdk.services.lightsail.model.AttachInstancesToLoadBalancerRequest;
import software.amazon.awssdk.services.lightsail.model.AttachInstancesToLoadBalancerResponse;
import software.amazon.awssdk.services.lightsail.model.AttachLoadBalancerTlsCertificateRequest;
import software.amazon.awssdk.services.lightsail.model.AttachLoadBalancerTlsCertificateResponse;
import software.amazon.awssdk.services.lightsail.model.AttachStaticIpRequest;
import software.amazon.awssdk.services.lightsail.model.AttachStaticIpResponse;
import software.amazon.awssdk.services.lightsail.model.CloseInstancePublicPortsRequest;
import software.amazon.awssdk.services.lightsail.model.CloseInstancePublicPortsResponse;
import software.amazon.awssdk.services.lightsail.model.CopySnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CopySnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.CreateCertificateRequest;
import software.amazon.awssdk.services.lightsail.model.CreateCertificateResponse;
import software.amazon.awssdk.services.lightsail.model.CreateCloudFormationStackRequest;
import software.amazon.awssdk.services.lightsail.model.CreateCloudFormationStackResponse;
import software.amazon.awssdk.services.lightsail.model.CreateContactMethodRequest;
import software.amazon.awssdk.services.lightsail.model.CreateContactMethodResponse;
import software.amazon.awssdk.services.lightsail.model.CreateContainerServiceDeploymentRequest;
import software.amazon.awssdk.services.lightsail.model.CreateContainerServiceDeploymentResponse;
import software.amazon.awssdk.services.lightsail.model.CreateContainerServiceRegistryLoginRequest;
import software.amazon.awssdk.services.lightsail.model.CreateContainerServiceRegistryLoginResponse;
import software.amazon.awssdk.services.lightsail.model.CreateContainerServiceRequest;
import software.amazon.awssdk.services.lightsail.model.CreateContainerServiceResponse;
import software.amazon.awssdk.services.lightsail.model.CreateDiskFromSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CreateDiskFromSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.CreateDiskRequest;
import software.amazon.awssdk.services.lightsail.model.CreateDiskResponse;
import software.amazon.awssdk.services.lightsail.model.CreateDiskSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CreateDiskSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.CreateDistributionRequest;
import software.amazon.awssdk.services.lightsail.model.CreateDistributionResponse;
import software.amazon.awssdk.services.lightsail.model.CreateDomainEntryRequest;
import software.amazon.awssdk.services.lightsail.model.CreateDomainEntryResponse;
import software.amazon.awssdk.services.lightsail.model.CreateDomainRequest;
import software.amazon.awssdk.services.lightsail.model.CreateDomainResponse;
import software.amazon.awssdk.services.lightsail.model.CreateInstanceSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CreateInstanceSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.CreateInstancesFromSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CreateInstancesFromSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.CreateInstancesRequest;
import software.amazon.awssdk.services.lightsail.model.CreateInstancesResponse;
import software.amazon.awssdk.services.lightsail.model.CreateKeyPairRequest;
import software.amazon.awssdk.services.lightsail.model.CreateKeyPairResponse;
import software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerRequest;
import software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerResponse;
import software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerTlsCertificateRequest;
import software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerTlsCertificateResponse;
import software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseFromSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseFromSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseRequest;
import software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseResponse;
import software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteAlarmRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteAlarmResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteAutoSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteAutoSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteCertificateRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteCertificateResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteContactMethodRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteContactMethodResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteContainerImageRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteContainerImageResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteContainerServiceRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteContainerServiceResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteDiskRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteDiskResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteDiskSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteDiskSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteDistributionRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteDistributionResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteDomainEntryRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteDomainEntryResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteDomainRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteDomainResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteInstanceRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteInstanceResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteInstanceSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteInstanceSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteKeyPairRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteKeyPairResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteKnownHostKeysRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteKnownHostKeysResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerTlsCertificateRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerTlsCertificateResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseResponse;
import software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.DeleteRelationalDatabaseSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.DetachCertificateFromDistributionRequest;
import software.amazon.awssdk.services.lightsail.model.DetachCertificateFromDistributionResponse;
import software.amazon.awssdk.services.lightsail.model.DetachDiskRequest;
import software.amazon.awssdk.services.lightsail.model.DetachDiskResponse;
import software.amazon.awssdk.services.lightsail.model.DetachInstancesFromLoadBalancerRequest;
import software.amazon.awssdk.services.lightsail.model.DetachInstancesFromLoadBalancerResponse;
import software.amazon.awssdk.services.lightsail.model.DetachStaticIpRequest;
import software.amazon.awssdk.services.lightsail.model.DetachStaticIpResponse;
import software.amazon.awssdk.services.lightsail.model.DisableAddOnRequest;
import software.amazon.awssdk.services.lightsail.model.DisableAddOnResponse;
import software.amazon.awssdk.services.lightsail.model.DownloadDefaultKeyPairRequest;
import software.amazon.awssdk.services.lightsail.model.DownloadDefaultKeyPairResponse;
import software.amazon.awssdk.services.lightsail.model.EnableAddOnRequest;
import software.amazon.awssdk.services.lightsail.model.EnableAddOnResponse;
import software.amazon.awssdk.services.lightsail.model.ExportSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.ExportSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.GetActiveNamesRequest;
import software.amazon.awssdk.services.lightsail.model.GetActiveNamesResponse;
import software.amazon.awssdk.services.lightsail.model.GetAlarmsRequest;
import software.amazon.awssdk.services.lightsail.model.GetAlarmsResponse;
import software.amazon.awssdk.services.lightsail.model.GetAutoSnapshotsRequest;
import software.amazon.awssdk.services.lightsail.model.GetAutoSnapshotsResponse;
import software.amazon.awssdk.services.lightsail.model.GetBlueprintsRequest;
import software.amazon.awssdk.services.lightsail.model.GetBlueprintsResponse;
import software.amazon.awssdk.services.lightsail.model.GetBundlesRequest;
import software.amazon.awssdk.services.lightsail.model.GetBundlesResponse;
import software.amazon.awssdk.services.lightsail.model.GetCertificatesRequest;
import software.amazon.awssdk.services.lightsail.model.GetCertificatesResponse;
import software.amazon.awssdk.services.lightsail.model.GetCloudFormationStackRecordsRequest;
import software.amazon.awssdk.services.lightsail.model.GetCloudFormationStackRecordsResponse;
import software.amazon.awssdk.services.lightsail.model.GetContactMethodsRequest;
import software.amazon.awssdk.services.lightsail.model.GetContactMethodsResponse;
import software.amazon.awssdk.services.lightsail.model.GetContainerApiMetadataRequest;
import software.amazon.awssdk.services.lightsail.model.GetContainerApiMetadataResponse;
import software.amazon.awssdk.services.lightsail.model.GetContainerImagesRequest;
import software.amazon.awssdk.services.lightsail.model.GetContainerImagesResponse;
import software.amazon.awssdk.services.lightsail.model.GetContainerLogRequest;
import software.amazon.awssdk.services.lightsail.model.GetContainerLogResponse;
import software.amazon.awssdk.services.lightsail.model.GetContainerServiceDeploymentsRequest;
import software.amazon.awssdk.services.lightsail.model.GetContainerServiceDeploymentsResponse;
import software.amazon.awssdk.services.lightsail.model.GetContainerServiceMetricDataRequest;
import software.amazon.awssdk.services.lightsail.model.GetContainerServiceMetricDataResponse;
import software.amazon.awssdk.services.lightsail.model.GetContainerServicePowersRequest;
import software.amazon.awssdk.services.lightsail.model.GetContainerServicePowersResponse;
import software.amazon.awssdk.services.lightsail.model.GetContainerServicesRequest;
import software.amazon.awssdk.services.lightsail.model.GetContainerServicesResponse;
import software.amazon.awssdk.services.lightsail.model.GetDiskRequest;
import software.amazon.awssdk.services.lightsail.model.GetDiskResponse;
import software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotsRequest;
import software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotsResponse;
import software.amazon.awssdk.services.lightsail.model.GetDisksRequest;
import software.amazon.awssdk.services.lightsail.model.GetDisksResponse;
import software.amazon.awssdk.services.lightsail.model.GetDistributionBundlesRequest;
import software.amazon.awssdk.services.lightsail.model.GetDistributionBundlesResponse;
import software.amazon.awssdk.services.lightsail.model.GetDistributionLatestCacheResetRequest;
import software.amazon.awssdk.services.lightsail.model.GetDistributionLatestCacheResetResponse;
import software.amazon.awssdk.services.lightsail.model.GetDistributionMetricDataRequest;
import software.amazon.awssdk.services.lightsail.model.GetDistributionMetricDataResponse;
import software.amazon.awssdk.services.lightsail.model.GetDistributionsRequest;
import software.amazon.awssdk.services.lightsail.model.GetDistributionsResponse;
import software.amazon.awssdk.services.lightsail.model.GetDomainRequest;
import software.amazon.awssdk.services.lightsail.model.GetDomainResponse;
import software.amazon.awssdk.services.lightsail.model.GetDomainsRequest;
import software.amazon.awssdk.services.lightsail.model.GetDomainsResponse;
import software.amazon.awssdk.services.lightsail.model.GetExportSnapshotRecordsRequest;
import software.amazon.awssdk.services.lightsail.model.GetExportSnapshotRecordsResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceMetricDataRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceMetricDataResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstancePortStatesResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotsRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotsResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstanceStateRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstanceStateResponse;
import software.amazon.awssdk.services.lightsail.model.GetInstancesRequest;
import software.amazon.awssdk.services.lightsail.model.GetInstancesResponse;
import software.amazon.awssdk.services.lightsail.model.GetKeyPairRequest;
import software.amazon.awssdk.services.lightsail.model.GetKeyPairResponse;
import software.amazon.awssdk.services.lightsail.model.GetKeyPairsRequest;
import software.amazon.awssdk.services.lightsail.model.GetKeyPairsResponse;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerMetricDataRequest;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerMetricDataResponse;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerRequest;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerResponse;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsCertificatesRequest;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsCertificatesResponse;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancersRequest;
import software.amazon.awssdk.services.lightsail.model.GetLoadBalancersResponse;
import software.amazon.awssdk.services.lightsail.model.GetOperationRequest;
import software.amazon.awssdk.services.lightsail.model.GetOperationResponse;
import software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceRequest;
import software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceResponse;
import software.amazon.awssdk.services.lightsail.model.GetOperationsRequest;
import software.amazon.awssdk.services.lightsail.model.GetOperationsResponse;
import software.amazon.awssdk.services.lightsail.model.GetRegionsRequest;
import software.amazon.awssdk.services.lightsail.model.GetRegionsResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBlueprintsRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBlueprintsResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBundlesRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBundlesResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseEventsRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseEventsResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogEventsRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogEventsResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogStreamsRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogStreamsResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMasterUserPasswordRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMasterUserPasswordResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMetricDataRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMetricDataResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseParametersRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseParametersResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotsRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotsResponse;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabasesRequest;
import software.amazon.awssdk.services.lightsail.model.GetRelationalDatabasesResponse;
import software.amazon.awssdk.services.lightsail.model.GetStaticIpRequest;
import software.amazon.awssdk.services.lightsail.model.GetStaticIpResponse;
import software.amazon.awssdk.services.lightsail.model.GetStaticIpsRequest;
import software.amazon.awssdk.services.lightsail.model.GetStaticIpsResponse;
import software.amazon.awssdk.services.lightsail.model.ImportKeyPairRequest;
import software.amazon.awssdk.services.lightsail.model.ImportKeyPairResponse;
import software.amazon.awssdk.services.lightsail.model.InvalidInputException;
import software.amazon.awssdk.services.lightsail.model.IsVpcPeeredRequest;
import software.amazon.awssdk.services.lightsail.model.IsVpcPeeredResponse;
import software.amazon.awssdk.services.lightsail.model.LightsailException;
import software.amazon.awssdk.services.lightsail.model.NotFoundException;
import software.amazon.awssdk.services.lightsail.model.OpenInstancePublicPortsRequest;
import software.amazon.awssdk.services.lightsail.model.OpenInstancePublicPortsResponse;
import software.amazon.awssdk.services.lightsail.model.OperationFailureException;
import software.amazon.awssdk.services.lightsail.model.PeerVpcRequest;
import software.amazon.awssdk.services.lightsail.model.PeerVpcResponse;
import software.amazon.awssdk.services.lightsail.model.PutAlarmRequest;
import software.amazon.awssdk.services.lightsail.model.PutAlarmResponse;
import software.amazon.awssdk.services.lightsail.model.PutInstancePublicPortsRequest;
import software.amazon.awssdk.services.lightsail.model.PutInstancePublicPortsResponse;
import software.amazon.awssdk.services.lightsail.model.RebootInstanceRequest;
import software.amazon.awssdk.services.lightsail.model.RebootInstanceResponse;
import software.amazon.awssdk.services.lightsail.model.RebootRelationalDatabaseRequest;
import software.amazon.awssdk.services.lightsail.model.RebootRelationalDatabaseResponse;
import software.amazon.awssdk.services.lightsail.model.RegisterContainerImageRequest;
import software.amazon.awssdk.services.lightsail.model.RegisterContainerImageResponse;
import software.amazon.awssdk.services.lightsail.model.ReleaseStaticIpRequest;
import software.amazon.awssdk.services.lightsail.model.ReleaseStaticIpResponse;
import software.amazon.awssdk.services.lightsail.model.ResetDistributionCacheRequest;
import software.amazon.awssdk.services.lightsail.model.ResetDistributionCacheResponse;
import software.amazon.awssdk.services.lightsail.model.SendContactMethodVerificationRequest;
import software.amazon.awssdk.services.lightsail.model.SendContactMethodVerificationResponse;
import software.amazon.awssdk.services.lightsail.model.ServiceException;
import software.amazon.awssdk.services.lightsail.model.SetIpAddressTypeRequest;
import software.amazon.awssdk.services.lightsail.model.SetIpAddressTypeResponse;
import software.amazon.awssdk.services.lightsail.model.StartInstanceRequest;
import software.amazon.awssdk.services.lightsail.model.StartInstanceResponse;
import software.amazon.awssdk.services.lightsail.model.StartRelationalDatabaseRequest;
import software.amazon.awssdk.services.lightsail.model.StartRelationalDatabaseResponse;
import software.amazon.awssdk.services.lightsail.model.StopInstanceRequest;
import software.amazon.awssdk.services.lightsail.model.StopInstanceResponse;
import software.amazon.awssdk.services.lightsail.model.StopRelationalDatabaseRequest;
import software.amazon.awssdk.services.lightsail.model.StopRelationalDatabaseResponse;
import software.amazon.awssdk.services.lightsail.model.TagResourceRequest;
import software.amazon.awssdk.services.lightsail.model.TagResourceResponse;
import software.amazon.awssdk.services.lightsail.model.TestAlarmRequest;
import software.amazon.awssdk.services.lightsail.model.TestAlarmResponse;
import software.amazon.awssdk.services.lightsail.model.UnauthenticatedException;
import software.amazon.awssdk.services.lightsail.model.UnpeerVpcRequest;
import software.amazon.awssdk.services.lightsail.model.UnpeerVpcResponse;
import software.amazon.awssdk.services.lightsail.model.UntagResourceRequest;
import software.amazon.awssdk.services.lightsail.model.UntagResourceResponse;
import software.amazon.awssdk.services.lightsail.model.UpdateContainerServiceRequest;
import software.amazon.awssdk.services.lightsail.model.UpdateContainerServiceResponse;
import software.amazon.awssdk.services.lightsail.model.UpdateDistributionBundleRequest;
import software.amazon.awssdk.services.lightsail.model.UpdateDistributionBundleResponse;
import software.amazon.awssdk.services.lightsail.model.UpdateDistributionRequest;
import software.amazon.awssdk.services.lightsail.model.UpdateDistributionResponse;
import software.amazon.awssdk.services.lightsail.model.UpdateDomainEntryRequest;
import software.amazon.awssdk.services.lightsail.model.UpdateDomainEntryResponse;
import software.amazon.awssdk.services.lightsail.model.UpdateLoadBalancerAttributeRequest;
import software.amazon.awssdk.services.lightsail.model.UpdateLoadBalancerAttributeResponse;
import software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseParametersRequest;
import software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseParametersResponse;
import software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseRequest;
import software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseResponse;
import software.amazon.awssdk.services.lightsail.transform.AllocateStaticIpRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.AttachCertificateToDistributionRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.AttachDiskRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.AttachInstancesToLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.AttachLoadBalancerTlsCertificateRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.AttachStaticIpRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CloseInstancePublicPortsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CopySnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateCertificateRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateCloudFormationStackRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateContactMethodRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateContainerServiceDeploymentRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateContainerServiceRegistryLoginRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateContainerServiceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateDiskFromSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateDiskRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateDiskSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateDistributionRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateDomainEntryRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateDomainRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateInstanceSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateInstancesFromSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateInstancesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateKeyPairRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateLoadBalancerTlsCertificateRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateRelationalDatabaseFromSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateRelationalDatabaseRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.CreateRelationalDatabaseSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteAlarmRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteAutoSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteCertificateRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteContactMethodRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteContainerImageRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteContainerServiceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteDiskRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteDiskSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteDistributionRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteDomainEntryRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteDomainRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteInstanceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteInstanceSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteKeyPairRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteKnownHostKeysRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteLoadBalancerTlsCertificateRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteRelationalDatabaseRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DeleteRelationalDatabaseSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DetachCertificateFromDistributionRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DetachDiskRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DetachInstancesFromLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DetachStaticIpRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DisableAddOnRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.DownloadDefaultKeyPairRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.EnableAddOnRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.ExportSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetActiveNamesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetAlarmsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetAutoSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetBlueprintsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetBundlesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetCertificatesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetCloudFormationStackRecordsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetContactMethodsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetContainerApiMetadataRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetContainerImagesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetContainerLogRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetContainerServiceDeploymentsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetContainerServiceMetricDataRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetContainerServicePowersRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetContainerServicesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDiskRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDiskSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDiskSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDisksRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDistributionBundlesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDistributionLatestCacheResetRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDistributionMetricDataRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDistributionsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDomainRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetDomainsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetExportSnapshotRecordsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceAccessDetailsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceMetricDataRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstancePortStatesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstanceStateRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetInstancesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetKeyPairRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetKeyPairsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetLoadBalancerMetricDataRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetLoadBalancerTlsCertificatesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetLoadBalancersRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetOperationRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetOperationsForResourceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetOperationsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRegionsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseBlueprintsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseBundlesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseEventsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseLogEventsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseLogStreamsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseMasterUserPasswordRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseMetricDataRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseParametersRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseSnapshotRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabaseSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetRelationalDatabasesRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetStaticIpRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.GetStaticIpsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.ImportKeyPairRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.IsVpcPeeredRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.OpenInstancePublicPortsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.PeerVpcRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.PutAlarmRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.PutInstancePublicPortsRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.RebootInstanceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.RebootRelationalDatabaseRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.RegisterContainerImageRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.ReleaseStaticIpRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.ResetDistributionCacheRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.SendContactMethodVerificationRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.SetIpAddressTypeRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.StartInstanceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.StartRelationalDatabaseRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.StopInstanceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.StopRelationalDatabaseRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.TestAlarmRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UnpeerVpcRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UpdateContainerServiceRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UpdateDistributionBundleRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UpdateDistributionRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UpdateDomainEntryRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UpdateLoadBalancerAttributeRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UpdateRelationalDatabaseParametersRequestMarshaller;
import software.amazon.awssdk.services.lightsail.transform.UpdateRelationalDatabaseRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link LightsailAsyncClient}.
 *
 * @see LightsailAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultLightsailAsyncClient implements LightsailAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultLightsailAsyncClient.class);

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultLightsailAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Allocates a static IP address.
     * </p>
     *
     * @param allocateStaticIpRequest
     * @return A Java Future containing the result of the AllocateStaticIp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.AllocateStaticIp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AllocateStaticIp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AllocateStaticIpResponse> allocateStaticIp(AllocateStaticIpRequest allocateStaticIpRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, allocateStaticIpRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AllocateStaticIp");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AllocateStaticIpResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AllocateStaticIpResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AllocateStaticIpResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AllocateStaticIpRequest, AllocateStaticIpResponse>()
                            .withOperationName("AllocateStaticIp")
                            .withMarshaller(new AllocateStaticIpRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(allocateStaticIpRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = allocateStaticIpRequest.overrideConfiguration().orElse(null);
            CompletableFuture<AllocateStaticIpResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attaches an SSL/TLS certificate to your Amazon Lightsail content delivery network (CDN) distribution.
     * </p>
     * <p>
     * After the certificate is attached, your distribution accepts HTTPS traffic for all of the domains that are
     * associated with the certificate.
     * </p>
     * <p>
     * Use the <code>CreateCertificate</code> action to create a certificate that you can attach to your distribution.
     * </p>
     * <important>
     * <p>
     * Only certificates created in the <code>us-east-1</code> AWS Region can be attached to Lightsail distributions.
     * Lightsail distributions are global resources that can reference an origin in any AWS Region, and distribute its
     * content globally. However, all distributions are located in the <code>us-east-1</code> Region.
     * </p>
     * </important>
     *
     * @param attachCertificateToDistributionRequest
     * @return A Java Future containing the result of the AttachCertificateToDistribution operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.AttachCertificateToDistribution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachCertificateToDistribution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AttachCertificateToDistributionResponse> attachCertificateToDistribution(
            AttachCertificateToDistributionRequest attachCertificateToDistributionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                attachCertificateToDistributionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AttachCertificateToDistribution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AttachCertificateToDistributionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AttachCertificateToDistributionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AttachCertificateToDistributionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AttachCertificateToDistributionRequest, AttachCertificateToDistributionResponse>()
                            .withOperationName("AttachCertificateToDistribution")
                            .withMarshaller(new AttachCertificateToDistributionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(attachCertificateToDistributionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = attachCertificateToDistributionRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<AttachCertificateToDistributionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attaches a block storage disk to a running or stopped Lightsail instance and exposes it to the instance with the
     * specified disk name.
     * </p>
     * <p>
     * The <code>attach disk</code> operation supports tag-based access control via resource tags applied to the
     * resource identified by <code>disk name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param attachDiskRequest
     * @return A Java Future containing the result of the AttachDisk operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.AttachDisk
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachDisk" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AttachDiskResponse> attachDisk(AttachDiskRequest attachDiskRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, attachDiskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AttachDisk");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AttachDiskResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    AttachDiskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AttachDiskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AttachDiskRequest, AttachDiskResponse>().withOperationName("AttachDisk")
                            .withMarshaller(new AttachDiskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(attachDiskRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = attachDiskRequest.overrideConfiguration().orElse(null);
            CompletableFuture<AttachDiskResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attaches one or more Lightsail instances to a load balancer.
     * </p>
     * <p>
     * After some time, the instances are attached to the load balancer and the health check status is available.
     * </p>
     * <p>
     * The <code>attach instances to load balancer</code> operation supports tag-based access control via resource tags
     * applied to the resource identified by <code>load balancer name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param attachInstancesToLoadBalancerRequest
     * @return A Java Future containing the result of the AttachInstancesToLoadBalancer operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.AttachInstancesToLoadBalancer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachInstancesToLoadBalancer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AttachInstancesToLoadBalancerResponse> attachInstancesToLoadBalancer(
            AttachInstancesToLoadBalancerRequest attachInstancesToLoadBalancerRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                attachInstancesToLoadBalancerRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AttachInstancesToLoadBalancer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AttachInstancesToLoadBalancerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AttachInstancesToLoadBalancerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AttachInstancesToLoadBalancerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AttachInstancesToLoadBalancerRequest, AttachInstancesToLoadBalancerResponse>()
                            .withOperationName("AttachInstancesToLoadBalancer")
                            .withMarshaller(new AttachInstancesToLoadBalancerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(attachInstancesToLoadBalancerRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = attachInstancesToLoadBalancerRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<AttachInstancesToLoadBalancerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attaches a Transport Layer Security (TLS) certificate to your load balancer. TLS is just an updated, more secure
     * version of Secure Socket Layer (SSL).
     * </p>
     * <p>
     * Once you create and validate your certificate, you can attach it to your load balancer. You can also use this API
     * to rotate the certificates on your account. Use the <code>AttachLoadBalancerTlsCertificate</code> action with the
     * non-attached certificate, and it will replace the existing one and become the attached certificate.
     * </p>
     * <p>
     * The <code>AttachLoadBalancerTlsCertificate</code> operation supports tag-based access control via resource tags
     * applied to the resource identified by <code>load balancer name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param attachLoadBalancerTlsCertificateRequest
     * @return A Java Future containing the result of the AttachLoadBalancerTlsCertificate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.AttachLoadBalancerTlsCertificate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachLoadBalancerTlsCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AttachLoadBalancerTlsCertificateResponse> attachLoadBalancerTlsCertificate(
            AttachLoadBalancerTlsCertificateRequest attachLoadBalancerTlsCertificateRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                attachLoadBalancerTlsCertificateRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AttachLoadBalancerTlsCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AttachLoadBalancerTlsCertificateResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, AttachLoadBalancerTlsCertificateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AttachLoadBalancerTlsCertificateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AttachLoadBalancerTlsCertificateRequest, AttachLoadBalancerTlsCertificateResponse>()
                            .withOperationName("AttachLoadBalancerTlsCertificate")
                            .withMarshaller(new AttachLoadBalancerTlsCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(attachLoadBalancerTlsCertificateRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = attachLoadBalancerTlsCertificateRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<AttachLoadBalancerTlsCertificateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attaches a static IP address to a specific Amazon Lightsail instance.
     * </p>
     *
     * @param attachStaticIpRequest
     * @return A Java Future containing the result of the AttachStaticIp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.AttachStaticIp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachStaticIp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AttachStaticIpResponse> attachStaticIp(AttachStaticIpRequest attachStaticIpRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, attachStaticIpRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AttachStaticIp");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AttachStaticIpResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AttachStaticIpResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AttachStaticIpResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AttachStaticIpRequest, AttachStaticIpResponse>()
                            .withOperationName("AttachStaticIp")
                            .withMarshaller(new AttachStaticIpRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(attachStaticIpRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = attachStaticIpRequest.overrideConfiguration().orElse(null);
            CompletableFuture<AttachStaticIpResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Closes ports for a specific Amazon Lightsail instance.
     * </p>
     * <p>
     * The <code>CloseInstancePublicPorts</code> action supports tag-based access control via resource tags applied to
     * the resource identified by <code>instanceName</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param closeInstancePublicPortsRequest
     * @return A Java Future containing the result of the CloseInstancePublicPorts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CloseInstancePublicPorts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CloseInstancePublicPorts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CloseInstancePublicPortsResponse> closeInstancePublicPorts(
            CloseInstancePublicPortsRequest closeInstancePublicPortsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, closeInstancePublicPortsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CloseInstancePublicPorts");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CloseInstancePublicPortsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CloseInstancePublicPortsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CloseInstancePublicPortsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CloseInstancePublicPortsRequest, CloseInstancePublicPortsResponse>()
                            .withOperationName("CloseInstancePublicPorts")
                            .withMarshaller(new CloseInstancePublicPortsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(closeInstancePublicPortsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = closeInstancePublicPortsRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<CloseInstancePublicPortsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Copies a manual snapshot of an instance or disk as another manual snapshot, or copies an automatic snapshot of an
     * instance or disk as a manual snapshot. This operation can also be used to copy a manual or automatic snapshot of
     * an instance or a disk from one AWS Region to another in Amazon Lightsail.
     * </p>
     * <p>
     * When copying a <i>manual snapshot</i>, be sure to define the <code>source region</code>,
     * <code>source snapshot name</code>, and <code>target snapshot name</code> parameters.
     * </p>
     * <p>
     * When copying an <i>automatic snapshot</i>, be sure to define the <code>source region</code>,
     * <code>source resource name</code>, <code>target snapshot name</code>, and either the <code>restore date</code> or
     * the <code>use latest restorable auto snapshot</code> parameters.
     * </p>
     *
     * @param copySnapshotRequest
     * @return A Java Future containing the result of the CopySnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CopySnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CopySnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CopySnapshotResponse> copySnapshot(CopySnapshotRequest copySnapshotRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, copySnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CopySnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CopySnapshotResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CopySnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CopySnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CopySnapshotRequest, CopySnapshotResponse>()
                            .withOperationName("CopySnapshot").withMarshaller(new CopySnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(copySnapshotRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = copySnapshotRequest.overrideConfiguration().orElse(null);
            CompletableFuture<CopySnapshotResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an SSL/TLS certificate for an Amazon Lightsail content delivery network (CDN) distribution and a
     * container service.
     * </p>
     * <p>
     * After the certificate is valid, use the <code>AttachCertificateToDistribution</code> action to use the
     * certificate and its domains with your distribution. Or use the <code>UpdateContainerService</code> action to use
     * the certificate and its domains with your container service.
     * </p>
     * <important>
     * <p>
     * Only certificates created in the <code>us-east-1</code> AWS Region can be attached to Lightsail distributions.
     * Lightsail distributions are global resources that can reference an origin in any AWS Region, and distribute its
     * content globally. However, all distributions are located in the <code>us-east-1</code> Region.
     * </p>
     * </important>
     *
     * @param createCertificateRequest
     * @return A Java Future containing the result of the CreateCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateCertificate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateCertificate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCertificateResponse> createCertificate(CreateCertificateRequest createCertificateRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateCertificateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateCertificateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCertificateRequest, CreateCertificateResponse>()
                            .withOperationName("CreateCertificate")
                            .withMarshaller(new CreateCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createCertificateRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createCertificateRequest.overrideConfiguration().orElse(null);
            CompletableFuture<CreateCertificateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an AWS CloudFormation stack, which creates a new Amazon EC2 instance from an exported Amazon Lightsail
     * snapshot. This operation results in a CloudFormation stack record that can be used to track the AWS
     * CloudFormation stack created. Use the <code>get cloud formation stack records</code> operation to get a list of
     * the CloudFormation stacks created.
     * </p>
     * <important>
     * <p>
     * Wait until after your new Amazon EC2 instance is created before running the
     * <code>create cloud formation stack</code> operation again with the same export snapshot record.
     * </p>
     * </important>
     *
     * @param createCloudFormationStackRequest
     * @return A Java Future containing the result of the CreateCloudFormationStack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateCloudFormationStack
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateCloudFormationStack"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCloudFormationStackResponse> createCloudFormationStack(
            CreateCloudFormationStackRequest createCloudFormationStackRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCloudFormationStackRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCloudFormationStack");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateCloudFormationStackResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateCloudFormationStackResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateCloudFormationStackResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCloudFormationStackRequest, CreateCloudFormationStackResponse>()
                            .withOperationName("CreateCloudFormationStack")
                            .withMarshaller(new CreateCloudFormationStackRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createCloudFormationStackRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createCloudFormationStackRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<CreateCloudFormationStackResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an email or SMS text message contact method.
     * </p>
     * <p>
     * A contact method is used to send you notifications about your Amazon Lightsail resources. You can add one email
     * address and one mobile phone number contact method in each AWS Region. However, SMS text messaging is not
     * supported in some AWS Regions, and SMS text messages cannot be sent to some countries/regions. For more
     * information, see <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications">Notifications in
     * Amazon Lightsail</a>.
     * </p>
     *
     * @param createContactMethodRequest
     * @return A Java Future containing the result of the CreateContactMethod operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateContactMethod
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateContactMethod" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateContactMethodResponse> createContactMethod(
            CreateContactMethodRequest createContactMethodRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createContactMethodRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateContactMethod");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateContactMethodResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateContactMethodResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateContactMethodResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateContactMethodRequest, CreateContactMethodResponse>()
                            .withOperationName("CreateContactMethod")
                            .withMarshaller(new CreateContactMethodRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createContactMethodRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createContactMethodRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<CreateContactMethodResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Amazon Lightsail container service.
     * </p>
     * <p>
     * A Lightsail container service is a compute resource to which you can deploy containers. For more information, see
     * <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-container-services">Container
     * services in Amazon Lightsail</a> in the <i>Lightsail Dev Guide</i>.
     * </p>
     *
     * @param createContainerServiceRequest
     * @return A Java Future containing the result of the CreateContainerService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateContainerService
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateContainerService"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateContainerServiceResponse> createContainerService(
            CreateContainerServiceRequest createContainerServiceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createContainerServiceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateContainerService");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateContainerServiceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateContainerServiceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateContainerServiceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateContainerServiceRequest, CreateContainerServiceResponse>()
                            .withOperationName("CreateContainerService")
                            .withMarshaller(new CreateContainerServiceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createContainerServiceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createContainerServiceRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<CreateContainerServiceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a deployment for your Amazon Lightsail container service.
     * </p>
     * <p>
     * A deployment specifies the containers that will be launched on the container service and their settings, such as
     * the ports to open, the environment variables to apply, and the launch command to run. It also specifies the
     * container that will serve as the public endpoint of the deployment and its settings, such as the HTTP or HTTPS
     * port to use, and the health check configuration.
     * </p>
     * <p>
     * You can deploy containers to your container service using container images from a public registry like Docker
     * Hub, or from your local machine. For more information, see <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-creating-container-images"
     * >Creating container images for your Amazon Lightsail container services</a> in the <i>Lightsail Dev Guide</i>.
     * </p>
     *
     * @param createContainerServiceDeploymentRequest
     * @return A Java Future containing the result of the CreateContainerServiceDeployment operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateContainerServiceDeployment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateContainerServiceDeployment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateContainerServiceDeploymentResponse> createContainerServiceDeployment(
            CreateContainerServiceDeploymentRequest createContainerServiceDeploymentRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createContainerServiceDeploymentRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateContainerServiceDeployment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateContainerServiceDeploymentResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreateContainerServiceDeploymentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateContainerServiceDeploymentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateContainerServiceDeploymentRequest, CreateContainerServiceDeploymentResponse>()
                            .withOperationName("CreateContainerServiceDeployment")
                            .withMarshaller(new CreateContainerServiceDeploymentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createContainerServiceDeploymentRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createContainerServiceDeploymentRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<CreateContainerServiceDeploymentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a temporary set of log in credentials that you can use to log in to the Docker process on your local
     * machine. After you're logged in, you can use the native Docker commands to push your local container images to
     * the container image registry of your Amazon Lightsail account so that you can use them with your Lightsail
     * container service. The log in credentials expire 12 hours after they are created, at which point you will need to
     * create a new set of log in credentials.
     * </p>
     * <note>
     * <p>
     * You can only push container images to the container service registry of your Lightsail account. You cannot pull
     * container images or perform any other container image management actions on the container service registry.
     * </p>
     * </note>
     * <p>
     * After you push your container images to the container image registry of your Lightsail account, use the
     * <code>RegisterContainerImage</code> action to register the pushed images to a specific Lightsail container
     * service.
     * </p>
     * <note>
     * <p>
     * This action is not required if you install and use the Lightsail Control (lightsailctl) plugin to push container
     * images to your Lightsail container service. For more information, see <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-pushing-container-images">Pushing
     * and managing container images on your Amazon Lightsail container services</a> in the <i>Lightsail Dev Guide</i>.
     * </p>
     * </note>
     *
     * @param createContainerServiceRegistryLoginRequest
     * @return A Java Future containing the result of the CreateContainerServiceRegistryLogin operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateContainerServiceRegistryLogin
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateContainerServiceRegistryLogin"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateContainerServiceRegistryLoginResponse> createContainerServiceRegistryLogin(
            CreateContainerServiceRegistryLoginRequest createContainerServiceRegistryLoginRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createContainerServiceRegistryLoginRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateContainerServiceRegistryLogin");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateContainerServiceRegistryLoginResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreateContainerServiceRegistryLoginResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateContainerServiceRegistryLoginResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateContainerServiceRegistryLoginRequest, CreateContainerServiceRegistryLoginResponse>()
                            .withOperationName("CreateContainerServiceRegistryLogin")
                            .withMarshaller(new CreateContainerServiceRegistryLoginRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createContainerServiceRegistryLoginRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createContainerServiceRegistryLoginRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<CreateContainerServiceRegistryLoginResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a block storage disk that can be attached to an Amazon Lightsail instance in the same Availability Zone
     * (e.g., <code>us-east-2a</code>).
     * </p>
     * <p>
     * The <code>create disk</code> operation supports tag-based access control via request tags. For more information,
     * see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param createDiskRequest
     * @return A Java Future containing the result of the CreateDisk operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateDisk
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDisk" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDiskResponse> createDisk(CreateDiskRequest createDiskRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDiskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDisk");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDiskResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateDiskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDiskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDiskRequest, CreateDiskResponse>().withOperationName("CreateDisk")
                            .withMarshaller(new CreateDiskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createDiskRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createDiskRequest.overrideConfiguration().orElse(null);
            CompletableFuture<CreateDiskResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a block storage disk from a manual or automatic snapshot of a disk. The resulting disk can be attached to
     * an Amazon Lightsail instance in the same Availability Zone (e.g., <code>us-east-2a</code>).
     * </p>
     * <p>
     * The <code>create disk from snapshot</code> operation supports tag-based access control via request tags and
     * resource tags applied to the resource identified by <code>disk snapshot name</code>. For more information, see
     * the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags">
     * Lightsail Dev Guide</a>.
     * </p>
     *
     * @param createDiskFromSnapshotRequest
     * @return A Java Future containing the result of the CreateDiskFromSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateDiskFromSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDiskFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDiskFromSnapshotResponse> createDiskFromSnapshot(
            CreateDiskFromSnapshotRequest createDiskFromSnapshotRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDiskFromSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDiskFromSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDiskFromSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDiskFromSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDiskFromSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDiskFromSnapshotRequest, CreateDiskFromSnapshotResponse>()
                            .withOperationName("CreateDiskFromSnapshot")
                            .withMarshaller(new CreateDiskFromSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createDiskFromSnapshotRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createDiskFromSnapshotRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<CreateDiskFromSnapshotResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a snapshot of a block storage disk. You can use snapshots for backups, to make copies of disks, and to
     * save data before shutting down a Lightsail instance.
     * </p>
     * <p>
     * You can take a snapshot of an attached disk that is in use; however, snapshots only capture data that has been
     * written to your disk at the time the snapshot command is issued. This may exclude any data that has been cached
     * by any applications or the operating system. If you can pause any file systems on the disk long enough to take a
     * snapshot, your snapshot should be complete. Nevertheless, if you cannot pause all file writes to the disk, you
     * should unmount the disk from within the Lightsail instance, issue the create disk snapshot command, and then
     * remount the disk to ensure a consistent and complete snapshot. You may remount and use your disk while the
     * snapshot status is pending.
     * </p>
     * <p>
     * You can also use this operation to create a snapshot of an instance's system volume. You might want to do this,
     * for example, to recover data from the system volume of a botched instance or to create a backup of the system
     * volume like you would for a block storage disk. To create a snapshot of a system volume, just define the
     * <code>instance name</code> parameter when issuing the snapshot command, and a snapshot of the defined instance's
     * system volume will be created. After the snapshot is available, you can create a block storage disk from the
     * snapshot and attach it to a running instance to access the data on the disk.
     * </p>
     * <p>
     * The <code>create disk snapshot</code> operation supports tag-based access control via request tags. For more
     * information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param createDiskSnapshotRequest
     * @return A Java Future containing the result of the CreateDiskSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateDiskSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDiskSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDiskSnapshotResponse> createDiskSnapshot(CreateDiskSnapshotRequest createDiskSnapshotRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDiskSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDiskSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDiskSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDiskSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDiskSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDiskSnapshotRequest, CreateDiskSnapshotResponse>()
                            .withOperationName("CreateDiskSnapshot")
                            .withMarshaller(new CreateDiskSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createDiskSnapshotRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createDiskSnapshotRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<CreateDiskSnapshotResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Amazon Lightsail content delivery network (CDN) distribution.
     * </p>
     * <p>
     * A distribution is a globally distributed network of caching servers that improve the performance of your website
     * or web application hosted on a Lightsail instance. For more information, see <a href=
     * "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-content-delivery-network-distributions"
     * >Content delivery networks in Amazon Lightsail</a>.
     * </p>
     *
     * @param createDistributionRequest
     * @return A Java Future containing the result of the CreateDistribution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateDistribution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDistribution" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDistributionResponse> createDistribution(CreateDistributionRequest createDistributionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDistributionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDistribution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDistributionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDistributionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDistributionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDistributionRequest, CreateDistributionResponse>()
                            .withOperationName("CreateDistribution")
                            .withMarshaller(new CreateDistributionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createDistributionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createDistributionRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<CreateDistributionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a domain resource for the specified domain (e.g., example.com).
     * </p>
     * <p>
     * The <code>create domain</code> operation supports tag-based access control via request tags. For more
     * information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param createDomainRequest
     * @return A Java Future containing the result of the CreateDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDomain" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDomainResponse> createDomain(CreateDomainRequest createDomainRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDomainRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDomainResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateDomainResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDomainResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDomainRequest, CreateDomainResponse>()
                            .withOperationName("CreateDomain").withMarshaller(new CreateDomainRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createDomainRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createDomainRequest.overrideConfiguration().orElse(null);
            CompletableFuture<CreateDomainResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates one of the following domain name system (DNS) records in a domain DNS zone: Address (A), canonical name
     * (CNAME), mail exchanger (MX), name server (NS), start of authority (SOA), service locator (SRV), or text (TXT).
     * </p>
     * <p>
     * The <code>create domain entry</code> operation supports tag-based access control via resource tags applied to the
     * resource identified by <code>domain name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param createDomainEntryRequest
     * @return A Java Future containing the result of the CreateDomainEntry operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateDomainEntry
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDomainEntry" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDomainEntryResponse> createDomainEntry(CreateDomainEntryRequest createDomainEntryRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDomainEntryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDomainEntry");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDomainEntryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDomainEntryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDomainEntryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDomainEntryRequest, CreateDomainEntryResponse>()
                            .withOperationName("CreateDomainEntry")
                            .withMarshaller(new CreateDomainEntryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createDomainEntryRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createDomainEntryRequest.overrideConfiguration().orElse(null);
            CompletableFuture<CreateDomainEntryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a snapshot of a specific virtual private server, or <i>instance</i>. You can use a snapshot to create a
     * new instance that is based on that snapshot.
     * </p>
     * <p>
     * The <code>create instance snapshot</code> operation supports tag-based access control via request tags. For more
     * information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param createInstanceSnapshotRequest
     * @return A Java Future containing the result of the CreateInstanceSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateInstanceSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstanceSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateInstanceSnapshotResponse> createInstanceSnapshot(
            CreateInstanceSnapshotRequest createInstanceSnapshotRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createInstanceSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateInstanceSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateInstanceSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateInstanceSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateInstanceSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateInstanceSnapshotRequest, CreateInstanceSnapshotResponse>()
                            .withOperationName("CreateInstanceSnapshot")
                            .withMarshaller(new CreateInstanceSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createInstanceSnapshotRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createInstanceSnapshotRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<CreateInstanceSnapshotResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates one or more Amazon Lightsail instances.
     * </p>
     * <p>
     * The <code>create instances</code> operation supports tag-based access control via request tags. For more
     * information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param createInstancesRequest
     * @return A Java Future containing the result of the CreateInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstances" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateInstancesResponse> createInstances(CreateInstancesRequest createInstancesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createInstancesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateInstances");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateInstancesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateInstancesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateInstancesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateInstancesRequest, CreateInstancesResponse>()
                            .withOperationName("CreateInstances")
                            .withMarshaller(new CreateInstancesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createInstancesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createInstancesRequest.overrideConfiguration().orElse(null);
            CompletableFuture<CreateInstancesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates one or more new instances from a manual or automatic snapshot of an instance.
     * </p>
     * <p>
     * The <code>create instances from snapshot</code> operation supports tag-based access control via request tags and
     * resource tags applied to the resource identified by <code>instance snapshot name</code>. For more information,
     * see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param createInstancesFromSnapshotRequest
     * @return A Java Future containing the result of the CreateInstancesFromSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateInstancesFromSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstancesFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateInstancesFromSnapshotResponse> createInstancesFromSnapshot(
            CreateInstancesFromSnapshotRequest createInstancesFromSnapshotRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createInstancesFromSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateInstancesFromSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateInstancesFromSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateInstancesFromSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateInstancesFromSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateInstancesFromSnapshotRequest, CreateInstancesFromSnapshotResponse>()
                            .withOperationName("CreateInstancesFromSnapshot")
                            .withMarshaller(new CreateInstancesFromSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createInstancesFromSnapshotRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createInstancesFromSnapshotRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<CreateInstancesFromSnapshotResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an SSH key pair.
     * </p>
     * <p>
     * The <code>create key pair</code> operation supports tag-based access control via request tags. For more
     * information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param createKeyPairRequest
     * @return A Java Future containing the result of the CreateKeyPair operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateKeyPairResponse> createKeyPair(CreateKeyPairRequest createKeyPairRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createKeyPairRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateKeyPair");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateKeyPairResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateKeyPairResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateKeyPairResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateKeyPairRequest, CreateKeyPairResponse>()
                            .withOperationName("CreateKeyPair")
                            .withMarshaller(new CreateKeyPairRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createKeyPairRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createKeyPairRequest.overrideConfiguration().orElse(null);
            CompletableFuture<CreateKeyPairResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a Lightsail load balancer. To learn more about deciding whether to load balance your application, see <a
     * href="https://lightsail.aws.amazon.com/ls/docs/how-to/article/configure-lightsail-instances-for-load-balancing">
     * Configure your Lightsail instances for load balancing</a>. You can create up to 5 load balancers per AWS Region
     * in your account.
     * </p>
     * <p>
     * When you create a load balancer, you can specify a unique name and port settings. To change additional load
     * balancer settings, use the <code>UpdateLoadBalancerAttribute</code> operation.
     * </p>
     * <p>
     * The <code>create load balancer</code> operation supports tag-based access control via request tags. For more
     * information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param createLoadBalancerRequest
     * @return A Java Future containing the result of the CreateLoadBalancer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateLoadBalancer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateLoadBalancer" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateLoadBalancerResponse> createLoadBalancer(CreateLoadBalancerRequest createLoadBalancerRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createLoadBalancerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateLoadBalancer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateLoadBalancerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateLoadBalancerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateLoadBalancerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateLoadBalancerRequest, CreateLoadBalancerResponse>()
                            .withOperationName("CreateLoadBalancer")
                            .withMarshaller(new CreateLoadBalancerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createLoadBalancerRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createLoadBalancerRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<CreateLoadBalancerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an SSL/TLS certificate for an Amazon Lightsail load balancer.
     * </p>
     * <p>
     * TLS is just an updated, more secure version of Secure Socket Layer (SSL).
     * </p>
     * <p>
     * The <code>CreateLoadBalancerTlsCertificate</code> operation supports tag-based access control via resource tags
     * applied to the resource identified by <code>load balancer name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param createLoadBalancerTlsCertificateRequest
     * @return A Java Future containing the result of the CreateLoadBalancerTlsCertificate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateLoadBalancerTlsCertificate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateLoadBalancerTlsCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateLoadBalancerTlsCertificateResponse> createLoadBalancerTlsCertificate(
            CreateLoadBalancerTlsCertificateRequest createLoadBalancerTlsCertificateRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createLoadBalancerTlsCertificateRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateLoadBalancerTlsCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateLoadBalancerTlsCertificateResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreateLoadBalancerTlsCertificateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateLoadBalancerTlsCertificateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateLoadBalancerTlsCertificateRequest, CreateLoadBalancerTlsCertificateResponse>()
                            .withOperationName("CreateLoadBalancerTlsCertificate")
                            .withMarshaller(new CreateLoadBalancerTlsCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createLoadBalancerTlsCertificateRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createLoadBalancerTlsCertificateRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<CreateLoadBalancerTlsCertificateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new database in Amazon Lightsail.
     * </p>
     * <p>
     * The <code>create relational database</code> operation supports tag-based access control via request tags. For
     * more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param createRelationalDatabaseRequest
     * @return A Java Future containing the result of the CreateRelationalDatabase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateRelationalDatabase
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateRelationalDatabase"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateRelationalDatabaseResponse> createRelationalDatabase(
            CreateRelationalDatabaseRequest createRelationalDatabaseRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRelationalDatabaseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRelationalDatabase");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateRelationalDatabaseResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateRelationalDatabaseResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateRelationalDatabaseResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateRelationalDatabaseRequest, CreateRelationalDatabaseResponse>()
                            .withOperationName("CreateRelationalDatabase")
                            .withMarshaller(new CreateRelationalDatabaseRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createRelationalDatabaseRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createRelationalDatabaseRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<CreateRelationalDatabaseResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new database from an existing database snapshot in Amazon Lightsail.
     * </p>
     * <p>
     * You can create a new database from a snapshot in if something goes wrong with your original database, or to
     * change it to a different plan, such as a high availability or standard plan.
     * </p>
     * <p>
     * The <code>create relational database from snapshot</code> operation supports tag-based access control via request
     * tags and resource tags applied to the resource identified by relationalDatabaseSnapshotName. For more
     * information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param createRelationalDatabaseFromSnapshotRequest
     * @return A Java Future containing the result of the CreateRelationalDatabaseFromSnapshot operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateRelationalDatabaseFromSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateRelationalDatabaseFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateRelationalDatabaseFromSnapshotResponse> createRelationalDatabaseFromSnapshot(
            CreateRelationalDatabaseFromSnapshotRequest createRelationalDatabaseFromSnapshotRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createRelationalDatabaseFromSnapshotRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRelationalDatabaseFromSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateRelationalDatabaseFromSnapshotResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreateRelationalDatabaseFromSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateRelationalDatabaseFromSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateRelationalDatabaseFromSnapshotRequest, CreateRelationalDatabaseFromSnapshotResponse>()
                            .withOperationName("CreateRelationalDatabaseFromSnapshot")
                            .withMarshaller(new CreateRelationalDatabaseFromSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createRelationalDatabaseFromSnapshotRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createRelationalDatabaseFromSnapshotRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<CreateRelationalDatabaseFromSnapshotResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a snapshot of your database in Amazon Lightsail. You can use snapshots for backups, to make copies of a
     * database, and to save data before deleting a database.
     * </p>
     * <p>
     * The <code>create relational database snapshot</code> operation supports tag-based access control via request
     * tags. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param createRelationalDatabaseSnapshotRequest
     * @return A Java Future containing the result of the CreateRelationalDatabaseSnapshot operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.CreateRelationalDatabaseSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateRelationalDatabaseSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateRelationalDatabaseSnapshotResponse> createRelationalDatabaseSnapshot(
            CreateRelationalDatabaseSnapshotRequest createRelationalDatabaseSnapshotRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createRelationalDatabaseSnapshotRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRelationalDatabaseSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateRelationalDatabaseSnapshotResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreateRelationalDatabaseSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateRelationalDatabaseSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateRelationalDatabaseSnapshotRequest, CreateRelationalDatabaseSnapshotResponse>()
                            .withOperationName("CreateRelationalDatabaseSnapshot")
                            .withMarshaller(new CreateRelationalDatabaseSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createRelationalDatabaseSnapshotRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createRelationalDatabaseSnapshotRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<CreateRelationalDatabaseSnapshotResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an alarm.
     * </p>
     * <p>
     * An alarm is used to monitor a single metric for one of your resources. When a metric condition is met, the alarm
     * can notify you by email, SMS text message, and a banner displayed on the Amazon Lightsail console. For more
     * information, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-alarms">Alarms
     * in Amazon Lightsail</a>.
     * </p>
     *
     * @param deleteAlarmRequest
     * @return A Java Future containing the result of the DeleteAlarm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteAlarm
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteAlarm" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAlarmResponse> deleteAlarm(DeleteAlarmRequest deleteAlarmRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAlarmRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAlarm");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAlarmResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteAlarmResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteAlarmResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAlarmRequest, DeleteAlarmResponse>()
                            .withOperationName("DeleteAlarm").withMarshaller(new DeleteAlarmRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteAlarmRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteAlarmRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DeleteAlarmResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an automatic snapshot of an instance or disk. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param deleteAutoSnapshotRequest
     * @return A Java Future containing the result of the DeleteAutoSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteAutoSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteAutoSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAutoSnapshotResponse> deleteAutoSnapshot(DeleteAutoSnapshotRequest deleteAutoSnapshotRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAutoSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAutoSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAutoSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteAutoSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteAutoSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAutoSnapshotRequest, DeleteAutoSnapshotResponse>()
                            .withOperationName("DeleteAutoSnapshot")
                            .withMarshaller(new DeleteAutoSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteAutoSnapshotRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteAutoSnapshotRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DeleteAutoSnapshotResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an SSL/TLS certificate for your Amazon Lightsail content delivery network (CDN) distribution.
     * </p>
     * <p>
     * Certificates that are currently attached to a distribution cannot be deleted. Use the
     * <code>DetachCertificateFromDistribution</code> action to detach a certificate from a distribution.
     * </p>
     *
     * @param deleteCertificateRequest
     * @return A Java Future containing the result of the DeleteCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteCertificate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteCertificate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteCertificateResponse> deleteCertificate(DeleteCertificateRequest deleteCertificateRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteCertificateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteCertificateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteCertificateRequest, DeleteCertificateResponse>()
                            .withOperationName("DeleteCertificate")
                            .withMarshaller(new DeleteCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteCertificateRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteCertificateRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DeleteCertificateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a contact method.
     * </p>
     * <p>
     * A contact method is used to send you notifications about your Amazon Lightsail resources. You can add one email
     * address and one mobile phone number contact method in each AWS Region. However, SMS text messaging is not
     * supported in some AWS Regions, and SMS text messages cannot be sent to some countries/regions. For more
     * information, see <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications">Notifications in
     * Amazon Lightsail</a>.
     * </p>
     *
     * @param deleteContactMethodRequest
     * @return A Java Future containing the result of the DeleteContactMethod operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteContactMethod
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteContactMethod" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteContactMethodResponse> deleteContactMethod(
            DeleteContactMethodRequest deleteContactMethodRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteContactMethodRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteContactMethod");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteContactMethodResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteContactMethodResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteContactMethodResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteContactMethodRequest, DeleteContactMethodResponse>()
                            .withOperationName("DeleteContactMethod")
                            .withMarshaller(new DeleteContactMethodRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteContactMethodRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteContactMethodRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<DeleteContactMethodResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a container image that is registered to your Amazon Lightsail container service.
     * </p>
     *
     * @param deleteContainerImageRequest
     * @return A Java Future containing the result of the DeleteContainerImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteContainerImage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteContainerImage" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteContainerImageResponse> deleteContainerImage(
            DeleteContainerImageRequest deleteContainerImageRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteContainerImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteContainerImage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteContainerImageResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteContainerImageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteContainerImageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteContainerImageRequest, DeleteContainerImageResponse>()
                            .withOperationName("DeleteContainerImage")
                            .withMarshaller(new DeleteContainerImageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteContainerImageRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteContainerImageRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<DeleteContainerImageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes your Amazon Lightsail container service.
     * </p>
     *
     * @param deleteContainerServiceRequest
     * @return A Java Future containing the result of the DeleteContainerService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteContainerService
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteContainerService"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteContainerServiceResponse> deleteContainerService(
            DeleteContainerServiceRequest deleteContainerServiceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteContainerServiceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteContainerService");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteContainerServiceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteContainerServiceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteContainerServiceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteContainerServiceRequest, DeleteContainerServiceResponse>()
                            .withOperationName("DeleteContainerService")
                            .withMarshaller(new DeleteContainerServiceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteContainerServiceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteContainerServiceRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<DeleteContainerServiceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified block storage disk. The disk must be in the <code>available</code> state (not attached to a
     * Lightsail instance).
     * </p>
     * <note>
     * <p>
     * The disk may remain in the <code>deleting</code> state for several minutes.
     * </p>
     * </note>
     * <p>
     * The <code>delete disk</code> operation supports tag-based access control via resource tags applied to the
     * resource identified by <code>disk name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param deleteDiskRequest
     * @return A Java Future containing the result of the DeleteDisk operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteDisk
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDisk" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDiskResponse> deleteDisk(DeleteDiskRequest deleteDiskRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDiskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDisk");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDiskResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteDiskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDiskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDiskRequest, DeleteDiskResponse>().withOperationName("DeleteDisk")
                            .withMarshaller(new DeleteDiskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteDiskRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteDiskRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DeleteDiskResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified disk snapshot.
     * </p>
     * <p>
     * When you make periodic snapshots of a disk, the snapshots are incremental, and only the blocks on the device that
     * have changed since your last snapshot are saved in the new snapshot. When you delete a snapshot, only the data
     * not needed for any other snapshot is removed. So regardless of which prior snapshots have been deleted, all
     * active snapshots will have access to all the information needed to restore the disk.
     * </p>
     * <p>
     * The <code>delete disk snapshot</code> operation supports tag-based access control via resource tags applied to
     * the resource identified by <code>disk snapshot name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param deleteDiskSnapshotRequest
     * @return A Java Future containing the result of the DeleteDiskSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteDiskSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDiskSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDiskSnapshotResponse> deleteDiskSnapshot(DeleteDiskSnapshotRequest deleteDiskSnapshotRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDiskSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDiskSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDiskSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDiskSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDiskSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDiskSnapshotRequest, DeleteDiskSnapshotResponse>()
                            .withOperationName("DeleteDiskSnapshot")
                            .withMarshaller(new DeleteDiskSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteDiskSnapshotRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteDiskSnapshotRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DeleteDiskSnapshotResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes your Amazon Lightsail content delivery network (CDN) distribution.
     * </p>
     *
     * @param deleteDistributionRequest
     * @return A Java Future containing the result of the DeleteDistribution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteDistribution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDistribution" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDistributionResponse> deleteDistribution(DeleteDistributionRequest deleteDistributionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDistributionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDistribution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDistributionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDistributionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDistributionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDistributionRequest, DeleteDistributionResponse>()
                            .withOperationName("DeleteDistribution")
                            .withMarshaller(new DeleteDistributionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteDistributionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteDistributionRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DeleteDistributionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified domain recordset and all of its domain records.
     * </p>
     * <p>
     * The <code>delete domain</code> operation supports tag-based access control via resource tags applied to the
     * resource identified by <code>domain name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param deleteDomainRequest
     * @return A Java Future containing the result of the DeleteDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDomain" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDomainResponse> deleteDomain(DeleteDomainRequest deleteDomainRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDomainRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDomainResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteDomainResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDomainResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDomainRequest, DeleteDomainResponse>()
                            .withOperationName("DeleteDomain").withMarshaller(new DeleteDomainRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteDomainRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteDomainRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DeleteDomainResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a specific domain entry.
     * </p>
     * <p>
     * The <code>delete domain entry</code> operation supports tag-based access control via resource tags applied to the
     * resource identified by <code>domain name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param deleteDomainEntryRequest
     * @return A Java Future containing the result of the DeleteDomainEntry operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteDomainEntry
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDomainEntry" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDomainEntryResponse> deleteDomainEntry(DeleteDomainEntryRequest deleteDomainEntryRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDomainEntryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDomainEntry");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDomainEntryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDomainEntryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDomainEntryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDomainEntryRequest, DeleteDomainEntryResponse>()
                            .withOperationName("DeleteDomainEntry")
                            .withMarshaller(new DeleteDomainEntryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteDomainEntryRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteDomainEntryRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DeleteDomainEntryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an Amazon Lightsail instance.
     * </p>
     * <p>
     * The <code>delete instance</code> operation supports tag-based access control via resource tags applied to the
     * resource identified by <code>instance name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param deleteInstanceRequest
     * @return A Java Future containing the result of the DeleteInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteInstanceResponse> deleteInstance(DeleteInstanceRequest deleteInstanceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteInstance");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteInstanceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteInstanceRequest, DeleteInstanceResponse>()
                            .withOperationName("DeleteInstance")
                            .withMarshaller(new DeleteInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteInstanceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteInstanceRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DeleteInstanceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a specific snapshot of a virtual private server (or <i>instance</i>).
     * </p>
     * <p>
     * The <code>delete instance snapshot</code> operation supports tag-based access control via resource tags applied
     * to the resource identified by <code>instance snapshot name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param deleteInstanceSnapshotRequest
     * @return A Java Future containing the result of the DeleteInstanceSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteInstanceSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteInstanceSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteInstanceSnapshotResponse> deleteInstanceSnapshot(
            DeleteInstanceSnapshotRequest deleteInstanceSnapshotRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteInstanceSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteInstanceSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteInstanceSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteInstanceSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteInstanceSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteInstanceSnapshotRequest, DeleteInstanceSnapshotResponse>()
                            .withOperationName("DeleteInstanceSnapshot")
                            .withMarshaller(new DeleteInstanceSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteInstanceSnapshotRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteInstanceSnapshotRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<DeleteInstanceSnapshotResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a specific SSH key pair.
     * </p>
     * <p>
     * The <code>delete key pair</code> operation supports tag-based access control via resource tags applied to the
     * resource identified by <code>key pair name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param deleteKeyPairRequest
     * @return A Java Future containing the result of the DeleteKeyPair operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteKeyPairResponse> deleteKeyPair(DeleteKeyPairRequest deleteKeyPairRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteKeyPairRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteKeyPair");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteKeyPairResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteKeyPairResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteKeyPairResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteKeyPairRequest, DeleteKeyPairResponse>()
                            .withOperationName("DeleteKeyPair")
                            .withMarshaller(new DeleteKeyPairRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteKeyPairRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteKeyPairRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DeleteKeyPairResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the known host key or certificate used by the Amazon Lightsail browser-based SSH or RDP clients to
     * authenticate an instance. This operation enables the Lightsail browser-based SSH or RDP clients to connect to the
     * instance after a host key mismatch.
     * </p>
     * <important>
     * <p>
     * Perform this operation only if you were expecting the host key or certificate mismatch or if you are familiar
     * with the new host key or certificate on the instance. For more information, see <a href=
     * "https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-troubleshooting-browser-based-ssh-rdp-client-connection"
     * >Troubleshooting connection issues when using the Amazon Lightsail browser-based SSH or RDP client</a>.
     * </p>
     * </important>
     *
     * @param deleteKnownHostKeysRequest
     * @return A Java Future containing the result of the DeleteKnownHostKeys operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteKnownHostKeys
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteKnownHostKeys" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteKnownHostKeysResponse> deleteKnownHostKeys(
            DeleteKnownHostKeysRequest deleteKnownHostKeysRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteKnownHostKeysRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteKnownHostKeys");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteKnownHostKeysResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteKnownHostKeysResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteKnownHostKeysResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteKnownHostKeysRequest, DeleteKnownHostKeysResponse>()
                            .withOperationName("DeleteKnownHostKeys")
                            .withMarshaller(new DeleteKnownHostKeysRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteKnownHostKeysRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteKnownHostKeysRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<DeleteKnownHostKeysResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a Lightsail load balancer and all its associated SSL/TLS certificates. Once the load balancer is deleted,
     * you will need to create a new load balancer, create a new certificate, and verify domain ownership again.
     * </p>
     * <p>
     * The <code>delete load balancer</code> operation supports tag-based access control via resource tags applied to
     * the resource identified by <code>load balancer name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param deleteLoadBalancerRequest
     * @return A Java Future containing the result of the DeleteLoadBalancer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteLoadBalancer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteLoadBalancer" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteLoadBalancerResponse> deleteLoadBalancer(DeleteLoadBalancerRequest deleteLoadBalancerRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteLoadBalancerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteLoadBalancer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteLoadBalancerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteLoadBalancerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteLoadBalancerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteLoadBalancerRequest, DeleteLoadBalancerResponse>()
                            .withOperationName("DeleteLoadBalancer")
                            .withMarshaller(new DeleteLoadBalancerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteLoadBalancerRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteLoadBalancerRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DeleteLoadBalancerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an SSL/TLS certificate associated with a Lightsail load balancer.
     * </p>
     * <p>
     * The <code>DeleteLoadBalancerTlsCertificate</code> operation supports tag-based access control via resource tags
     * applied to the resource identified by <code>load balancer name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param deleteLoadBalancerTlsCertificateRequest
     * @return A Java Future containing the result of the DeleteLoadBalancerTlsCertificate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteLoadBalancerTlsCertificate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteLoadBalancerTlsCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteLoadBalancerTlsCertificateResponse> deleteLoadBalancerTlsCertificate(
            DeleteLoadBalancerTlsCertificateRequest deleteLoadBalancerTlsCertificateRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteLoadBalancerTlsCertificateRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteLoadBalancerTlsCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteLoadBalancerTlsCertificateResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteLoadBalancerTlsCertificateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteLoadBalancerTlsCertificateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteLoadBalancerTlsCertificateRequest, DeleteLoadBalancerTlsCertificateResponse>()
                            .withOperationName("DeleteLoadBalancerTlsCertificate")
                            .withMarshaller(new DeleteLoadBalancerTlsCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteLoadBalancerTlsCertificateRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteLoadBalancerTlsCertificateRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<DeleteLoadBalancerTlsCertificateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a database in Amazon Lightsail.
     * </p>
     * <p>
     * The <code>delete relational database</code> operation supports tag-based access control via resource tags applied
     * to the resource identified by relationalDatabaseName. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param deleteRelationalDatabaseRequest
     * @return A Java Future containing the result of the DeleteRelationalDatabase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteRelationalDatabase
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteRelationalDatabase"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRelationalDatabaseResponse> deleteRelationalDatabase(
            DeleteRelationalDatabaseRequest deleteRelationalDatabaseRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRelationalDatabaseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRelationalDatabase");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteRelationalDatabaseResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteRelationalDatabaseResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteRelationalDatabaseResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRelationalDatabaseRequest, DeleteRelationalDatabaseResponse>()
                            .withOperationName("DeleteRelationalDatabase")
                            .withMarshaller(new DeleteRelationalDatabaseRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteRelationalDatabaseRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteRelationalDatabaseRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DeleteRelationalDatabaseResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a database snapshot in Amazon Lightsail.
     * </p>
     * <p>
     * The <code>delete relational database snapshot</code> operation supports tag-based access control via resource
     * tags applied to the resource identified by relationalDatabaseName. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param deleteRelationalDatabaseSnapshotRequest
     * @return A Java Future containing the result of the DeleteRelationalDatabaseSnapshot operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DeleteRelationalDatabaseSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteRelationalDatabaseSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRelationalDatabaseSnapshotResponse> deleteRelationalDatabaseSnapshot(
            DeleteRelationalDatabaseSnapshotRequest deleteRelationalDatabaseSnapshotRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteRelationalDatabaseSnapshotRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRelationalDatabaseSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteRelationalDatabaseSnapshotResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteRelationalDatabaseSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteRelationalDatabaseSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRelationalDatabaseSnapshotRequest, DeleteRelationalDatabaseSnapshotResponse>()
                            .withOperationName("DeleteRelationalDatabaseSnapshot")
                            .withMarshaller(new DeleteRelationalDatabaseSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteRelationalDatabaseSnapshotRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteRelationalDatabaseSnapshotRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<DeleteRelationalDatabaseSnapshotResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Detaches an SSL/TLS certificate from your Amazon Lightsail content delivery network (CDN) distribution.
     * </p>
     * <p>
     * After the certificate is detached, your distribution stops accepting traffic for all of the domains that are
     * associated with the certificate.
     * </p>
     *
     * @param detachCertificateFromDistributionRequest
     * @return A Java Future containing the result of the DetachCertificateFromDistribution operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DetachCertificateFromDistribution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DetachCertificateFromDistribution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DetachCertificateFromDistributionResponse> detachCertificateFromDistribution(
            DetachCertificateFromDistributionRequest detachCertificateFromDistributionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                detachCertificateFromDistributionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DetachCertificateFromDistribution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DetachCertificateFromDistributionResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DetachCertificateFromDistributionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DetachCertificateFromDistributionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DetachCertificateFromDistributionRequest, DetachCertificateFromDistributionResponse>()
                            .withOperationName("DetachCertificateFromDistribution")
                            .withMarshaller(new DetachCertificateFromDistributionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(detachCertificateFromDistributionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = detachCertificateFromDistributionRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<DetachCertificateFromDistributionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Detaches a stopped block storage disk from a Lightsail instance. Make sure to unmount any file systems on the
     * device within your operating system before stopping the instance and detaching the disk.
     * </p>
     * <p>
     * The <code>detach disk</code> operation supports tag-based access control via resource tags applied to the
     * resource identified by <code>disk name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param detachDiskRequest
     * @return A Java Future containing the result of the DetachDisk operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DetachDisk
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DetachDisk" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DetachDiskResponse> detachDisk(DetachDiskRequest detachDiskRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, detachDiskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DetachDisk");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DetachDiskResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DetachDiskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DetachDiskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DetachDiskRequest, DetachDiskResponse>().withOperationName("DetachDisk")
                            .withMarshaller(new DetachDiskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(detachDiskRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = detachDiskRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DetachDiskResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Detaches the specified instances from a Lightsail load balancer.
     * </p>
     * <p>
     * This operation waits until the instances are no longer needed before they are detached from the load balancer.
     * </p>
     * <p>
     * The <code>detach instances from load balancer</code> operation supports tag-based access control via resource
     * tags applied to the resource identified by <code>load balancer name</code>. For more information, see the <a
     * href=
     * "https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags">Lightsail
     * Dev Guide</a>.
     * </p>
     *
     * @param detachInstancesFromLoadBalancerRequest
     * @return A Java Future containing the result of the DetachInstancesFromLoadBalancer operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DetachInstancesFromLoadBalancer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DetachInstancesFromLoadBalancer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DetachInstancesFromLoadBalancerResponse> detachInstancesFromLoadBalancer(
            DetachInstancesFromLoadBalancerRequest detachInstancesFromLoadBalancerRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                detachInstancesFromLoadBalancerRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DetachInstancesFromLoadBalancer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DetachInstancesFromLoadBalancerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DetachInstancesFromLoadBalancerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DetachInstancesFromLoadBalancerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DetachInstancesFromLoadBalancerRequest, DetachInstancesFromLoadBalancerResponse>()
                            .withOperationName("DetachInstancesFromLoadBalancer")
                            .withMarshaller(new DetachInstancesFromLoadBalancerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(detachInstancesFromLoadBalancerRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = detachInstancesFromLoadBalancerRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<DetachInstancesFromLoadBalancerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Detaches a static IP from the Amazon Lightsail instance to which it is attached.
     * </p>
     *
     * @param detachStaticIpRequest
     * @return A Java Future containing the result of the DetachStaticIp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DetachStaticIp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DetachStaticIp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DetachStaticIpResponse> detachStaticIp(DetachStaticIpRequest detachStaticIpRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, detachStaticIpRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DetachStaticIp");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DetachStaticIpResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DetachStaticIpResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DetachStaticIpResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DetachStaticIpRequest, DetachStaticIpResponse>()
                            .withOperationName("DetachStaticIp")
                            .withMarshaller(new DetachStaticIpRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(detachStaticIpRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = detachStaticIpRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DetachStaticIpResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disables an add-on for an Amazon Lightsail resource. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param disableAddOnRequest
     * @return A Java Future containing the result of the DisableAddOn operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DisableAddOn
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DisableAddOn" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DisableAddOnResponse> disableAddOn(DisableAddOnRequest disableAddOnRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disableAddOnRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisableAddOn");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisableAddOnResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DisableAddOnResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisableAddOnResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisableAddOnRequest, DisableAddOnResponse>()
                            .withOperationName("DisableAddOn").withMarshaller(new DisableAddOnRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(disableAddOnRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = disableAddOnRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DisableAddOnResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Downloads the default SSH key pair from the user's account.
     * </p>
     *
     * @param downloadDefaultKeyPairRequest
     * @return A Java Future containing the result of the DownloadDefaultKeyPair operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.DownloadDefaultKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DownloadDefaultKeyPair"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DownloadDefaultKeyPairResponse> downloadDefaultKeyPair(
            DownloadDefaultKeyPairRequest downloadDefaultKeyPairRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, downloadDefaultKeyPairRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DownloadDefaultKeyPair");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DownloadDefaultKeyPairResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DownloadDefaultKeyPairResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DownloadDefaultKeyPairResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DownloadDefaultKeyPairRequest, DownloadDefaultKeyPairResponse>()
                            .withOperationName("DownloadDefaultKeyPair")
                            .withMarshaller(new DownloadDefaultKeyPairRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(downloadDefaultKeyPairRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = downloadDefaultKeyPairRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<DownloadDefaultKeyPairResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables or modifies an add-on for an Amazon Lightsail resource. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param enableAddOnRequest
     * @return A Java Future containing the result of the EnableAddOn operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.EnableAddOn
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/EnableAddOn" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<EnableAddOnResponse> enableAddOn(EnableAddOnRequest enableAddOnRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, enableAddOnRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "EnableAddOn");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<EnableAddOnResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    EnableAddOnResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<EnableAddOnResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<EnableAddOnRequest, EnableAddOnResponse>()
                            .withOperationName("EnableAddOn").withMarshaller(new EnableAddOnRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(enableAddOnRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = enableAddOnRequest.overrideConfiguration().orElse(null);
            CompletableFuture<EnableAddOnResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Exports an Amazon Lightsail instance or block storage disk snapshot to Amazon Elastic Compute Cloud (Amazon EC2).
     * This operation results in an export snapshot record that can be used with the
     * <code>create cloud formation stack</code> operation to create new Amazon EC2 instances.
     * </p>
     * <p>
     * Exported instance snapshots appear in Amazon EC2 as Amazon Machine Images (AMIs), and the instance system disk
     * appears as an Amazon Elastic Block Store (Amazon EBS) volume. Exported disk snapshots appear in Amazon EC2 as
     * Amazon EBS volumes. Snapshots are exported to the same Amazon Web Services Region in Amazon EC2 as the source
     * Lightsail snapshot.
     * </p>
     * <p/>
     * <p>
     * The <code>export snapshot</code> operation supports tag-based access control via resource tags applied to the
     * resource identified by <code>source snapshot name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     * <note>
     * <p>
     * Use the <code>get instance snapshots</code> or <code>get disk snapshots</code> operations to get a list of
     * snapshots that you can export to Amazon EC2.
     * </p>
     * </note>
     *
     * @param exportSnapshotRequest
     * @return A Java Future containing the result of the ExportSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.ExportSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/ExportSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ExportSnapshotResponse> exportSnapshot(ExportSnapshotRequest exportSnapshotRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, exportSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ExportSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ExportSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ExportSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ExportSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ExportSnapshotRequest, ExportSnapshotResponse>()
                            .withOperationName("ExportSnapshot")
                            .withMarshaller(new ExportSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(exportSnapshotRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = exportSnapshotRequest.overrideConfiguration().orElse(null);
            CompletableFuture<ExportSnapshotResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the names of all active (not deleted) resources.
     * </p>
     *
     * @param getActiveNamesRequest
     * @return A Java Future containing the result of the GetActiveNames operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetActiveNames
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetActiveNames" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetActiveNamesResponse> getActiveNames(GetActiveNamesRequest getActiveNamesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getActiveNamesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetActiveNames");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetActiveNamesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetActiveNamesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetActiveNamesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetActiveNamesRequest, GetActiveNamesResponse>()
                            .withOperationName("GetActiveNames")
                            .withMarshaller(new GetActiveNamesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getActiveNamesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getActiveNamesRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetActiveNamesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the configured alarms. Specify an alarm name in your request to return information
     * about a specific alarm, or specify a monitored resource name to return information about all alarms for a
     * specific resource.
     * </p>
     * <p>
     * An alarm is used to monitor a single metric for one of your resources. When a metric condition is met, the alarm
     * can notify you by email, SMS text message, and a banner displayed on the Amazon Lightsail console. For more
     * information, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-alarms">Alarms
     * in Amazon Lightsail</a>.
     * </p>
     *
     * @param getAlarmsRequest
     * @return A Java Future containing the result of the GetAlarms operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetAlarms
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetAlarms" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetAlarmsResponse> getAlarms(GetAlarmsRequest getAlarmsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAlarmsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAlarms");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAlarmsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetAlarmsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetAlarmsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAlarmsRequest, GetAlarmsResponse>().withOperationName("GetAlarms")
                            .withMarshaller(new GetAlarmsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getAlarmsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getAlarmsRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetAlarmsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the available automatic snapshots for an instance or disk. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param getAutoSnapshotsRequest
     * @return A Java Future containing the result of the GetAutoSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetAutoSnapshots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetAutoSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetAutoSnapshotsResponse> getAutoSnapshots(GetAutoSnapshotsRequest getAutoSnapshotsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAutoSnapshotsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAutoSnapshots");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAutoSnapshotsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetAutoSnapshotsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetAutoSnapshotsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAutoSnapshotsRequest, GetAutoSnapshotsResponse>()
                            .withOperationName("GetAutoSnapshots")
                            .withMarshaller(new GetAutoSnapshotsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getAutoSnapshotsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getAutoSnapshotsRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetAutoSnapshotsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the list of available instance images, or <i>blueprints</i>. You can use a blueprint to create a new
     * instance already running a specific operating system, as well as a preinstalled app or development stack. The
     * software each instance is running depends on the blueprint image you choose.
     * </p>
     * <note>
     * <p>
     * Use active blueprints when creating new instances. Inactive blueprints are listed to support customers with
     * existing instances and are not necessarily available to create new instances. Blueprints are marked inactive when
     * they become outdated due to operating system updates or new application releases.
     * </p>
     * </note>
     *
     * @param getBlueprintsRequest
     * @return A Java Future containing the result of the GetBlueprints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetBlueprints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetBlueprints" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetBlueprintsResponse> getBlueprints(GetBlueprintsRequest getBlueprintsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBlueprintsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBlueprints");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetBlueprintsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetBlueprintsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetBlueprintsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetBlueprintsRequest, GetBlueprintsResponse>()
                            .withOperationName("GetBlueprints")
                            .withMarshaller(new GetBlueprintsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getBlueprintsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getBlueprintsRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetBlueprintsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the list of bundles that are available for purchase. A bundle describes the specs for your virtual
     * private server (or <i>instance</i>).
     * </p>
     *
     * @param getBundlesRequest
     * @return A Java Future containing the result of the GetBundles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetBundles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetBundles" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetBundlesResponse> getBundles(GetBundlesRequest getBundlesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBundlesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBundles");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetBundlesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetBundlesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetBundlesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetBundlesRequest, GetBundlesResponse>().withOperationName("GetBundles")
                            .withMarshaller(new GetBundlesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getBundlesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getBundlesRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetBundlesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about one or more Amazon Lightsail SSL/TLS certificates.
     * </p>
     * <note>
     * <p>
     * To get a summary of a certificate, ommit <code>includeCertificateDetails</code> from your request. The response
     * will include only the certificate Amazon Resource Name (ARN), certificate name, domain name, and tags.
     * </p>
     * </note>
     *
     * @param getCertificatesRequest
     * @return A Java Future containing the result of the GetCertificates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetCertificates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetCertificatesResponse> getCertificates(GetCertificatesRequest getCertificatesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCertificatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCertificates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCertificatesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetCertificatesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCertificatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCertificatesRequest, GetCertificatesResponse>()
                            .withOperationName("GetCertificates")
                            .withMarshaller(new GetCertificatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getCertificatesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getCertificatesRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetCertificatesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the CloudFormation stack record created as a result of the <code>create cloud formation stack</code>
     * operation.
     * </p>
     * <p>
     * An AWS CloudFormation stack is used to create a new Amazon EC2 instance from an exported Lightsail snapshot.
     * </p>
     *
     * @param getCloudFormationStackRecordsRequest
     * @return A Java Future containing the result of the GetCloudFormationStackRecords operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetCloudFormationStackRecords
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetCloudFormationStackRecords"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetCloudFormationStackRecordsResponse> getCloudFormationStackRecords(
            GetCloudFormationStackRecordsRequest getCloudFormationStackRecordsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getCloudFormationStackRecordsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCloudFormationStackRecords");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCloudFormationStackRecordsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetCloudFormationStackRecordsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCloudFormationStackRecordsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCloudFormationStackRecordsRequest, GetCloudFormationStackRecordsResponse>()
                            .withOperationName("GetCloudFormationStackRecords")
                            .withMarshaller(new GetCloudFormationStackRecordsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getCloudFormationStackRecordsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getCloudFormationStackRecordsRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<GetCloudFormationStackRecordsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the configured contact methods. Specify a protocol in your request to return
     * information about a specific contact method.
     * </p>
     * <p>
     * A contact method is used to send you notifications about your Amazon Lightsail resources. You can add one email
     * address and one mobile phone number contact method in each AWS Region. However, SMS text messaging is not
     * supported in some AWS Regions, and SMS text messages cannot be sent to some countries/regions. For more
     * information, see <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications">Notifications in
     * Amazon Lightsail</a>.
     * </p>
     *
     * @param getContactMethodsRequest
     * @return A Java Future containing the result of the GetContactMethods operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetContactMethods
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetContactMethods" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetContactMethodsResponse> getContactMethods(GetContactMethodsRequest getContactMethodsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getContactMethodsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetContactMethods");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetContactMethodsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetContactMethodsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetContactMethodsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetContactMethodsRequest, GetContactMethodsResponse>()
                            .withOperationName("GetContactMethods")
                            .withMarshaller(new GetContactMethodsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getContactMethodsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getContactMethodsRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetContactMethodsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about Amazon Lightsail containers, such as the current version of the Lightsail Control
     * (lightsailctl) plugin.
     * </p>
     *
     * @param getContainerApiMetadataRequest
     * @return A Java Future containing the result of the GetContainerAPIMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetContainerAPIMetadata
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetContainerAPIMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetContainerApiMetadataResponse> getContainerAPIMetadata(
            GetContainerApiMetadataRequest getContainerApiMetadataRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getContainerApiMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetContainerAPIMetadata");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetContainerApiMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetContainerApiMetadataResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetContainerApiMetadataResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetContainerApiMetadataRequest, GetContainerApiMetadataResponse>()
                            .withOperationName("GetContainerAPIMetadata")
                            .withMarshaller(new GetContainerApiMetadataRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getContainerApiMetadataRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getContainerApiMetadataRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<GetContainerApiMetadataResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the container images that are registered to your Amazon Lightsail container service.
     * </p>
     * <note>
     * <p>
     * If you created a deployment on your Lightsail container service that uses container images from a public registry
     * like Docker Hub, those images are not returned as part of this action. Those images are not registered to your
     * Lightsail container service.
     * </p>
     * </note>
     *
     * @param getContainerImagesRequest
     * @return A Java Future containing the result of the GetContainerImages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetContainerImages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetContainerImages" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetContainerImagesResponse> getContainerImages(GetContainerImagesRequest getContainerImagesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getContainerImagesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetContainerImages");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetContainerImagesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetContainerImagesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetContainerImagesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetContainerImagesRequest, GetContainerImagesResponse>()
                            .withOperationName("GetContainerImages")
                            .withMarshaller(new GetContainerImagesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getContainerImagesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getContainerImagesRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<GetContainerImagesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the log events of a container of your Amazon Lightsail container service.
     * </p>
     * <p>
     * If your container service has more than one node (i.e., a scale greater than 1), then the log events that are
     * returned for the specified container are merged from all nodes on your container service.
     * </p>
     * <note>
     * <p>
     * Container logs are retained for a certain amount of time. For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/lightsail.html">Amazon Lightsail endpoints and quotas</a> in
     * the <i>AWS General Reference</i>.
     * </p>
     * </note>
     *
     * @param getContainerLogRequest
     * @return A Java Future containing the result of the GetContainerLog operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetContainerLog
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetContainerLog" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetContainerLogResponse> getContainerLog(GetContainerLogRequest getContainerLogRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getContainerLogRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetContainerLog");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetContainerLogResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetContainerLogResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetContainerLogResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetContainerLogRequest, GetContainerLogResponse>()
                            .withOperationName("GetContainerLog")
                            .withMarshaller(new GetContainerLogRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getContainerLogRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getContainerLogRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetContainerLogResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the deployments for your Amazon Lightsail container service
     * </p>
     * <p>
     * A deployment specifies the settings, such as the ports and launch command, of containers that are deployed to
     * your container service.
     * </p>
     * <p>
     * The deployments are ordered by version in ascending order. The newest version is listed at the top of the
     * response.
     * </p>
     * <note>
     * <p>
     * A set number of deployments are kept before the oldest one is replaced with the newest one. For more information,
     * see <a href="https://docs.aws.amazon.com/general/latest/gr/lightsail.html">Amazon Lightsail endpoints and
     * quotas</a> in the <i>AWS General Reference</i>.
     * </p>
     * </note>
     *
     * @param getContainerServiceDeploymentsRequest
     * @return A Java Future containing the result of the GetContainerServiceDeployments operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetContainerServiceDeployments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetContainerServiceDeployments"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetContainerServiceDeploymentsResponse> getContainerServiceDeployments(
            GetContainerServiceDeploymentsRequest getContainerServiceDeploymentsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getContainerServiceDeploymentsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetContainerServiceDeployments");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetContainerServiceDeploymentsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetContainerServiceDeploymentsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetContainerServiceDeploymentsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetContainerServiceDeploymentsRequest, GetContainerServiceDeploymentsResponse>()
                            .withOperationName("GetContainerServiceDeployments")
                            .withMarshaller(new GetContainerServiceDeploymentsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getContainerServiceDeploymentsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getContainerServiceDeploymentsRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<GetContainerServiceDeploymentsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the data points of a specific metric of your Amazon Lightsail container service.
     * </p>
     * <p>
     * Metrics report the utilization of your resources. Monitor and collect metric data regularly to maintain the
     * reliability, availability, and performance of your resources.
     * </p>
     *
     * @param getContainerServiceMetricDataRequest
     * @return A Java Future containing the result of the GetContainerServiceMetricData operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetContainerServiceMetricData
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetContainerServiceMetricData"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetContainerServiceMetricDataResponse> getContainerServiceMetricData(
            GetContainerServiceMetricDataRequest getContainerServiceMetricDataRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getContainerServiceMetricDataRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetContainerServiceMetricData");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetContainerServiceMetricDataResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetContainerServiceMetricDataResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetContainerServiceMetricDataResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetContainerServiceMetricDataRequest, GetContainerServiceMetricDataResponse>()
                            .withOperationName("GetContainerServiceMetricData")
                            .withMarshaller(new GetContainerServiceMetricDataRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getContainerServiceMetricDataRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getContainerServiceMetricDataRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<GetContainerServiceMetricDataResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the list of powers that can be specified for your Amazon Lightsail container services.
     * </p>
     * <p>
     * The power specifies the amount of memory, the number of vCPUs, and the base price of the container service.
     * </p>
     *
     * @param getContainerServicePowersRequest
     * @return A Java Future containing the result of the GetContainerServicePowers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetContainerServicePowers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetContainerServicePowers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetContainerServicePowersResponse> getContainerServicePowers(
            GetContainerServicePowersRequest getContainerServicePowersRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getContainerServicePowersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetContainerServicePowers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetContainerServicePowersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetContainerServicePowersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetContainerServicePowersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetContainerServicePowersRequest, GetContainerServicePowersResponse>()
                            .withOperationName("GetContainerServicePowers")
                            .withMarshaller(new GetContainerServicePowersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getContainerServicePowersRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getContainerServicePowersRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<GetContainerServicePowersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about one or more of your Amazon Lightsail container services.
     * </p>
     *
     * @param getContainerServicesRequest
     * @return A Java Future containing the result of the GetContainerServices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetContainerServices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetContainerServices" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetContainerServicesResponse> getContainerServices(
            GetContainerServicesRequest getContainerServicesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getContainerServicesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetContainerServices");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetContainerServicesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetContainerServicesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetContainerServicesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetContainerServicesRequest, GetContainerServicesResponse>()
                            .withOperationName("GetContainerServices")
                            .withMarshaller(new GetContainerServicesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getContainerServicesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getContainerServicesRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<GetContainerServicesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a specific block storage disk.
     * </p>
     *
     * @param getDiskRequest
     * @return A Java Future containing the result of the GetDisk operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetDisk
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDisk" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetDiskResponse> getDisk(GetDiskRequest getDiskRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDiskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDisk");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDiskResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetDiskResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDiskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDiskRequest, GetDiskResponse>().withOperationName("GetDisk")
                            .withMarshaller(new GetDiskRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getDiskRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getDiskRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetDiskResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a specific block storage disk snapshot.
     * </p>
     *
     * @param getDiskSnapshotRequest
     * @return A Java Future containing the result of the GetDiskSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetDiskSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDiskSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetDiskSnapshotResponse> getDiskSnapshot(GetDiskSnapshotRequest getDiskSnapshotRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDiskSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDiskSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDiskSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDiskSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDiskSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDiskSnapshotRequest, GetDiskSnapshotResponse>()
                            .withOperationName("GetDiskSnapshot")
                            .withMarshaller(new GetDiskSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getDiskSnapshotRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getDiskSnapshotRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetDiskSnapshotResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about all block storage disk snapshots in your AWS account and region.
     * </p>
     *
     * @param getDiskSnapshotsRequest
     * @return A Java Future containing the result of the GetDiskSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetDiskSnapshots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDiskSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetDiskSnapshotsResponse> getDiskSnapshots(GetDiskSnapshotsRequest getDiskSnapshotsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDiskSnapshotsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDiskSnapshots");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDiskSnapshotsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDiskSnapshotsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDiskSnapshotsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDiskSnapshotsRequest, GetDiskSnapshotsResponse>()
                            .withOperationName("GetDiskSnapshots")
                            .withMarshaller(new GetDiskSnapshotsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getDiskSnapshotsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getDiskSnapshotsRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetDiskSnapshotsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about all block storage disks in your AWS account and region.
     * </p>
     *
     * @param getDisksRequest
     * @return A Java Future containing the result of the GetDisks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetDisks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDisks" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetDisksResponse> getDisks(GetDisksRequest getDisksRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDisksRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDisks");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDisksResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetDisksResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDisksResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDisksRequest, GetDisksResponse>().withOperationName("GetDisks")
                            .withMarshaller(new GetDisksRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getDisksRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getDisksRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetDisksResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the list bundles that can be applied to you Amazon Lightsail content delivery network (CDN)
     * distributions.
     * </p>
     * <p>
     * A distribution bundle specifies the monthly network transfer quota and monthly cost of your dsitribution.
     * </p>
     *
     * @param getDistributionBundlesRequest
     * @return A Java Future containing the result of the GetDistributionBundles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetDistributionBundles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDistributionBundles"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetDistributionBundlesResponse> getDistributionBundles(
            GetDistributionBundlesRequest getDistributionBundlesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDistributionBundlesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDistributionBundles");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDistributionBundlesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDistributionBundlesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDistributionBundlesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDistributionBundlesRequest, GetDistributionBundlesResponse>()
                            .withOperationName("GetDistributionBundles")
                            .withMarshaller(new GetDistributionBundlesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getDistributionBundlesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getDistributionBundlesRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<GetDistributionBundlesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the timestamp and status of the last cache reset of a specific Amazon Lightsail content delivery network
     * (CDN) distribution.
     * </p>
     *
     * @param getDistributionLatestCacheResetRequest
     * @return A Java Future containing the result of the GetDistributionLatestCacheReset operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetDistributionLatestCacheReset
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDistributionLatestCacheReset"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetDistributionLatestCacheResetResponse> getDistributionLatestCacheReset(
            GetDistributionLatestCacheResetRequest getDistributionLatestCacheResetRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getDistributionLatestCacheResetRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDistributionLatestCacheReset");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDistributionLatestCacheResetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDistributionLatestCacheResetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDistributionLatestCacheResetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDistributionLatestCacheResetRequest, GetDistributionLatestCacheResetResponse>()
                            .withOperationName("GetDistributionLatestCacheReset")
                            .withMarshaller(new GetDistributionLatestCacheResetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getDistributionLatestCacheResetRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getDistributionLatestCacheResetRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<GetDistributionLatestCacheResetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the data points of a specific metric for an Amazon Lightsail content delivery network (CDN) distribution.
     * </p>
     * <p>
     * Metrics report the utilization of your resources, and the error counts generated by them. Monitor and collect
     * metric data regularly to maintain the reliability, availability, and performance of your resources.
     * </p>
     *
     * @param getDistributionMetricDataRequest
     * @return A Java Future containing the result of the GetDistributionMetricData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetDistributionMetricData
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDistributionMetricData"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetDistributionMetricDataResponse> getDistributionMetricData(
            GetDistributionMetricDataRequest getDistributionMetricDataRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDistributionMetricDataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDistributionMetricData");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDistributionMetricDataResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDistributionMetricDataResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDistributionMetricDataResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDistributionMetricDataRequest, GetDistributionMetricDataResponse>()
                            .withOperationName("GetDistributionMetricData")
                            .withMarshaller(new GetDistributionMetricDataRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getDistributionMetricDataRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getDistributionMetricDataRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<GetDistributionMetricDataResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about one or more of your Amazon Lightsail content delivery network (CDN) distributions.
     * </p>
     *
     * @param getDistributionsRequest
     * @return A Java Future containing the result of the GetDistributions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetDistributions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDistributions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetDistributionsResponse> getDistributions(GetDistributionsRequest getDistributionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDistributionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDistributions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDistributionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDistributionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDistributionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDistributionsRequest, GetDistributionsResponse>()
                            .withOperationName("GetDistributions")
                            .withMarshaller(new GetDistributionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getDistributionsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getDistributionsRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetDistributionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a specific domain recordset.
     * </p>
     *
     * @param getDomainRequest
     * @return A Java Future containing the result of the GetDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetDomain
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDomain" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetDomainResponse> getDomain(GetDomainRequest getDomainRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDomainRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDomainResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetDomainResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDomainResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDomainRequest, GetDomainResponse>().withOperationName("GetDomain")
                            .withMarshaller(new GetDomainRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getDomainRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getDomainRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetDomainResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of all domains in the user's account.
     * </p>
     *
     * @param getDomainsRequest
     * @return A Java Future containing the result of the GetDomains operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetDomains
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDomains" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetDomainsResponse> getDomains(GetDomainsRequest getDomainsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDomainsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDomains");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDomainsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetDomainsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDomainsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDomainsRequest, GetDomainsResponse>().withOperationName("GetDomains")
                            .withMarshaller(new GetDomainsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getDomainsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getDomainsRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetDomainsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the export snapshot record created as a result of the <code>export snapshot</code> operation.
     * </p>
     * <p>
     * An export snapshot record can be used to create a new Amazon EC2 instance and its related resources with the
     * <code>create cloud formation stack</code> operation.
     * </p>
     *
     * @param getExportSnapshotRecordsRequest
     * @return A Java Future containing the result of the GetExportSnapshotRecords operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetExportSnapshotRecords
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetExportSnapshotRecords"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetExportSnapshotRecordsResponse> getExportSnapshotRecords(
            GetExportSnapshotRecordsRequest getExportSnapshotRecordsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getExportSnapshotRecordsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetExportSnapshotRecords");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetExportSnapshotRecordsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetExportSnapshotRecordsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetExportSnapshotRecordsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetExportSnapshotRecordsRequest, GetExportSnapshotRecordsResponse>()
                            .withOperationName("GetExportSnapshotRecords")
                            .withMarshaller(new GetExportSnapshotRecordsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getExportSnapshotRecordsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getExportSnapshotRecordsRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<GetExportSnapshotRecordsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a specific Amazon Lightsail instance, which is a virtual private server.
     * </p>
     *
     * @param getInstanceRequest
     * @return A Java Future containing the result of the GetInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetInstanceResponse> getInstance(GetInstanceRequest getInstanceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetInstance");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetInstanceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetInstanceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetInstanceRequest, GetInstanceResponse>()
                            .withOperationName("GetInstance").withMarshaller(new GetInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getInstanceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getInstanceRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetInstanceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns temporary SSH keys you can use to connect to a specific virtual private server, or <i>instance</i>.
     * </p>
     * <p>
     * The <code>get instance access details</code> operation supports tag-based access control via resource tags
     * applied to the resource identified by <code>instance name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param getInstanceAccessDetailsRequest
     * @return A Java Future containing the result of the GetInstanceAccessDetails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetInstanceAccessDetails
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceAccessDetails"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetInstanceAccessDetailsResponse> getInstanceAccessDetails(
            GetInstanceAccessDetailsRequest getInstanceAccessDetailsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getInstanceAccessDetailsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetInstanceAccessDetails");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetInstanceAccessDetailsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetInstanceAccessDetailsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetInstanceAccessDetailsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetInstanceAccessDetailsRequest, GetInstanceAccessDetailsResponse>()
                            .withOperationName("GetInstanceAccessDetails")
                            .withMarshaller(new GetInstanceAccessDetailsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getInstanceAccessDetailsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getInstanceAccessDetailsRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<GetInstanceAccessDetailsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the data points for the specified Amazon Lightsail instance metric, given an instance name.
     * </p>
     * <p>
     * Metrics report the utilization of your resources, and the error counts generated by them. Monitor and collect
     * metric data regularly to maintain the reliability, availability, and performance of your resources.
     * </p>
     *
     * @param getInstanceMetricDataRequest
     * @return A Java Future containing the result of the GetInstanceMetricData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetInstanceMetricData
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceMetricData"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetInstanceMetricDataResponse> getInstanceMetricData(
            GetInstanceMetricDataRequest getInstanceMetricDataRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getInstanceMetricDataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetInstanceMetricData");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetInstanceMetricDataResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetInstanceMetricDataResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetInstanceMetricDataResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetInstanceMetricDataRequest, GetInstanceMetricDataResponse>()
                            .withOperationName("GetInstanceMetricData")
                            .withMarshaller(new GetInstanceMetricDataRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getInstanceMetricDataRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getInstanceMetricDataRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<GetInstanceMetricDataResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the firewall port states for a specific Amazon Lightsail instance, the IP addresses allowed to connect to
     * the instance through the ports, and the protocol.
     * </p>
     *
     * @param getInstancePortStatesRequest
     * @return A Java Future containing the result of the GetInstancePortStates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetInstancePortStates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstancePortStates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetInstancePortStatesResponse> getInstancePortStates(
            GetInstancePortStatesRequest getInstancePortStatesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getInstancePortStatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetInstancePortStates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetInstancePortStatesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetInstancePortStatesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetInstancePortStatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetInstancePortStatesRequest, GetInstancePortStatesResponse>()
                            .withOperationName("GetInstancePortStates")
                            .withMarshaller(new GetInstancePortStatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getInstancePortStatesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getInstancePortStatesRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<GetInstancePortStatesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a specific instance snapshot.
     * </p>
     *
     * @param getInstanceSnapshotRequest
     * @return A Java Future containing the result of the GetInstanceSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetInstanceSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetInstanceSnapshotResponse> getInstanceSnapshot(
            GetInstanceSnapshotRequest getInstanceSnapshotRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getInstanceSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetInstanceSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetInstanceSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetInstanceSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetInstanceSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetInstanceSnapshotRequest, GetInstanceSnapshotResponse>()
                            .withOperationName("GetInstanceSnapshot")
                            .withMarshaller(new GetInstanceSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getInstanceSnapshotRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getInstanceSnapshotRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<GetInstanceSnapshotResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns all instance snapshots for the user's account.
     * </p>
     *
     * @param getInstanceSnapshotsRequest
     * @return A Java Future containing the result of the GetInstanceSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetInstanceSnapshots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceSnapshots" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetInstanceSnapshotsResponse> getInstanceSnapshots(
            GetInstanceSnapshotsRequest getInstanceSnapshotsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getInstanceSnapshotsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetInstanceSnapshots");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetInstanceSnapshotsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetInstanceSnapshotsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetInstanceSnapshotsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetInstanceSnapshotsRequest, GetInstanceSnapshotsResponse>()
                            .withOperationName("GetInstanceSnapshots")
                            .withMarshaller(new GetInstanceSnapshotsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getInstanceSnapshotsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getInstanceSnapshotsRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<GetInstanceSnapshotsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the state of a specific instance. Works on one instance at a time.
     * </p>
     *
     * @param getInstanceStateRequest
     * @return A Java Future containing the result of the GetInstanceState operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetInstanceState
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceState" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetInstanceStateResponse> getInstanceState(GetInstanceStateRequest getInstanceStateRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getInstanceStateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetInstanceState");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetInstanceStateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetInstanceStateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetInstanceStateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetInstanceStateRequest, GetInstanceStateResponse>()
                            .withOperationName("GetInstanceState")
                            .withMarshaller(new GetInstanceStateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getInstanceStateRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getInstanceStateRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetInstanceStateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about all Amazon Lightsail virtual private servers, or <i>instances</i>.
     * </p>
     *
     * @param getInstancesRequest
     * @return A Java Future containing the result of the GetInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstances" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetInstancesResponse> getInstances(GetInstancesRequest getInstancesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getInstancesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetInstances");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetInstancesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetInstancesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetInstancesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetInstancesRequest, GetInstancesResponse>()
                            .withOperationName("GetInstances").withMarshaller(new GetInstancesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getInstancesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getInstancesRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetInstancesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a specific key pair.
     * </p>
     *
     * @param getKeyPairRequest
     * @return A Java Future containing the result of the GetKeyPair operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetKeyPairResponse> getKeyPair(GetKeyPairRequest getKeyPairRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getKeyPairRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetKeyPair");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetKeyPairResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetKeyPairResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetKeyPairResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetKeyPairRequest, GetKeyPairResponse>().withOperationName("GetKeyPair")
                            .withMarshaller(new GetKeyPairRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getKeyPairRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getKeyPairRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetKeyPairResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about all key pairs in the user's account.
     * </p>
     *
     * @param getKeyPairsRequest
     * @return A Java Future containing the result of the GetKeyPairs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetKeyPairs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetKeyPairs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetKeyPairsResponse> getKeyPairs(GetKeyPairsRequest getKeyPairsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getKeyPairsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetKeyPairs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetKeyPairsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetKeyPairsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetKeyPairsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetKeyPairsRequest, GetKeyPairsResponse>()
                            .withOperationName("GetKeyPairs").withMarshaller(new GetKeyPairsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getKeyPairsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getKeyPairsRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetKeyPairsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the specified Lightsail load balancer.
     * </p>
     *
     * @param getLoadBalancerRequest
     * @return A Java Future containing the result of the GetLoadBalancer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetLoadBalancer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetLoadBalancer" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetLoadBalancerResponse> getLoadBalancer(GetLoadBalancerRequest getLoadBalancerRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getLoadBalancerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLoadBalancer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetLoadBalancerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetLoadBalancerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetLoadBalancerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetLoadBalancerRequest, GetLoadBalancerResponse>()
                            .withOperationName("GetLoadBalancer")
                            .withMarshaller(new GetLoadBalancerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getLoadBalancerRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getLoadBalancerRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetLoadBalancerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about health metrics for your Lightsail load balancer.
     * </p>
     * <p>
     * Metrics report the utilization of your resources, and the error counts generated by them. Monitor and collect
     * metric data regularly to maintain the reliability, availability, and performance of your resources.
     * </p>
     *
     * @param getLoadBalancerMetricDataRequest
     * @return A Java Future containing the result of the GetLoadBalancerMetricData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetLoadBalancerMetricData
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetLoadBalancerMetricData"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetLoadBalancerMetricDataResponse> getLoadBalancerMetricData(
            GetLoadBalancerMetricDataRequest getLoadBalancerMetricDataRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getLoadBalancerMetricDataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLoadBalancerMetricData");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetLoadBalancerMetricDataResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetLoadBalancerMetricDataResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetLoadBalancerMetricDataResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetLoadBalancerMetricDataRequest, GetLoadBalancerMetricDataResponse>()
                            .withOperationName("GetLoadBalancerMetricData")
                            .withMarshaller(new GetLoadBalancerMetricDataRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getLoadBalancerMetricDataRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getLoadBalancerMetricDataRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<GetLoadBalancerMetricDataResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the TLS certificates that are associated with the specified Lightsail load balancer.
     * </p>
     * <p>
     * TLS is just an updated, more secure version of Secure Socket Layer (SSL).
     * </p>
     * <p>
     * You can have a maximum of 2 certificates associated with a Lightsail load balancer. One is active and the other
     * is inactive.
     * </p>
     *
     * @param getLoadBalancerTlsCertificatesRequest
     * @return A Java Future containing the result of the GetLoadBalancerTlsCertificates operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetLoadBalancerTlsCertificates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetLoadBalancerTlsCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetLoadBalancerTlsCertificatesResponse> getLoadBalancerTlsCertificates(
            GetLoadBalancerTlsCertificatesRequest getLoadBalancerTlsCertificatesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getLoadBalancerTlsCertificatesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLoadBalancerTlsCertificates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetLoadBalancerTlsCertificatesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetLoadBalancerTlsCertificatesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetLoadBalancerTlsCertificatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetLoadBalancerTlsCertificatesRequest, GetLoadBalancerTlsCertificatesResponse>()
                            .withOperationName("GetLoadBalancerTlsCertificates")
                            .withMarshaller(new GetLoadBalancerTlsCertificatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getLoadBalancerTlsCertificatesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getLoadBalancerTlsCertificatesRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<GetLoadBalancerTlsCertificatesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about all load balancers in an account.
     * </p>
     *
     * @param getLoadBalancersRequest
     * @return A Java Future containing the result of the GetLoadBalancers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetLoadBalancers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetLoadBalancers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetLoadBalancersResponse> getLoadBalancers(GetLoadBalancersRequest getLoadBalancersRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getLoadBalancersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLoadBalancers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetLoadBalancersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetLoadBalancersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetLoadBalancersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetLoadBalancersRequest, GetLoadBalancersResponse>()
                            .withOperationName("GetLoadBalancers")
                            .withMarshaller(new GetLoadBalancersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getLoadBalancersRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getLoadBalancersRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetLoadBalancersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a specific operation. Operations include events such as when you create an instance,
     * allocate a static IP, attach a static IP, and so on.
     * </p>
     *
     * @param getOperationRequest
     * @return A Java Future containing the result of the GetOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperation" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetOperationResponse> getOperation(GetOperationRequest getOperationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getOperationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetOperation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetOperationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetOperationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetOperationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetOperationRequest, GetOperationResponse>()
                            .withOperationName("GetOperation").withMarshaller(new GetOperationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getOperationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getOperationRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetOperationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about all operations.
     * </p>
     * <p>
     * Results are returned from oldest to newest, up to a maximum of 200. Results can be paged by making each
     * subsequent call to <code>GetOperations</code> use the maximum (last) <code>statusChangedAt</code> value from the
     * previous request.
     * </p>
     *
     * @param getOperationsRequest
     * @return A Java Future containing the result of the GetOperations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetOperations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperations" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetOperationsResponse> getOperations(GetOperationsRequest getOperationsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getOperationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetOperations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetOperationsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetOperationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetOperationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetOperationsRequest, GetOperationsResponse>()
                            .withOperationName("GetOperations")
                            .withMarshaller(new GetOperationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getOperationsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getOperationsRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetOperationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets operations for a specific resource (e.g., an instance or a static IP).
     * </p>
     *
     * @param getOperationsForResourceRequest
     * @return A Java Future containing the result of the GetOperationsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetOperationsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperationsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetOperationsForResourceResponse> getOperationsForResource(
            GetOperationsForResourceRequest getOperationsForResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getOperationsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetOperationsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetOperationsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetOperationsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetOperationsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetOperationsForResourceRequest, GetOperationsForResourceResponse>()
                            .withOperationName("GetOperationsForResource")
                            .withMarshaller(new GetOperationsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getOperationsForResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getOperationsForResourceRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<GetOperationsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of all valid regions for Amazon Lightsail. Use the <code>include availability zones</code>
     * parameter to also return the Availability Zones in a region.
     * </p>
     *
     * @param getRegionsRequest
     * @return A Java Future containing the result of the GetRegions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetRegions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRegions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetRegionsResponse> getRegions(GetRegionsRequest getRegionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRegionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRegions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRegionsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetRegionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRegionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRegionsRequest, GetRegionsResponse>().withOperationName("GetRegions")
                            .withMarshaller(new GetRegionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getRegionsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getRegionsRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetRegionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a specific database in Amazon Lightsail.
     * </p>
     *
     * @param getRelationalDatabaseRequest
     * @return A Java Future containing the result of the GetRelationalDatabase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetRelationalDatabase
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabase"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetRelationalDatabaseResponse> getRelationalDatabase(
            GetRelationalDatabaseRequest getRelationalDatabaseRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRelationalDatabaseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRelationalDatabase");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRelationalDatabaseResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetRelationalDatabaseResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRelationalDatabaseResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRelationalDatabaseRequest, GetRelationalDatabaseResponse>()
                            .withOperationName("GetRelationalDatabase")
                            .withMarshaller(new GetRelationalDatabaseRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getRelationalDatabaseRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getRelationalDatabaseRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<GetRelationalDatabaseResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of available database blueprints in Amazon Lightsail. A blueprint describes the major engine
     * version of a database.
     * </p>
     * <p>
     * You can use a blueprint ID to create a new database that runs a specific database engine.
     * </p>
     *
     * @param getRelationalDatabaseBlueprintsRequest
     * @return A Java Future containing the result of the GetRelationalDatabaseBlueprints operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetRelationalDatabaseBlueprints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseBlueprints"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetRelationalDatabaseBlueprintsResponse> getRelationalDatabaseBlueprints(
            GetRelationalDatabaseBlueprintsRequest getRelationalDatabaseBlueprintsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getRelationalDatabaseBlueprintsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRelationalDatabaseBlueprints");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRelationalDatabaseBlueprintsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetRelationalDatabaseBlueprintsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRelationalDatabaseBlueprintsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRelationalDatabaseBlueprintsRequest, GetRelationalDatabaseBlueprintsResponse>()
                            .withOperationName("GetRelationalDatabaseBlueprints")
                            .withMarshaller(new GetRelationalDatabaseBlueprintsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getRelationalDatabaseBlueprintsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getRelationalDatabaseBlueprintsRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<GetRelationalDatabaseBlueprintsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the list of bundles that are available in Amazon Lightsail. A bundle describes the performance
     * specifications for a database.
     * </p>
     * <p>
     * You can use a bundle ID to create a new database with explicit performance specifications.
     * </p>
     *
     * @param getRelationalDatabaseBundlesRequest
     * @return A Java Future containing the result of the GetRelationalDatabaseBundles operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetRelationalDatabaseBundles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseBundles"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetRelationalDatabaseBundlesResponse> getRelationalDatabaseBundles(
            GetRelationalDatabaseBundlesRequest getRelationalDatabaseBundlesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRelationalDatabaseBundlesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRelationalDatabaseBundles");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRelationalDatabaseBundlesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetRelationalDatabaseBundlesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRelationalDatabaseBundlesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRelationalDatabaseBundlesRequest, GetRelationalDatabaseBundlesResponse>()
                            .withOperationName("GetRelationalDatabaseBundles")
                            .withMarshaller(new GetRelationalDatabaseBundlesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getRelationalDatabaseBundlesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getRelationalDatabaseBundlesRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<GetRelationalDatabaseBundlesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of events for a specific database in Amazon Lightsail.
     * </p>
     *
     * @param getRelationalDatabaseEventsRequest
     * @return A Java Future containing the result of the GetRelationalDatabaseEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetRelationalDatabaseEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseEvents"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetRelationalDatabaseEventsResponse> getRelationalDatabaseEvents(
            GetRelationalDatabaseEventsRequest getRelationalDatabaseEventsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRelationalDatabaseEventsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRelationalDatabaseEvents");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRelationalDatabaseEventsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetRelationalDatabaseEventsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRelationalDatabaseEventsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRelationalDatabaseEventsRequest, GetRelationalDatabaseEventsResponse>()
                            .withOperationName("GetRelationalDatabaseEvents")
                            .withMarshaller(new GetRelationalDatabaseEventsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getRelationalDatabaseEventsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getRelationalDatabaseEventsRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<GetRelationalDatabaseEventsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of log events for a database in Amazon Lightsail.
     * </p>
     *
     * @param getRelationalDatabaseLogEventsRequest
     * @return A Java Future containing the result of the GetRelationalDatabaseLogEvents operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetRelationalDatabaseLogEvents
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseLogEvents"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetRelationalDatabaseLogEventsResponse> getRelationalDatabaseLogEvents(
            GetRelationalDatabaseLogEventsRequest getRelationalDatabaseLogEventsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getRelationalDatabaseLogEventsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRelationalDatabaseLogEvents");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRelationalDatabaseLogEventsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetRelationalDatabaseLogEventsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRelationalDatabaseLogEventsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRelationalDatabaseLogEventsRequest, GetRelationalDatabaseLogEventsResponse>()
                            .withOperationName("GetRelationalDatabaseLogEvents")
                            .withMarshaller(new GetRelationalDatabaseLogEventsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getRelationalDatabaseLogEventsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getRelationalDatabaseLogEventsRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<GetRelationalDatabaseLogEventsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of available log streams for a specific database in Amazon Lightsail.
     * </p>
     *
     * @param getRelationalDatabaseLogStreamsRequest
     * @return A Java Future containing the result of the GetRelationalDatabaseLogStreams operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetRelationalDatabaseLogStreams
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseLogStreams"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetRelationalDatabaseLogStreamsResponse> getRelationalDatabaseLogStreams(
            GetRelationalDatabaseLogStreamsRequest getRelationalDatabaseLogStreamsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getRelationalDatabaseLogStreamsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRelationalDatabaseLogStreams");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRelationalDatabaseLogStreamsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetRelationalDatabaseLogStreamsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRelationalDatabaseLogStreamsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRelationalDatabaseLogStreamsRequest, GetRelationalDatabaseLogStreamsResponse>()
                            .withOperationName("GetRelationalDatabaseLogStreams")
                            .withMarshaller(new GetRelationalDatabaseLogStreamsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getRelationalDatabaseLogStreamsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getRelationalDatabaseLogStreamsRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<GetRelationalDatabaseLogStreamsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the current, previous, or pending versions of the master user password for a Lightsail database.
     * </p>
     * <p>
     * The <code>GetRelationalDatabaseMasterUserPassword</code> operation supports tag-based access control via resource
     * tags applied to the resource identified by relationalDatabaseName.
     * </p>
     *
     * @param getRelationalDatabaseMasterUserPasswordRequest
     * @return A Java Future containing the result of the GetRelationalDatabaseMasterUserPassword operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetRelationalDatabaseMasterUserPassword
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseMasterUserPassword"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetRelationalDatabaseMasterUserPasswordResponse> getRelationalDatabaseMasterUserPassword(
            GetRelationalDatabaseMasterUserPasswordRequest getRelationalDatabaseMasterUserPasswordRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getRelationalDatabaseMasterUserPasswordRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRelationalDatabaseMasterUserPassword");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRelationalDatabaseMasterUserPasswordResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetRelationalDatabaseMasterUserPasswordResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRelationalDatabaseMasterUserPasswordResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRelationalDatabaseMasterUserPasswordRequest, GetRelationalDatabaseMasterUserPasswordResponse>()
                            .withOperationName("GetRelationalDatabaseMasterUserPassword")
                            .withMarshaller(new GetRelationalDatabaseMasterUserPasswordRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector)
                            .withInput(getRelationalDatabaseMasterUserPasswordRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getRelationalDatabaseMasterUserPasswordRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<GetRelationalDatabaseMasterUserPasswordResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the data points of the specified metric for a database in Amazon Lightsail.
     * </p>
     * <p>
     * Metrics report the utilization of your resources, and the error counts generated by them. Monitor and collect
     * metric data regularly to maintain the reliability, availability, and performance of your resources.
     * </p>
     *
     * @param getRelationalDatabaseMetricDataRequest
     * @return A Java Future containing the result of the GetRelationalDatabaseMetricData operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetRelationalDatabaseMetricData
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseMetricData"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetRelationalDatabaseMetricDataResponse> getRelationalDatabaseMetricData(
            GetRelationalDatabaseMetricDataRequest getRelationalDatabaseMetricDataRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getRelationalDatabaseMetricDataRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRelationalDatabaseMetricData");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRelationalDatabaseMetricDataResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetRelationalDatabaseMetricDataResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRelationalDatabaseMetricDataResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRelationalDatabaseMetricDataRequest, GetRelationalDatabaseMetricDataResponse>()
                            .withOperationName("GetRelationalDatabaseMetricData")
                            .withMarshaller(new GetRelationalDatabaseMetricDataRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getRelationalDatabaseMetricDataRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getRelationalDatabaseMetricDataRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<GetRelationalDatabaseMetricDataResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns all of the runtime parameters offered by the underlying database software, or engine, for a specific
     * database in Amazon Lightsail.
     * </p>
     * <p>
     * In addition to the parameter names and values, this operation returns other information about each parameter.
     * This information includes whether changes require a reboot, whether the parameter is modifiable, the allowed
     * values, and the data types.
     * </p>
     *
     * @param getRelationalDatabaseParametersRequest
     * @return A Java Future containing the result of the GetRelationalDatabaseParameters operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetRelationalDatabaseParameters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseParameters"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetRelationalDatabaseParametersResponse> getRelationalDatabaseParameters(
            GetRelationalDatabaseParametersRequest getRelationalDatabaseParametersRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getRelationalDatabaseParametersRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRelationalDatabaseParameters");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRelationalDatabaseParametersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetRelationalDatabaseParametersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRelationalDatabaseParametersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRelationalDatabaseParametersRequest, GetRelationalDatabaseParametersResponse>()
                            .withOperationName("GetRelationalDatabaseParameters")
                            .withMarshaller(new GetRelationalDatabaseParametersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getRelationalDatabaseParametersRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getRelationalDatabaseParametersRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<GetRelationalDatabaseParametersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a specific database snapshot in Amazon Lightsail.
     * </p>
     *
     * @param getRelationalDatabaseSnapshotRequest
     * @return A Java Future containing the result of the GetRelationalDatabaseSnapshot operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetRelationalDatabaseSnapshot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetRelationalDatabaseSnapshotResponse> getRelationalDatabaseSnapshot(
            GetRelationalDatabaseSnapshotRequest getRelationalDatabaseSnapshotRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getRelationalDatabaseSnapshotRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRelationalDatabaseSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRelationalDatabaseSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetRelationalDatabaseSnapshotResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRelationalDatabaseSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRelationalDatabaseSnapshotRequest, GetRelationalDatabaseSnapshotResponse>()
                            .withOperationName("GetRelationalDatabaseSnapshot")
                            .withMarshaller(new GetRelationalDatabaseSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getRelationalDatabaseSnapshotRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getRelationalDatabaseSnapshotRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<GetRelationalDatabaseSnapshotResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about all of your database snapshots in Amazon Lightsail.
     * </p>
     *
     * @param getRelationalDatabaseSnapshotsRequest
     * @return A Java Future containing the result of the GetRelationalDatabaseSnapshots operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetRelationalDatabaseSnapshots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetRelationalDatabaseSnapshotsResponse> getRelationalDatabaseSnapshots(
            GetRelationalDatabaseSnapshotsRequest getRelationalDatabaseSnapshotsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getRelationalDatabaseSnapshotsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRelationalDatabaseSnapshots");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRelationalDatabaseSnapshotsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetRelationalDatabaseSnapshotsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRelationalDatabaseSnapshotsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRelationalDatabaseSnapshotsRequest, GetRelationalDatabaseSnapshotsResponse>()
                            .withOperationName("GetRelationalDatabaseSnapshots")
                            .withMarshaller(new GetRelationalDatabaseSnapshotsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getRelationalDatabaseSnapshotsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getRelationalDatabaseSnapshotsRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<GetRelationalDatabaseSnapshotsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about all of your databases in Amazon Lightsail.
     * </p>
     *
     * @param getRelationalDatabasesRequest
     * @return A Java Future containing the result of the GetRelationalDatabases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetRelationalDatabases
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabases"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetRelationalDatabasesResponse> getRelationalDatabases(
            GetRelationalDatabasesRequest getRelationalDatabasesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRelationalDatabasesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRelationalDatabases");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRelationalDatabasesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetRelationalDatabasesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetRelationalDatabasesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRelationalDatabasesRequest, GetRelationalDatabasesResponse>()
                            .withOperationName("GetRelationalDatabases")
                            .withMarshaller(new GetRelationalDatabasesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getRelationalDatabasesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getRelationalDatabasesRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<GetRelationalDatabasesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a specific static IP.
     * </p>
     *
     * @param getStaticIpRequest
     * @return A Java Future containing the result of the GetStaticIp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetStaticIp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetStaticIp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetStaticIpResponse> getStaticIp(GetStaticIpRequest getStaticIpRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getStaticIpRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetStaticIp");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetStaticIpResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetStaticIpResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetStaticIpResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetStaticIpRequest, GetStaticIpResponse>()
                            .withOperationName("GetStaticIp").withMarshaller(new GetStaticIpRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getStaticIpRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getStaticIpRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetStaticIpResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about all static IPs in the user's account.
     * </p>
     *
     * @param getStaticIpsRequest
     * @return A Java Future containing the result of the GetStaticIps operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.GetStaticIps
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetStaticIps" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetStaticIpsResponse> getStaticIps(GetStaticIpsRequest getStaticIpsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getStaticIpsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetStaticIps");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetStaticIpsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetStaticIpsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetStaticIpsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetStaticIpsRequest, GetStaticIpsResponse>()
                            .withOperationName("GetStaticIps").withMarshaller(new GetStaticIpsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getStaticIpsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getStaticIpsRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetStaticIpsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Imports a public SSH key from a specific key pair.
     * </p>
     *
     * @param importKeyPairRequest
     * @return A Java Future containing the result of the ImportKeyPair operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.ImportKeyPair
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/ImportKeyPair" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ImportKeyPairResponse> importKeyPair(ImportKeyPairRequest importKeyPairRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, importKeyPairRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ImportKeyPair");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ImportKeyPairResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ImportKeyPairResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ImportKeyPairResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ImportKeyPairRequest, ImportKeyPairResponse>()
                            .withOperationName("ImportKeyPair")
                            .withMarshaller(new ImportKeyPairRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(importKeyPairRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = importKeyPairRequest.overrideConfiguration().orElse(null);
            CompletableFuture<ImportKeyPairResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a Boolean value indicating whether your Lightsail VPC is peered.
     * </p>
     *
     * @param isVpcPeeredRequest
     * @return A Java Future containing the result of the IsVpcPeered operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.IsVpcPeered
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/IsVpcPeered" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<IsVpcPeeredResponse> isVpcPeered(IsVpcPeeredRequest isVpcPeeredRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, isVpcPeeredRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "IsVpcPeered");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<IsVpcPeeredResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    IsVpcPeeredResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<IsVpcPeeredResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<IsVpcPeeredRequest, IsVpcPeeredResponse>()
                            .withOperationName("IsVpcPeered").withMarshaller(new IsVpcPeeredRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(isVpcPeeredRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = isVpcPeeredRequest.overrideConfiguration().orElse(null);
            CompletableFuture<IsVpcPeeredResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Opens ports for a specific Amazon Lightsail instance, and specifies the IP addresses allowed to connect to the
     * instance through the ports, and the protocol.
     * </p>
     * <p>
     * The <code>OpenInstancePublicPorts</code> action supports tag-based access control via resource tags applied to
     * the resource identified by <code>instanceName</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param openInstancePublicPortsRequest
     * @return A Java Future containing the result of the OpenInstancePublicPorts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.OpenInstancePublicPorts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/OpenInstancePublicPorts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<OpenInstancePublicPortsResponse> openInstancePublicPorts(
            OpenInstancePublicPortsRequest openInstancePublicPortsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, openInstancePublicPortsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "OpenInstancePublicPorts");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<OpenInstancePublicPortsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, OpenInstancePublicPortsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<OpenInstancePublicPortsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<OpenInstancePublicPortsRequest, OpenInstancePublicPortsResponse>()
                            .withOperationName("OpenInstancePublicPorts")
                            .withMarshaller(new OpenInstancePublicPortsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(openInstancePublicPortsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = openInstancePublicPortsRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<OpenInstancePublicPortsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Tries to peer the Lightsail VPC with the user's default VPC.
     * </p>
     *
     * @param peerVpcRequest
     * @return A Java Future containing the result of the PeerVpc operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.PeerVpc
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/PeerVpc" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<PeerVpcResponse> peerVpc(PeerVpcRequest peerVpcRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, peerVpcRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PeerVpc");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PeerVpcResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    PeerVpcResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PeerVpcResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PeerVpcRequest, PeerVpcResponse>().withOperationName("PeerVpc")
                            .withMarshaller(new PeerVpcRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(peerVpcRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = peerVpcRequest.overrideConfiguration().orElse(null);
            CompletableFuture<PeerVpcResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates or updates an alarm, and associates it with the specified metric.
     * </p>
     * <p>
     * An alarm is used to monitor a single metric for one of your resources. When a metric condition is met, the alarm
     * can notify you by email, SMS text message, and a banner displayed on the Amazon Lightsail console. For more
     * information, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-alarms">Alarms
     * in Amazon Lightsail</a>.
     * </p>
     * <p>
     * When this action creates an alarm, the alarm state is immediately set to <code>INSUFFICIENT_DATA</code>. The
     * alarm is then evaluated and its state is set appropriately. Any actions associated with the new state are then
     * executed.
     * </p>
     * <p>
     * When you update an existing alarm, its state is left unchanged, but the update completely overwrites the previous
     * configuration of the alarm. The alarm is then evaluated with the updated configuration.
     * </p>
     *
     * @param putAlarmRequest
     * @return A Java Future containing the result of the PutAlarm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.PutAlarm
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/PutAlarm" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<PutAlarmResponse> putAlarm(PutAlarmRequest putAlarmRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putAlarmRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutAlarm");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutAlarmResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    PutAlarmResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutAlarmResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutAlarmRequest, PutAlarmResponse>().withOperationName("PutAlarm")
                            .withMarshaller(new PutAlarmRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(putAlarmRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = putAlarmRequest.overrideConfiguration().orElse(null);
            CompletableFuture<PutAlarmResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Opens ports for a specific Amazon Lightsail instance, and specifies the IP addresses allowed to connect to the
     * instance through the ports, and the protocol. This action also closes all currently open ports that are not
     * included in the request. Include all of the ports and the protocols you want to open in your
     * <code>PutInstancePublicPorts</code>request. Or use the <code>OpenInstancePublicPorts</code> action to open ports
     * without closing currently open ports.
     * </p>
     * <p>
     * The <code>PutInstancePublicPorts</code> action supports tag-based access control via resource tags applied to the
     * resource identified by <code>instanceName</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param putInstancePublicPortsRequest
     * @return A Java Future containing the result of the PutInstancePublicPorts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.PutInstancePublicPorts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/PutInstancePublicPorts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutInstancePublicPortsResponse> putInstancePublicPorts(
            PutInstancePublicPortsRequest putInstancePublicPortsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putInstancePublicPortsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutInstancePublicPorts");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutInstancePublicPortsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutInstancePublicPortsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutInstancePublicPortsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutInstancePublicPortsRequest, PutInstancePublicPortsResponse>()
                            .withOperationName("PutInstancePublicPorts")
                            .withMarshaller(new PutInstancePublicPortsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(putInstancePublicPortsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = putInstancePublicPortsRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<PutInstancePublicPortsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Restarts a specific instance.
     * </p>
     * <p>
     * The <code>reboot instance</code> operation supports tag-based access control via resource tags applied to the
     * resource identified by <code>instance name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param rebootInstanceRequest
     * @return A Java Future containing the result of the RebootInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.RebootInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/RebootInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<RebootInstanceResponse> rebootInstance(RebootInstanceRequest rebootInstanceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, rebootInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RebootInstance");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RebootInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RebootInstanceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RebootInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RebootInstanceRequest, RebootInstanceResponse>()
                            .withOperationName("RebootInstance")
                            .withMarshaller(new RebootInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(rebootInstanceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = rebootInstanceRequest.overrideConfiguration().orElse(null);
            CompletableFuture<RebootInstanceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Restarts a specific database in Amazon Lightsail.
     * </p>
     * <p>
     * The <code>reboot relational database</code> operation supports tag-based access control via resource tags applied
     * to the resource identified by relationalDatabaseName. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param rebootRelationalDatabaseRequest
     * @return A Java Future containing the result of the RebootRelationalDatabase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.RebootRelationalDatabase
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/RebootRelationalDatabase"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RebootRelationalDatabaseResponse> rebootRelationalDatabase(
            RebootRelationalDatabaseRequest rebootRelationalDatabaseRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, rebootRelationalDatabaseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RebootRelationalDatabase");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RebootRelationalDatabaseResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RebootRelationalDatabaseResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RebootRelationalDatabaseResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RebootRelationalDatabaseRequest, RebootRelationalDatabaseResponse>()
                            .withOperationName("RebootRelationalDatabase")
                            .withMarshaller(new RebootRelationalDatabaseRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(rebootRelationalDatabaseRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = rebootRelationalDatabaseRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<RebootRelationalDatabaseResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Registers a container image to your Amazon Lightsail container service.
     * </p>
     * <note>
     * <p>
     * This action is not required if you install and use the Lightsail Control (lightsailctl) plugin to push container
     * images to your Lightsail container service. For more information, see <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-pushing-container-images">Pushing
     * and managing container images on your Amazon Lightsail container services</a> in the <i>Lightsail Dev Guide</i>.
     * </p>
     * </note>
     *
     * @param registerContainerImageRequest
     * @return A Java Future containing the result of the RegisterContainerImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.RegisterContainerImage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/RegisterContainerImage"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<RegisterContainerImageResponse> registerContainerImage(
            RegisterContainerImageRequest registerContainerImageRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, registerContainerImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RegisterContainerImage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RegisterContainerImageResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RegisterContainerImageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RegisterContainerImageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RegisterContainerImageRequest, RegisterContainerImageResponse>()
                            .withOperationName("RegisterContainerImage")
                            .withMarshaller(new RegisterContainerImageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(registerContainerImageRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = registerContainerImageRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<RegisterContainerImageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a specific static IP from your account.
     * </p>
     *
     * @param releaseStaticIpRequest
     * @return A Java Future containing the result of the ReleaseStaticIp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.ReleaseStaticIp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/ReleaseStaticIp" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ReleaseStaticIpResponse> releaseStaticIp(ReleaseStaticIpRequest releaseStaticIpRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, releaseStaticIpRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ReleaseStaticIp");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ReleaseStaticIpResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ReleaseStaticIpResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ReleaseStaticIpResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ReleaseStaticIpRequest, ReleaseStaticIpResponse>()
                            .withOperationName("ReleaseStaticIp")
                            .withMarshaller(new ReleaseStaticIpRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(releaseStaticIpRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = releaseStaticIpRequest.overrideConfiguration().orElse(null);
            CompletableFuture<ReleaseStaticIpResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes currently cached content from your Amazon Lightsail content delivery network (CDN) distribution.
     * </p>
     * <p>
     * After resetting the cache, the next time a content request is made, your distribution pulls, serves, and caches
     * it from the origin.
     * </p>
     *
     * @param resetDistributionCacheRequest
     * @return A Java Future containing the result of the ResetDistributionCache operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.ResetDistributionCache
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/ResetDistributionCache"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ResetDistributionCacheResponse> resetDistributionCache(
            ResetDistributionCacheRequest resetDistributionCacheRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, resetDistributionCacheRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ResetDistributionCache");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ResetDistributionCacheResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ResetDistributionCacheResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ResetDistributionCacheResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ResetDistributionCacheRequest, ResetDistributionCacheResponse>()
                            .withOperationName("ResetDistributionCache")
                            .withMarshaller(new ResetDistributionCacheRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(resetDistributionCacheRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = resetDistributionCacheRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<ResetDistributionCacheResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sends a verification request to an email contact method to ensure it's owned by the requester. SMS contact
     * methods don't need to be verified.
     * </p>
     * <p>
     * A contact method is used to send you notifications about your Amazon Lightsail resources. You can add one email
     * address and one mobile phone number contact method in each AWS Region. However, SMS text messaging is not
     * supported in some AWS Regions, and SMS text messages cannot be sent to some countries/regions. For more
     * information, see <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications">Notifications in
     * Amazon Lightsail</a>.
     * </p>
     * <p>
     * A verification request is sent to the contact method when you initially create it. Use this action to send
     * another verification request if a previous verification request was deleted, or has expired.
     * </p>
     * <important>
     * <p>
     * Notifications are not sent to an email contact method until after it is verified, and confirmed as valid.
     * </p>
     * </important>
     *
     * @param sendContactMethodVerificationRequest
     * @return A Java Future containing the result of the SendContactMethodVerification operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.SendContactMethodVerification
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/SendContactMethodVerification"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SendContactMethodVerificationResponse> sendContactMethodVerification(
            SendContactMethodVerificationRequest sendContactMethodVerificationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                sendContactMethodVerificationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SendContactMethodVerification");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SendContactMethodVerificationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SendContactMethodVerificationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SendContactMethodVerificationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SendContactMethodVerificationRequest, SendContactMethodVerificationResponse>()
                            .withOperationName("SendContactMethodVerification")
                            .withMarshaller(new SendContactMethodVerificationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(sendContactMethodVerificationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = sendContactMethodVerificationRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<SendContactMethodVerificationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets the IP address type for an Amazon Lightsail resource.
     * </p>
     * <p>
     * Use this action to enable dual-stack for a resource, which enables IPv4 and IPv6 for the specified resource.
     * Alternately, you can use this action to disable dual-stack, and enable IPv4 only.
     * </p>
     *
     * @param setIpAddressTypeRequest
     * @return A Java Future containing the result of the SetIpAddressType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.SetIpAddressType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/SetIpAddressType" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<SetIpAddressTypeResponse> setIpAddressType(SetIpAddressTypeRequest setIpAddressTypeRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, setIpAddressTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SetIpAddressType");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SetIpAddressTypeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SetIpAddressTypeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SetIpAddressTypeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SetIpAddressTypeRequest, SetIpAddressTypeResponse>()
                            .withOperationName("SetIpAddressType")
                            .withMarshaller(new SetIpAddressTypeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(setIpAddressTypeRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = setIpAddressTypeRequest.overrideConfiguration().orElse(null);
            CompletableFuture<SetIpAddressTypeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts a specific Amazon Lightsail instance from a stopped state. To restart an instance, use the
     * <code>reboot instance</code> operation.
     * </p>
     * <note>
     * <p>
     * When you start a stopped instance, Lightsail assigns a new public IP address to the instance. To use the same IP
     * address after stopping and starting an instance, create a static IP address and attach it to the instance. For
     * more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/lightsail-create-static-ip">Lightsail Dev Guide</a>.
     * </p>
     * </note>
     * <p>
     * The <code>start instance</code> operation supports tag-based access control via resource tags applied to the
     * resource identified by <code>instance name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param startInstanceRequest
     * @return A Java Future containing the result of the StartInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.StartInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/StartInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StartInstanceResponse> startInstance(StartInstanceRequest startInstanceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartInstance");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartInstanceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    StartInstanceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartInstanceRequest, StartInstanceResponse>()
                            .withOperationName("StartInstance")
                            .withMarshaller(new StartInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(startInstanceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = startInstanceRequest.overrideConfiguration().orElse(null);
            CompletableFuture<StartInstanceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts a specific database from a stopped state in Amazon Lightsail. To restart a database, use the
     * <code>reboot relational database</code> operation.
     * </p>
     * <p>
     * The <code>start relational database</code> operation supports tag-based access control via resource tags applied
     * to the resource identified by relationalDatabaseName. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param startRelationalDatabaseRequest
     * @return A Java Future containing the result of the StartRelationalDatabase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.StartRelationalDatabase
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/StartRelationalDatabase"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartRelationalDatabaseResponse> startRelationalDatabase(
            StartRelationalDatabaseRequest startRelationalDatabaseRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startRelationalDatabaseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartRelationalDatabase");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartRelationalDatabaseResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartRelationalDatabaseResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartRelationalDatabaseResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartRelationalDatabaseRequest, StartRelationalDatabaseResponse>()
                            .withOperationName("StartRelationalDatabase")
                            .withMarshaller(new StartRelationalDatabaseRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(startRelationalDatabaseRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = startRelationalDatabaseRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<StartRelationalDatabaseResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops a specific Amazon Lightsail instance that is currently running.
     * </p>
     * <note>
     * <p>
     * When you start a stopped instance, Lightsail assigns a new public IP address to the instance. To use the same IP
     * address after stopping and starting an instance, create a static IP address and attach it to the instance. For
     * more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/lightsail-create-static-ip">Lightsail Dev Guide</a>.
     * </p>
     * </note>
     * <p>
     * The <code>stop instance</code> operation supports tag-based access control via resource tags applied to the
     * resource identified by <code>instance name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param stopInstanceRequest
     * @return A Java Future containing the result of the StopInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.StopInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/StopInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StopInstanceResponse> stopInstance(StopInstanceRequest stopInstanceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopInstance");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopInstanceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    StopInstanceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StopInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopInstanceRequest, StopInstanceResponse>()
                            .withOperationName("StopInstance").withMarshaller(new StopInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(stopInstanceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = stopInstanceRequest.overrideConfiguration().orElse(null);
            CompletableFuture<StopInstanceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops a specific database that is currently running in Amazon Lightsail.
     * </p>
     * <p>
     * The <code>stop relational database</code> operation supports tag-based access control via resource tags applied
     * to the resource identified by relationalDatabaseName. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param stopRelationalDatabaseRequest
     * @return A Java Future containing the result of the StopRelationalDatabase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.StopRelationalDatabase
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/StopRelationalDatabase"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StopRelationalDatabaseResponse> stopRelationalDatabase(
            StopRelationalDatabaseRequest stopRelationalDatabaseRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopRelationalDatabaseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopRelationalDatabase");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopRelationalDatabaseResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StopRelationalDatabaseResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StopRelationalDatabaseResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopRelationalDatabaseRequest, StopRelationalDatabaseResponse>()
                            .withOperationName("StopRelationalDatabase")
                            .withMarshaller(new StopRelationalDatabaseRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(stopRelationalDatabaseRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = stopRelationalDatabaseRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<StopRelationalDatabaseResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds one or more tags to the specified Amazon Lightsail resource. Each resource can have a maximum of 50 tags.
     * Each tag consists of a key and an optional value. Tag keys must be unique per resource. For more information
     * about tags, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-tags">Lightsail Dev Guide</a>.
     * </p>
     * <p>
     * The <code>tag resource</code> operation supports tag-based access control via request tags and resource tags
     * applied to the resource identified by <code>resource name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(tagResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = tagResourceRequest.overrideConfiguration().orElse(null);
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Tests an alarm by displaying a banner on the Amazon Lightsail console. If a notification trigger is configured
     * for the specified alarm, the test also sends a notification to the notification protocol (<code>Email</code>
     * and/or <code>SMS</code>) configured for the alarm.
     * </p>
     * <p>
     * An alarm is used to monitor a single metric for one of your resources. When a metric condition is met, the alarm
     * can notify you by email, SMS text message, and a banner displayed on the Amazon Lightsail console. For more
     * information, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-alarms">Alarms
     * in Amazon Lightsail</a>.
     * </p>
     *
     * @param testAlarmRequest
     * @return A Java Future containing the result of the TestAlarm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.TestAlarm
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/TestAlarm" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TestAlarmResponse> testAlarm(TestAlarmRequest testAlarmRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, testAlarmRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TestAlarm");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TestAlarmResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TestAlarmResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TestAlarmResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TestAlarmRequest, TestAlarmResponse>().withOperationName("TestAlarm")
                            .withMarshaller(new TestAlarmRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(testAlarmRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = testAlarmRequest.overrideConfiguration().orElse(null);
            CompletableFuture<TestAlarmResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attempts to unpeer the Lightsail VPC from the user's default VPC.
     * </p>
     *
     * @param unpeerVpcRequest
     * @return A Java Future containing the result of the UnpeerVpc operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.UnpeerVpc
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UnpeerVpc" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UnpeerVpcResponse> unpeerVpc(UnpeerVpcRequest unpeerVpcRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, unpeerVpcRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UnpeerVpc");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UnpeerVpcResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UnpeerVpcResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UnpeerVpcResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UnpeerVpcRequest, UnpeerVpcResponse>().withOperationName("UnpeerVpc")
                            .withMarshaller(new UnpeerVpcRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(unpeerVpcRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = unpeerVpcRequest.overrideConfiguration().orElse(null);
            CompletableFuture<UnpeerVpcResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified set of tag keys and their values from the specified Amazon Lightsail resource.
     * </p>
     * <p>
     * The <code>untag resource</code> operation supports tag-based access control via request tags and resource tags
     * applied to the resource identified by <code>resource name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource")
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(untagResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = untagResourceRequest.overrideConfiguration().orElse(null);
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the configuration of your Amazon Lightsail container service, such as its power, scale, and public domain
     * names.
     * </p>
     *
     * @param updateContainerServiceRequest
     * @return A Java Future containing the result of the UpdateContainerService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.UpdateContainerService
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateContainerService"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateContainerServiceResponse> updateContainerService(
            UpdateContainerServiceRequest updateContainerServiceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateContainerServiceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateContainerService");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateContainerServiceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateContainerServiceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateContainerServiceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateContainerServiceRequest, UpdateContainerServiceResponse>()
                            .withOperationName("UpdateContainerService")
                            .withMarshaller(new UpdateContainerServiceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateContainerServiceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateContainerServiceRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<UpdateContainerServiceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing Amazon Lightsail content delivery network (CDN) distribution.
     * </p>
     * <p>
     * Use this action to update the configuration of your existing distribution
     * </p>
     *
     * @param updateDistributionRequest
     * @return A Java Future containing the result of the UpdateDistribution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.UpdateDistribution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateDistribution" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateDistributionResponse> updateDistribution(UpdateDistributionRequest updateDistributionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDistributionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDistribution");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateDistributionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateDistributionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateDistributionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateDistributionRequest, UpdateDistributionResponse>()
                            .withOperationName("UpdateDistribution")
                            .withMarshaller(new UpdateDistributionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateDistributionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateDistributionRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<UpdateDistributionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the bundle of your Amazon Lightsail content delivery network (CDN) distribution.
     * </p>
     * <p>
     * A distribution bundle specifies the monthly network transfer quota and monthly cost of your dsitribution.
     * </p>
     * <p>
     * Update your distribution's bundle if your distribution is going over its monthly network transfer quota and is
     * incurring an overage fee.
     * </p>
     * <p>
     * You can update your distribution's bundle only one time within your monthly AWS billing cycle. To determine if
     * you can update your distribution's bundle, use the <code>GetDistributions</code> action. The
     * <code>ableToUpdateBundle</code> parameter in the result will indicate whether you can currently update your
     * distribution's bundle.
     * </p>
     *
     * @param updateDistributionBundleRequest
     * @return A Java Future containing the result of the UpdateDistributionBundle operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.UpdateDistributionBundle
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateDistributionBundle"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateDistributionBundleResponse> updateDistributionBundle(
            UpdateDistributionBundleRequest updateDistributionBundleRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDistributionBundleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDistributionBundle");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateDistributionBundleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateDistributionBundleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateDistributionBundleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateDistributionBundleRequest, UpdateDistributionBundleResponse>()
                            .withOperationName("UpdateDistributionBundle")
                            .withMarshaller(new UpdateDistributionBundleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateDistributionBundleRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateDistributionBundleRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<UpdateDistributionBundleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a domain recordset after it is created.
     * </p>
     * <p>
     * The <code>update domain entry</code> operation supports tag-based access control via resource tags applied to the
     * resource identified by <code>domain name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param updateDomainEntryRequest
     * @return A Java Future containing the result of the UpdateDomainEntry operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.UpdateDomainEntry
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateDomainEntry" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateDomainEntryResponse> updateDomainEntry(UpdateDomainEntryRequest updateDomainEntryRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDomainEntryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDomainEntry");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateDomainEntryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateDomainEntryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateDomainEntryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateDomainEntryRequest, UpdateDomainEntryResponse>()
                            .withOperationName("UpdateDomainEntry")
                            .withMarshaller(new UpdateDomainEntryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateDomainEntryRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateDomainEntryRequest.overrideConfiguration().orElse(null);
            CompletableFuture<UpdateDomainEntryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the specified attribute for a load balancer. You can only update one attribute at a time.
     * </p>
     * <p>
     * The <code>update load balancer attribute</code> operation supports tag-based access control via resource tags
     * applied to the resource identified by <code>load balancer name</code>. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param updateLoadBalancerAttributeRequest
     * @return A Java Future containing the result of the UpdateLoadBalancerAttribute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.UpdateLoadBalancerAttribute
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateLoadBalancerAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateLoadBalancerAttributeResponse> updateLoadBalancerAttribute(
            UpdateLoadBalancerAttributeRequest updateLoadBalancerAttributeRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateLoadBalancerAttributeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateLoadBalancerAttribute");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateLoadBalancerAttributeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateLoadBalancerAttributeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateLoadBalancerAttributeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateLoadBalancerAttributeRequest, UpdateLoadBalancerAttributeResponse>()
                            .withOperationName("UpdateLoadBalancerAttribute")
                            .withMarshaller(new UpdateLoadBalancerAttributeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateLoadBalancerAttributeRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateLoadBalancerAttributeRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<UpdateLoadBalancerAttributeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Allows the update of one or more attributes of a database in Amazon Lightsail.
     * </p>
     * <p>
     * Updates are applied immediately, or in cases where the updates could result in an outage, are applied during the
     * database's predefined maintenance window.
     * </p>
     * <p>
     * The <code>update relational database</code> operation supports tag-based access control via resource tags applied
     * to the resource identified by relationalDatabaseName. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param updateRelationalDatabaseRequest
     * @return A Java Future containing the result of the UpdateRelationalDatabase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.UpdateRelationalDatabase
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateRelationalDatabase"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateRelationalDatabaseResponse> updateRelationalDatabase(
            UpdateRelationalDatabaseRequest updateRelationalDatabaseRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateRelationalDatabaseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRelationalDatabase");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateRelationalDatabaseResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateRelationalDatabaseResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateRelationalDatabaseResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateRelationalDatabaseRequest, UpdateRelationalDatabaseResponse>()
                            .withOperationName("UpdateRelationalDatabase")
                            .withMarshaller(new UpdateRelationalDatabaseRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateRelationalDatabaseRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateRelationalDatabaseRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<UpdateRelationalDatabaseResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Allows the update of one or more parameters of a database in Amazon Lightsail.
     * </p>
     * <p>
     * Parameter updates don't cause outages; therefore, their application is not subject to the preferred maintenance
     * window. However, there are two ways in which parameter updates are applied: <code>dynamic</code> or
     * <code>pending-reboot</code>. Parameters marked with a <code>dynamic</code> apply type are applied immediately.
     * Parameters marked with a <code>pending-reboot</code> apply type are applied only after the database is rebooted
     * using the <code>reboot relational database</code> operation.
     * </p>
     * <p>
     * The <code>update relational database parameters</code> operation supports tag-based access control via resource
     * tags applied to the resource identified by relationalDatabaseName. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags"
     * >Lightsail Dev Guide</a>.
     * </p>
     *
     * @param updateRelationalDatabaseParametersRequest
     * @return A Java Future containing the result of the UpdateRelationalDatabaseParameters operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException A general service exception.</li>
     *         <li>InvalidInputException Lightsail throws this exception when user input does not conform to the
     *         validation rules of an input field.</p> <note>
     *         <p>
     *         Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) AWS Region.
     *         Please set your AWS Region configuration to <code>us-east-1</code> to create, view, or edit these
     *         resources.
     *         </p>
     *         </li>
     *         <li>NotFoundException Lightsail throws this exception when it cannot find a resource.</li>
     *         <li>OperationFailureException Lightsail throws this exception when an operation fails to execute.</li>
     *         <li>AccessDeniedException Lightsail throws this exception when the user cannot be authenticated or uses
     *         invalid credentials to access a resource.</li>
     *         <li>AccountSetupInProgressException Lightsail throws this exception when an account is still in the setup
     *         in progress state.</li>
     *         <li>UnauthenticatedException Lightsail throws this exception when the user has not been authenticated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LightsailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LightsailAsyncClient.UpdateRelationalDatabaseParameters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateRelationalDatabaseParameters"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateRelationalDatabaseParametersResponse> updateRelationalDatabaseParameters(
            UpdateRelationalDatabaseParametersRequest updateRelationalDatabaseParametersRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateRelationalDatabaseParametersRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Lightsail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRelationalDatabaseParameters");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateRelationalDatabaseParametersResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, UpdateRelationalDatabaseParametersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateRelationalDatabaseParametersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateRelationalDatabaseParametersRequest, UpdateRelationalDatabaseParametersResponse>()
                            .withOperationName("UpdateRelationalDatabaseParameters")
                            .withMarshaller(new UpdateRelationalDatabaseParametersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateRelationalDatabaseParametersRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateRelationalDatabaseParametersRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<UpdateRelationalDatabaseParametersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(LightsailException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnauthenticatedException")
                                .exceptionBuilderSupplier(UnauthenticatedException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceException")
                                .exceptionBuilderSupplier(ServiceException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NotFoundException")
                                .exceptionBuilderSupplier(NotFoundException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidInputException")
                                .exceptionBuilderSupplier(InvalidInputException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccountSetupInProgressException")
                                .exceptionBuilderSupplier(AccountSetupInProgressException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OperationFailureException")
                                .exceptionBuilderSupplier(OperationFailureException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }
}
