/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.OperationStatus;
import software.amazon.awssdk.services.lightsail.model.OperationType;
import software.amazon.awssdk.services.lightsail.model.ResourceLocation;
import software.amazon.awssdk.services.lightsail.model.ResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Operation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Operation> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(Operation.getter(Operation::id)).setter(Operation.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceName").getter(Operation.getter(Operation::resourceName)).setter(Operation.setter(Builder::resourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceName").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(Operation.getter(Operation::resourceTypeAsString)).setter(Operation.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(Operation.getter(Operation::createdAt)).setter(Operation.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<ResourceLocation> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("location").getter(Operation.getter(Operation::location)).setter(Operation.setter(Builder::location)).constructor(ResourceLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final SdkField<Boolean> IS_TERMINAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isTerminal").getter(Operation.getter(Operation::isTerminal)).setter(Operation.setter(Builder::isTerminal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isTerminal").build()}).build();
    private static final SdkField<String> OPERATION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("operationDetails").getter(Operation.getter(Operation::operationDetails)).setter(Operation.setter(Builder::operationDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationDetails").build()}).build();
    private static final SdkField<String> OPERATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("operationType").getter(Operation.getter(Operation::operationTypeAsString)).setter(Operation.setter(Builder::operationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(Operation.getter(Operation::statusAsString)).setter(Operation.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> STATUS_CHANGED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("statusChangedAt").getter(Operation.getter(Operation::statusChangedAt)).setter(Operation.setter(Builder::statusChangedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusChangedAt").build()}).build();
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorCode").getter(Operation.getter(Operation::errorCode)).setter(Operation.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()}).build();
    private static final SdkField<String> ERROR_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorDetails").getter(Operation.getter(Operation::errorDetails)).setter(Operation.setter(Builder::errorDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, RESOURCE_NAME_FIELD, RESOURCE_TYPE_FIELD, CREATED_AT_FIELD, LOCATION_FIELD, IS_TERMINAL_FIELD, OPERATION_DETAILS_FIELD, OPERATION_TYPE_FIELD, STATUS_FIELD, STATUS_CHANGED_AT_FIELD, ERROR_CODE_FIELD, ERROR_DETAILS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String resourceName;
    private final String resourceType;
    private final Instant createdAt;
    private final ResourceLocation location;
    private final Boolean isTerminal;
    private final String operationDetails;
    private final String operationType;
    private final String status;
    private final Instant statusChangedAt;
    private final String errorCode;
    private final String errorDetails;

    private Operation(BuilderImpl builder) {
        this.id = builder.id;
        this.resourceName = builder.resourceName;
        this.resourceType = builder.resourceType;
        this.createdAt = builder.createdAt;
        this.location = builder.location;
        this.isTerminal = builder.isTerminal;
        this.operationDetails = builder.operationDetails;
        this.operationType = builder.operationType;
        this.status = builder.status;
        this.statusChangedAt = builder.statusChangedAt;
        this.errorCode = builder.errorCode;
        this.errorDetails = builder.errorDetails;
    }

    public String id() {
        return this.id;
    }

    public String resourceName() {
        return this.resourceName;
    }

    public ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public String resourceTypeAsString() {
        return this.resourceType;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public ResourceLocation location() {
        return this.location;
    }

    public Boolean isTerminal() {
        return this.isTerminal;
    }

    public String operationDetails() {
        return this.operationDetails;
    }

    public OperationType operationType() {
        return OperationType.fromValue(this.operationType);
    }

    public String operationTypeAsString() {
        return this.operationType;
    }

    public OperationStatus status() {
        return OperationStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Instant statusChangedAt() {
        return this.statusChangedAt;
    }

    public String errorCode() {
        return this.errorCode;
    }

    public String errorDetails() {
        return this.errorDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.isTerminal());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusChangedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorDetails());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Operation)) {
            return false;
        }
        Operation other = (Operation)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.resourceName(), other.resourceName()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.isTerminal(), other.isTerminal()) && Objects.equals(this.operationDetails(), other.operationDetails()) && Objects.equals(this.operationTypeAsString(), other.operationTypeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusChangedAt(), other.statusChangedAt()) && Objects.equals(this.errorCode(), other.errorCode()) && Objects.equals(this.errorDetails(), other.errorDetails());
    }

    public String toString() {
        return ToString.builder((String)"Operation").add("Id", (Object)this.id()).add("ResourceName", (Object)this.resourceName()).add("ResourceType", (Object)this.resourceTypeAsString()).add("CreatedAt", (Object)this.createdAt()).add("Location", (Object)this.location()).add("IsTerminal", (Object)this.isTerminal()).add("OperationDetails", (Object)this.operationDetails()).add("OperationType", (Object)this.operationTypeAsString()).add("Status", (Object)this.statusAsString()).add("StatusChangedAt", (Object)this.statusChangedAt()).add("ErrorCode", (Object)this.errorCode()).add("ErrorDetails", (Object)this.errorDetails()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "resourceName": {
                return Optional.ofNullable(clazz.cast(this.resourceName()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "isTerminal": {
                return Optional.ofNullable(clazz.cast(this.isTerminal()));
            }
            case "operationDetails": {
                return Optional.ofNullable(clazz.cast(this.operationDetails()));
            }
            case "operationType": {
                return Optional.ofNullable(clazz.cast(this.operationTypeAsString()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusChangedAt": {
                return Optional.ofNullable(clazz.cast(this.statusChangedAt()));
            }
            case "errorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCode()));
            }
            case "errorDetails": {
                return Optional.ofNullable(clazz.cast(this.errorDetails()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Operation, T> g) {
        return obj -> g.apply((Operation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String resourceName;
        private String resourceType;
        private Instant createdAt;
        private ResourceLocation location;
        private Boolean isTerminal;
        private String operationDetails;
        private String operationType;
        private String status;
        private Instant statusChangedAt;
        private String errorCode;
        private String errorDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(Operation model) {
            this.id(model.id);
            this.resourceName(model.resourceName);
            this.resourceType(model.resourceType);
            this.createdAt(model.createdAt);
            this.location(model.location);
            this.isTerminal(model.isTerminal);
            this.operationDetails(model.operationDetails);
            this.operationType(model.operationType);
            this.status(model.status);
            this.statusChangedAt(model.statusChangedAt);
            this.errorCode(model.errorCode);
            this.errorDetails(model.errorDetails);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final ResourceLocation.Builder getLocation() {
            return this.location != null ? this.location.toBuilder() : null;
        }

        @Override
        public final Builder location(ResourceLocation location) {
            this.location = location;
            return this;
        }

        public final void setLocation(ResourceLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        public final Boolean getIsTerminal() {
            return this.isTerminal;
        }

        @Override
        public final Builder isTerminal(Boolean isTerminal) {
            this.isTerminal = isTerminal;
            return this;
        }

        public final void setIsTerminal(Boolean isTerminal) {
            this.isTerminal = isTerminal;
        }

        public final String getOperationDetails() {
            return this.operationDetails;
        }

        @Override
        public final Builder operationDetails(String operationDetails) {
            this.operationDetails = operationDetails;
            return this;
        }

        public final void setOperationDetails(String operationDetails) {
            this.operationDetails = operationDetails;
        }

        public final String getOperationType() {
            return this.operationType;
        }

        @Override
        public final Builder operationType(String operationType) {
            this.operationType = operationType;
            return this;
        }

        @Override
        public final Builder operationType(OperationType operationType) {
            this.operationType(operationType == null ? null : operationType.toString());
            return this;
        }

        public final void setOperationType(String operationType) {
            this.operationType = operationType;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OperationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getStatusChangedAt() {
            return this.statusChangedAt;
        }

        @Override
        public final Builder statusChangedAt(Instant statusChangedAt) {
            this.statusChangedAt = statusChangedAt;
            return this;
        }

        public final void setStatusChangedAt(Instant statusChangedAt) {
            this.statusChangedAt = statusChangedAt;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getErrorDetails() {
            return this.errorDetails;
        }

        @Override
        public final Builder errorDetails(String errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public final void setErrorDetails(String errorDetails) {
            this.errorDetails = errorDetails;
        }

        public Operation build() {
            return new Operation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Operation> {
        public Builder id(String var1);

        public Builder resourceName(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder createdAt(Instant var1);

        public Builder location(ResourceLocation var1);

        default public Builder location(Consumer<ResourceLocation.Builder> location) {
            return this.location((ResourceLocation)((ResourceLocation.Builder)ResourceLocation.builder().applyMutation(location)).build());
        }

        public Builder isTerminal(Boolean var1);

        public Builder operationDetails(String var1);

        public Builder operationType(String var1);

        public Builder operationType(OperationType var1);

        public Builder status(String var1);

        public Builder status(OperationStatus var1);

        public Builder statusChangedAt(Instant var1);

        public Builder errorCode(String var1);

        public Builder errorDetails(String var1);
    }
}

