/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DistributionMetricName {
    REQUESTS("Requests"),
    BYTES_DOWNLOADED("BytesDownloaded"),
    BYTES_UPLOADED("BytesUploaded"),
    TOTAL_ERROR_RATE("TotalErrorRate"),
    HTTP4_XX_ERROR_RATE("Http4xxErrorRate"),
    HTTP5_XX_ERROR_RATE("Http5xxErrorRate"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DistributionMetricName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DistributionMetricName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DistributionMetricName.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DistributionMetricName> knownValues() {
        return Stream.of(DistributionMetricName.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

