/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum MetricName {
    CPU_UTILIZATION("CPUUtilization"),
    NETWORK_IN("NetworkIn"),
    NETWORK_OUT("NetworkOut"),
    STATUS_CHECK_FAILED("StatusCheckFailed"),
    STATUS_CHECK_FAILED_INSTANCE("StatusCheckFailed_Instance"),
    STATUS_CHECK_FAILED_SYSTEM("StatusCheckFailed_System"),
    CLIENT_TLS_NEGOTIATION_ERROR_COUNT("ClientTLSNegotiationErrorCount"),
    HEALTHY_HOST_COUNT("HealthyHostCount"),
    UNHEALTHY_HOST_COUNT("UnhealthyHostCount"),
    HTTP_CODE_LB_4_XX_COUNT("HTTPCode_LB_4XX_Count"),
    HTTP_CODE_LB_5_XX_COUNT("HTTPCode_LB_5XX_Count"),
    HTTP_CODE_INSTANCE_2_XX_COUNT("HTTPCode_Instance_2XX_Count"),
    HTTP_CODE_INSTANCE_3_XX_COUNT("HTTPCode_Instance_3XX_Count"),
    HTTP_CODE_INSTANCE_4_XX_COUNT("HTTPCode_Instance_4XX_Count"),
    HTTP_CODE_INSTANCE_5_XX_COUNT("HTTPCode_Instance_5XX_Count"),
    INSTANCE_RESPONSE_TIME("InstanceResponseTime"),
    REJECTED_CONNECTION_COUNT("RejectedConnectionCount"),
    REQUEST_COUNT("RequestCount"),
    DATABASE_CONNECTIONS("DatabaseConnections"),
    DISK_QUEUE_DEPTH("DiskQueueDepth"),
    FREE_STORAGE_SPACE("FreeStorageSpace"),
    NETWORK_RECEIVE_THROUGHPUT("NetworkReceiveThroughput"),
    NETWORK_TRANSMIT_THROUGHPUT("NetworkTransmitThroughput"),
    BURST_CAPACITY_TIME("BurstCapacityTime"),
    BURST_CAPACITY_PERCENTAGE("BurstCapacityPercentage"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private MetricName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MetricName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(MetricName.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MetricName> knownValues() {
        return Stream.of(MetricName.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

