/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.AlarmState;
import software.amazon.awssdk.services.lightsail.model.ComparisonOperator;
import software.amazon.awssdk.services.lightsail.model.ContactProtocol;
import software.amazon.awssdk.services.lightsail.model.ContactProtocolsListCopier;
import software.amazon.awssdk.services.lightsail.model.MetricName;
import software.amazon.awssdk.services.lightsail.model.MetricStatistic;
import software.amazon.awssdk.services.lightsail.model.MetricUnit;
import software.amazon.awssdk.services.lightsail.model.MonitoredResourceInfo;
import software.amazon.awssdk.services.lightsail.model.NotificationTriggerListCopier;
import software.amazon.awssdk.services.lightsail.model.ResourceLocation;
import software.amazon.awssdk.services.lightsail.model.ResourceType;
import software.amazon.awssdk.services.lightsail.model.TreatMissingData;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Alarm
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Alarm> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Alarm.getter(Alarm::name)).setter(Alarm.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Alarm.getter(Alarm::arn)).setter(Alarm.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Alarm.getter(Alarm::createdAt)).setter(Alarm.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<ResourceLocation> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Alarm.getter(Alarm::location)).setter(Alarm.setter(Builder::location)).constructor(ResourceLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Alarm.getter(Alarm::resourceTypeAsString)).setter(Alarm.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<String> SUPPORT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Alarm.getter(Alarm::supportCode)).setter(Alarm.setter(Builder::supportCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportCode").build()}).build();
    private static final SdkField<MonitoredResourceInfo> MONITORED_RESOURCE_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Alarm.getter(Alarm::monitoredResourceInfo)).setter(Alarm.setter(Builder::monitoredResourceInfo)).constructor(MonitoredResourceInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monitoredResourceInfo").build()}).build();
    private static final SdkField<String> COMPARISON_OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Alarm.getter(Alarm::comparisonOperatorAsString)).setter(Alarm.setter(Builder::comparisonOperator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comparisonOperator").build()}).build();
    private static final SdkField<Integer> EVALUATION_PERIODS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Alarm.getter(Alarm::evaluationPeriods)).setter(Alarm.setter(Builder::evaluationPeriods)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationPeriods").build()}).build();
    private static final SdkField<Integer> PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Alarm.getter(Alarm::period)).setter(Alarm.setter(Builder::period)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("period").build()}).build();
    private static final SdkField<Double> THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(Alarm.getter(Alarm::threshold)).setter(Alarm.setter(Builder::threshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threshold").build()}).build();
    private static final SdkField<Integer> DATAPOINTS_TO_ALARM_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Alarm.getter(Alarm::datapointsToAlarm)).setter(Alarm.setter(Builder::datapointsToAlarm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datapointsToAlarm").build()}).build();
    private static final SdkField<String> TREAT_MISSING_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Alarm.getter(Alarm::treatMissingDataAsString)).setter(Alarm.setter(Builder::treatMissingData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("treatMissingData").build()}).build();
    private static final SdkField<String> STATISTIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Alarm.getter(Alarm::statisticAsString)).setter(Alarm.setter(Builder::statistic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statistic").build()}).build();
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Alarm.getter(Alarm::metricNameAsString)).setter(Alarm.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricName").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Alarm.getter(Alarm::stateAsString)).setter(Alarm.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Alarm.getter(Alarm::unitAsString)).setter(Alarm.setter(Builder::unit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()}).build();
    private static final SdkField<List<String>> CONTACT_PROTOCOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Alarm.getter(Alarm::contactProtocolsAsStrings)).setter(Alarm.setter(Builder::contactProtocolsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contactProtocols").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NOTIFICATION_TRIGGERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Alarm.getter(Alarm::notificationTriggersAsStrings)).setter(Alarm.setter(Builder::notificationTriggersWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationTriggers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> NOTIFICATION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(Alarm.getter(Alarm::notificationEnabled)).setter(Alarm.setter(Builder::notificationEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD, CREATED_AT_FIELD, LOCATION_FIELD, RESOURCE_TYPE_FIELD, SUPPORT_CODE_FIELD, MONITORED_RESOURCE_INFO_FIELD, COMPARISON_OPERATOR_FIELD, EVALUATION_PERIODS_FIELD, PERIOD_FIELD, THRESHOLD_FIELD, DATAPOINTS_TO_ALARM_FIELD, TREAT_MISSING_DATA_FIELD, STATISTIC_FIELD, METRIC_NAME_FIELD, STATE_FIELD, UNIT_FIELD, CONTACT_PROTOCOLS_FIELD, NOTIFICATION_TRIGGERS_FIELD, NOTIFICATION_ENABLED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String arn;
    private final Instant createdAt;
    private final ResourceLocation location;
    private final String resourceType;
    private final String supportCode;
    private final MonitoredResourceInfo monitoredResourceInfo;
    private final String comparisonOperator;
    private final Integer evaluationPeriods;
    private final Integer period;
    private final Double threshold;
    private final Integer datapointsToAlarm;
    private final String treatMissingData;
    private final String statistic;
    private final String metricName;
    private final String state;
    private final String unit;
    private final List<String> contactProtocols;
    private final List<String> notificationTriggers;
    private final Boolean notificationEnabled;

    private Alarm(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.location = builder.location;
        this.resourceType = builder.resourceType;
        this.supportCode = builder.supportCode;
        this.monitoredResourceInfo = builder.monitoredResourceInfo;
        this.comparisonOperator = builder.comparisonOperator;
        this.evaluationPeriods = builder.evaluationPeriods;
        this.period = builder.period;
        this.threshold = builder.threshold;
        this.datapointsToAlarm = builder.datapointsToAlarm;
        this.treatMissingData = builder.treatMissingData;
        this.statistic = builder.statistic;
        this.metricName = builder.metricName;
        this.state = builder.state;
        this.unit = builder.unit;
        this.contactProtocols = builder.contactProtocols;
        this.notificationTriggers = builder.notificationTriggers;
        this.notificationEnabled = builder.notificationEnabled;
    }

    public String name() {
        return this.name;
    }

    public String arn() {
        return this.arn;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public ResourceLocation location() {
        return this.location;
    }

    public ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public String resourceTypeAsString() {
        return this.resourceType;
    }

    public String supportCode() {
        return this.supportCode;
    }

    public MonitoredResourceInfo monitoredResourceInfo() {
        return this.monitoredResourceInfo;
    }

    public ComparisonOperator comparisonOperator() {
        return ComparisonOperator.fromValue(this.comparisonOperator);
    }

    public String comparisonOperatorAsString() {
        return this.comparisonOperator;
    }

    public Integer evaluationPeriods() {
        return this.evaluationPeriods;
    }

    public Integer period() {
        return this.period;
    }

    public Double threshold() {
        return this.threshold;
    }

    public Integer datapointsToAlarm() {
        return this.datapointsToAlarm;
    }

    public TreatMissingData treatMissingData() {
        return TreatMissingData.fromValue(this.treatMissingData);
    }

    public String treatMissingDataAsString() {
        return this.treatMissingData;
    }

    public MetricStatistic statistic() {
        return MetricStatistic.fromValue(this.statistic);
    }

    public String statisticAsString() {
        return this.statistic;
    }

    public MetricName metricName() {
        return MetricName.fromValue(this.metricName);
    }

    public String metricNameAsString() {
        return this.metricName;
    }

    public AlarmState state() {
        return AlarmState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public MetricUnit unit() {
        return MetricUnit.fromValue(this.unit);
    }

    public String unitAsString() {
        return this.unit;
    }

    public List<ContactProtocol> contactProtocols() {
        return ContactProtocolsListCopier.copyStringToEnum(this.contactProtocols);
    }

    public boolean hasContactProtocols() {
        return this.contactProtocols != null && !(this.contactProtocols instanceof SdkAutoConstructList);
    }

    public List<String> contactProtocolsAsStrings() {
        return this.contactProtocols;
    }

    public List<AlarmState> notificationTriggers() {
        return NotificationTriggerListCopier.copyStringToEnum(this.notificationTriggers);
    }

    public boolean hasNotificationTriggers() {
        return this.notificationTriggers != null && !(this.notificationTriggers instanceof SdkAutoConstructList);
    }

    public List<String> notificationTriggersAsStrings() {
        return this.notificationTriggers;
    }

    public Boolean notificationEnabled() {
        return this.notificationEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoredResourceInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.comparisonOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationPeriods());
        hashCode = 31 * hashCode + Objects.hashCode(this.period());
        hashCode = 31 * hashCode + Objects.hashCode(this.threshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.datapointsToAlarm());
        hashCode = 31 * hashCode + Objects.hashCode(this.treatMissingDataAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statisticAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.unitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactProtocolsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationTriggersAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationEnabled());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Alarm)) {
            return false;
        }
        Alarm other = (Alarm)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.supportCode(), other.supportCode()) && Objects.equals(this.monitoredResourceInfo(), other.monitoredResourceInfo()) && Objects.equals(this.comparisonOperatorAsString(), other.comparisonOperatorAsString()) && Objects.equals(this.evaluationPeriods(), other.evaluationPeriods()) && Objects.equals(this.period(), other.period()) && Objects.equals(this.threshold(), other.threshold()) && Objects.equals(this.datapointsToAlarm(), other.datapointsToAlarm()) && Objects.equals(this.treatMissingDataAsString(), other.treatMissingDataAsString()) && Objects.equals(this.statisticAsString(), other.statisticAsString()) && Objects.equals(this.metricNameAsString(), other.metricNameAsString()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.unitAsString(), other.unitAsString()) && Objects.equals(this.contactProtocolsAsStrings(), other.contactProtocolsAsStrings()) && Objects.equals(this.notificationTriggersAsStrings(), other.notificationTriggersAsStrings()) && Objects.equals(this.notificationEnabled(), other.notificationEnabled());
    }

    public String toString() {
        return ToString.builder((String)"Alarm").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("CreatedAt", (Object)this.createdAt()).add("Location", (Object)this.location()).add("ResourceType", (Object)this.resourceTypeAsString()).add("SupportCode", (Object)this.supportCode()).add("MonitoredResourceInfo", (Object)this.monitoredResourceInfo()).add("ComparisonOperator", (Object)this.comparisonOperatorAsString()).add("EvaluationPeriods", (Object)this.evaluationPeriods()).add("Period", (Object)this.period()).add("Threshold", (Object)this.threshold()).add("DatapointsToAlarm", (Object)this.datapointsToAlarm()).add("TreatMissingData", (Object)this.treatMissingDataAsString()).add("Statistic", (Object)this.statisticAsString()).add("MetricName", (Object)this.metricNameAsString()).add("State", (Object)this.stateAsString()).add("Unit", (Object)this.unitAsString()).add("ContactProtocols", this.contactProtocolsAsStrings()).add("NotificationTriggers", this.notificationTriggersAsStrings()).add("NotificationEnabled", (Object)this.notificationEnabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "supportCode": {
                return Optional.ofNullable(clazz.cast(this.supportCode()));
            }
            case "monitoredResourceInfo": {
                return Optional.ofNullable(clazz.cast(this.monitoredResourceInfo()));
            }
            case "comparisonOperator": {
                return Optional.ofNullable(clazz.cast(this.comparisonOperatorAsString()));
            }
            case "evaluationPeriods": {
                return Optional.ofNullable(clazz.cast(this.evaluationPeriods()));
            }
            case "period": {
                return Optional.ofNullable(clazz.cast(this.period()));
            }
            case "threshold": {
                return Optional.ofNullable(clazz.cast(this.threshold()));
            }
            case "datapointsToAlarm": {
                return Optional.ofNullable(clazz.cast(this.datapointsToAlarm()));
            }
            case "treatMissingData": {
                return Optional.ofNullable(clazz.cast(this.treatMissingDataAsString()));
            }
            case "statistic": {
                return Optional.ofNullable(clazz.cast(this.statisticAsString()));
            }
            case "metricName": {
                return Optional.ofNullable(clazz.cast(this.metricNameAsString()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "unit": {
                return Optional.ofNullable(clazz.cast(this.unitAsString()));
            }
            case "contactProtocols": {
                return Optional.ofNullable(clazz.cast(this.contactProtocolsAsStrings()));
            }
            case "notificationTriggers": {
                return Optional.ofNullable(clazz.cast(this.notificationTriggersAsStrings()));
            }
            case "notificationEnabled": {
                return Optional.ofNullable(clazz.cast(this.notificationEnabled()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Alarm, T> g) {
        return obj -> g.apply((Alarm)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private Instant createdAt;
        private ResourceLocation location;
        private String resourceType;
        private String supportCode;
        private MonitoredResourceInfo monitoredResourceInfo;
        private String comparisonOperator;
        private Integer evaluationPeriods;
        private Integer period;
        private Double threshold;
        private Integer datapointsToAlarm;
        private String treatMissingData;
        private String statistic;
        private String metricName;
        private String state;
        private String unit;
        private List<String> contactProtocols = DefaultSdkAutoConstructList.getInstance();
        private List<String> notificationTriggers = DefaultSdkAutoConstructList.getInstance();
        private Boolean notificationEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(Alarm model) {
            this.name(model.name);
            this.arn(model.arn);
            this.createdAt(model.createdAt);
            this.location(model.location);
            this.resourceType(model.resourceType);
            this.supportCode(model.supportCode);
            this.monitoredResourceInfo(model.monitoredResourceInfo);
            this.comparisonOperator(model.comparisonOperator);
            this.evaluationPeriods(model.evaluationPeriods);
            this.period(model.period);
            this.threshold(model.threshold);
            this.datapointsToAlarm(model.datapointsToAlarm);
            this.treatMissingData(model.treatMissingData);
            this.statistic(model.statistic);
            this.metricName(model.metricName);
            this.state(model.state);
            this.unit(model.unit);
            this.contactProtocolsWithStrings(model.contactProtocols);
            this.notificationTriggersWithStrings(model.notificationTriggers);
            this.notificationEnabled(model.notificationEnabled);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final ResourceLocation.Builder getLocation() {
            return this.location != null ? this.location.toBuilder() : null;
        }

        @Override
        public final Builder location(ResourceLocation location) {
            this.location = location;
            return this;
        }

        public final void setLocation(ResourceLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        public final String getResourceTypeAsString() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getSupportCode() {
            return this.supportCode;
        }

        @Override
        public final Builder supportCode(String supportCode) {
            this.supportCode = supportCode;
            return this;
        }

        public final void setSupportCode(String supportCode) {
            this.supportCode = supportCode;
        }

        public final MonitoredResourceInfo.Builder getMonitoredResourceInfo() {
            return this.monitoredResourceInfo != null ? this.monitoredResourceInfo.toBuilder() : null;
        }

        @Override
        public final Builder monitoredResourceInfo(MonitoredResourceInfo monitoredResourceInfo) {
            this.monitoredResourceInfo = monitoredResourceInfo;
            return this;
        }

        public final void setMonitoredResourceInfo(MonitoredResourceInfo.BuilderImpl monitoredResourceInfo) {
            this.monitoredResourceInfo = monitoredResourceInfo != null ? monitoredResourceInfo.build() : null;
        }

        public final String getComparisonOperatorAsString() {
            return this.comparisonOperator;
        }

        @Override
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        @Override
        public final Builder comparisonOperator(ComparisonOperator comparisonOperator) {
            this.comparisonOperator(comparisonOperator == null ? null : comparisonOperator.toString());
            return this;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        public final Integer getEvaluationPeriods() {
            return this.evaluationPeriods;
        }

        @Override
        public final Builder evaluationPeriods(Integer evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
            return this;
        }

        public final void setEvaluationPeriods(Integer evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
        }

        public final Integer getPeriod() {
            return this.period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        public final Double getThreshold() {
            return this.threshold;
        }

        @Override
        public final Builder threshold(Double threshold) {
            this.threshold = threshold;
            return this;
        }

        public final void setThreshold(Double threshold) {
            this.threshold = threshold;
        }

        public final Integer getDatapointsToAlarm() {
            return this.datapointsToAlarm;
        }

        @Override
        public final Builder datapointsToAlarm(Integer datapointsToAlarm) {
            this.datapointsToAlarm = datapointsToAlarm;
            return this;
        }

        public final void setDatapointsToAlarm(Integer datapointsToAlarm) {
            this.datapointsToAlarm = datapointsToAlarm;
        }

        public final String getTreatMissingDataAsString() {
            return this.treatMissingData;
        }

        @Override
        public final Builder treatMissingData(String treatMissingData) {
            this.treatMissingData = treatMissingData;
            return this;
        }

        @Override
        public final Builder treatMissingData(TreatMissingData treatMissingData) {
            this.treatMissingData(treatMissingData == null ? null : treatMissingData.toString());
            return this;
        }

        public final void setTreatMissingData(String treatMissingData) {
            this.treatMissingData = treatMissingData;
        }

        public final String getStatisticAsString() {
            return this.statistic;
        }

        @Override
        public final Builder statistic(String statistic) {
            this.statistic = statistic;
            return this;
        }

        @Override
        public final Builder statistic(MetricStatistic statistic) {
            this.statistic(statistic == null ? null : statistic.toString());
            return this;
        }

        public final void setStatistic(String statistic) {
            this.statistic = statistic;
        }

        public final String getMetricNameAsString() {
            return this.metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        @Override
        public final Builder metricName(MetricName metricName) {
            this.metricName(metricName == null ? null : metricName.toString());
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final String getStateAsString() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(AlarmState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getUnitAsString() {
            return this.unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(MetricUnit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        public final Collection<String> getContactProtocolsAsStrings() {
            return this.contactProtocols;
        }

        @Override
        public final Builder contactProtocolsWithStrings(Collection<String> contactProtocols) {
            this.contactProtocols = ContactProtocolsListCopier.copy(contactProtocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contactProtocolsWithStrings(String ... contactProtocols) {
            this.contactProtocolsWithStrings(Arrays.asList(contactProtocols));
            return this;
        }

        @Override
        public final Builder contactProtocols(Collection<ContactProtocol> contactProtocols) {
            this.contactProtocols = ContactProtocolsListCopier.copyEnumToString(contactProtocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contactProtocols(ContactProtocol ... contactProtocols) {
            this.contactProtocols(Arrays.asList(contactProtocols));
            return this;
        }

        public final void setContactProtocolsWithStrings(Collection<String> contactProtocols) {
            this.contactProtocols = ContactProtocolsListCopier.copy(contactProtocols);
        }

        public final Collection<String> getNotificationTriggersAsStrings() {
            return this.notificationTriggers;
        }

        @Override
        public final Builder notificationTriggersWithStrings(Collection<String> notificationTriggers) {
            this.notificationTriggers = NotificationTriggerListCopier.copy(notificationTriggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationTriggersWithStrings(String ... notificationTriggers) {
            this.notificationTriggersWithStrings(Arrays.asList(notificationTriggers));
            return this;
        }

        @Override
        public final Builder notificationTriggers(Collection<AlarmState> notificationTriggers) {
            this.notificationTriggers = NotificationTriggerListCopier.copyEnumToString(notificationTriggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationTriggers(AlarmState ... notificationTriggers) {
            this.notificationTriggers(Arrays.asList(notificationTriggers));
            return this;
        }

        public final void setNotificationTriggersWithStrings(Collection<String> notificationTriggers) {
            this.notificationTriggers = NotificationTriggerListCopier.copy(notificationTriggers);
        }

        public final Boolean getNotificationEnabled() {
            return this.notificationEnabled;
        }

        @Override
        public final Builder notificationEnabled(Boolean notificationEnabled) {
            this.notificationEnabled = notificationEnabled;
            return this;
        }

        public final void setNotificationEnabled(Boolean notificationEnabled) {
            this.notificationEnabled = notificationEnabled;
        }

        public Alarm build() {
            return new Alarm(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Alarm> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder createdAt(Instant var1);

        public Builder location(ResourceLocation var1);

        default public Builder location(Consumer<ResourceLocation.Builder> location) {
            return this.location((ResourceLocation)((ResourceLocation.Builder)ResourceLocation.builder().applyMutation(location)).build());
        }

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder supportCode(String var1);

        public Builder monitoredResourceInfo(MonitoredResourceInfo var1);

        default public Builder monitoredResourceInfo(Consumer<MonitoredResourceInfo.Builder> monitoredResourceInfo) {
            return this.monitoredResourceInfo((MonitoredResourceInfo)((MonitoredResourceInfo.Builder)MonitoredResourceInfo.builder().applyMutation(monitoredResourceInfo)).build());
        }

        public Builder comparisonOperator(String var1);

        public Builder comparisonOperator(ComparisonOperator var1);

        public Builder evaluationPeriods(Integer var1);

        public Builder period(Integer var1);

        public Builder threshold(Double var1);

        public Builder datapointsToAlarm(Integer var1);

        public Builder treatMissingData(String var1);

        public Builder treatMissingData(TreatMissingData var1);

        public Builder statistic(String var1);

        public Builder statistic(MetricStatistic var1);

        public Builder metricName(String var1);

        public Builder metricName(MetricName var1);

        public Builder state(String var1);

        public Builder state(AlarmState var1);

        public Builder unit(String var1);

        public Builder unit(MetricUnit var1);

        public Builder contactProtocolsWithStrings(Collection<String> var1);

        public Builder contactProtocolsWithStrings(String ... var1);

        public Builder contactProtocols(Collection<ContactProtocol> var1);

        public Builder contactProtocols(ContactProtocol ... var1);

        public Builder notificationTriggersWithStrings(Collection<String> var1);

        public Builder notificationTriggersWithStrings(String ... var1);

        public Builder notificationTriggers(Collection<AlarmState> var1);

        public Builder notificationTriggers(AlarmState ... var1);

        public Builder notificationEnabled(Boolean var1);
    }
}

