/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.services.lightsail.model.MetricStatistic;
import software.amazon.awssdk.services.lightsail.model.MetricStatisticListCopier;
import software.amazon.awssdk.services.lightsail.model.MetricUnit;
import software.amazon.awssdk.services.lightsail.model.RelationalDatabaseMetricName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRelationalDatabaseMetricDataRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, GetRelationalDatabaseMetricDataRequest> {
    private static final SdkField<String> RELATIONAL_DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetRelationalDatabaseMetricDataRequest.getter(GetRelationalDatabaseMetricDataRequest::relationalDatabaseName)).setter(GetRelationalDatabaseMetricDataRequest.setter(Builder::relationalDatabaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationalDatabaseName").build()}).build();
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetRelationalDatabaseMetricDataRequest.getter(GetRelationalDatabaseMetricDataRequest::metricNameAsString)).setter(GetRelationalDatabaseMetricDataRequest.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricName").build()}).build();
    private static final SdkField<Integer> PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(GetRelationalDatabaseMetricDataRequest.getter(GetRelationalDatabaseMetricDataRequest::period)).setter(GetRelationalDatabaseMetricDataRequest.setter(Builder::period)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("period").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(GetRelationalDatabaseMetricDataRequest.getter(GetRelationalDatabaseMetricDataRequest::startTime)).setter(GetRelationalDatabaseMetricDataRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(GetRelationalDatabaseMetricDataRequest.getter(GetRelationalDatabaseMetricDataRequest::endTime)).setter(GetRelationalDatabaseMetricDataRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<String> UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetRelationalDatabaseMetricDataRequest.getter(GetRelationalDatabaseMetricDataRequest::unitAsString)).setter(GetRelationalDatabaseMetricDataRequest.setter(Builder::unit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()}).build();
    private static final SdkField<List<String>> STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetRelationalDatabaseMetricDataRequest.getter(GetRelationalDatabaseMetricDataRequest::statisticsAsStrings)).setter(GetRelationalDatabaseMetricDataRequest.setter(Builder::statisticsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statistics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RELATIONAL_DATABASE_NAME_FIELD, METRIC_NAME_FIELD, PERIOD_FIELD, START_TIME_FIELD, END_TIME_FIELD, UNIT_FIELD, STATISTICS_FIELD));
    private final String relationalDatabaseName;
    private final String metricName;
    private final Integer period;
    private final Instant startTime;
    private final Instant endTime;
    private final String unit;
    private final List<String> statistics;

    private GetRelationalDatabaseMetricDataRequest(BuilderImpl builder) {
        super(builder);
        this.relationalDatabaseName = builder.relationalDatabaseName;
        this.metricName = builder.metricName;
        this.period = builder.period;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.unit = builder.unit;
        this.statistics = builder.statistics;
    }

    public String relationalDatabaseName() {
        return this.relationalDatabaseName;
    }

    public RelationalDatabaseMetricName metricName() {
        return RelationalDatabaseMetricName.fromValue(this.metricName);
    }

    public String metricNameAsString() {
        return this.metricName;
    }

    public Integer period() {
        return this.period;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public MetricUnit unit() {
        return MetricUnit.fromValue(this.unit);
    }

    public String unitAsString() {
        return this.unit;
    }

    public List<MetricStatistic> statistics() {
        return TypeConverter.convert(this.statistics, MetricStatistic::fromValue);
    }

    public List<String> statisticsAsStrings() {
        return this.statistics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.relationalDatabaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.period());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.unitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statisticsAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRelationalDatabaseMetricDataRequest)) {
            return false;
        }
        GetRelationalDatabaseMetricDataRequest other = (GetRelationalDatabaseMetricDataRequest)((Object)obj);
        return Objects.equals(this.relationalDatabaseName(), other.relationalDatabaseName()) && Objects.equals(this.metricNameAsString(), other.metricNameAsString()) && Objects.equals(this.period(), other.period()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.unitAsString(), other.unitAsString()) && Objects.equals(this.statisticsAsStrings(), other.statisticsAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"GetRelationalDatabaseMetricDataRequest").add("RelationalDatabaseName", (Object)this.relationalDatabaseName()).add("MetricName", (Object)this.metricNameAsString()).add("Period", (Object)this.period()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("Unit", (Object)this.unitAsString()).add("Statistics", this.statisticsAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "relationalDatabaseName": {
                return Optional.ofNullable(clazz.cast(this.relationalDatabaseName()));
            }
            case "metricName": {
                return Optional.ofNullable(clazz.cast(this.metricNameAsString()));
            }
            case "period": {
                return Optional.ofNullable(clazz.cast(this.period()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "unit": {
                return Optional.ofNullable(clazz.cast(this.unitAsString()));
            }
            case "statistics": {
                return Optional.ofNullable(clazz.cast(this.statisticsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRelationalDatabaseMetricDataRequest, T> g) {
        return obj -> g.apply((GetRelationalDatabaseMetricDataRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private String relationalDatabaseName;
        private String metricName;
        private Integer period;
        private Instant startTime;
        private Instant endTime;
        private String unit;
        private List<String> statistics = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetRelationalDatabaseMetricDataRequest model) {
            super(model);
            this.relationalDatabaseName(model.relationalDatabaseName);
            this.metricName(model.metricName);
            this.period(model.period);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.unit(model.unit);
            this.statisticsWithStrings(model.statistics);
        }

        public final String getRelationalDatabaseName() {
            return this.relationalDatabaseName;
        }

        @Override
        public final Builder relationalDatabaseName(String relationalDatabaseName) {
            this.relationalDatabaseName = relationalDatabaseName;
            return this;
        }

        public final void setRelationalDatabaseName(String relationalDatabaseName) {
            this.relationalDatabaseName = relationalDatabaseName;
        }

        public final String getMetricName() {
            return this.metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        @Override
        public final Builder metricName(RelationalDatabaseMetricName metricName) {
            this.metricName(metricName.toString());
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final Integer getPeriod() {
            return this.period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getUnit() {
            return this.unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(MetricUnit unit) {
            this.unit(unit.toString());
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        public final Collection<String> getStatistics() {
            return this.statistics;
        }

        @Override
        public final Builder statisticsWithStrings(Collection<String> statistics) {
            this.statistics = MetricStatisticListCopier.copy(statistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statisticsWithStrings(String ... statistics) {
            this.statisticsWithStrings(Arrays.asList(statistics));
            return this;
        }

        @Override
        public final Builder statistics(Collection<MetricStatistic> statistics) {
            this.statistics = MetricStatisticListCopier.copyEnumToString(statistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statistics(MetricStatistic ... statistics) {
            this.statistics(Arrays.asList(statistics));
            return this;
        }

        public final void setStatistics(Collection<String> statistics) {
            this.statistics = MetricStatisticListCopier.copy(statistics);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetRelationalDatabaseMetricDataRequest build() {
            return new GetRelationalDatabaseMetricDataRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRelationalDatabaseMetricDataRequest> {
        public Builder relationalDatabaseName(String var1);

        public Builder metricName(String var1);

        public Builder metricName(RelationalDatabaseMetricName var1);

        public Builder period(Integer var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder unit(String var1);

        public Builder unit(MetricUnit var1);

        public Builder statisticsWithStrings(Collection<String> var1);

        public Builder statisticsWithStrings(String ... var1);

        public Builder statistics(Collection<MetricStatistic> var1);

        public Builder statistics(MetricStatistic ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

