/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.LicenseManagerUserSubscriptionsClient;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.InstanceUserSummary;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListUserAssociationsRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListUserAssociationsResponse;

public class ListUserAssociationsIterable
implements SdkIterable<ListUserAssociationsResponse> {
    private final LicenseManagerUserSubscriptionsClient client;
    private final ListUserAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListUserAssociationsIterable(LicenseManagerUserSubscriptionsClient client, ListUserAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListUserAssociationsResponseFetcher();
    }

    public Iterator<ListUserAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<InstanceUserSummary> instanceUserSummaries() {
        Function<ListUserAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.instanceUserSummaries() != null) {
                return response.instanceUserSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListUserAssociationsResponseFetcher
    implements SyncPageFetcher<ListUserAssociationsResponse> {
        private ListUserAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListUserAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListUserAssociationsResponse nextPage(ListUserAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListUserAssociationsIterable.this.client.listUserAssociations(ListUserAssociationsIterable.this.firstRequest);
            }
            return ListUserAssociationsIterable.this.client.listUserAssociations((ListUserAssociationsRequest)((Object)ListUserAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

